/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.CancelException;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.configuration.callbacks.ConfigurationChangeListener;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.domain.SharedConfigurationStatus;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.configuration.functions.UploadJarFunction;
import org.apache.geode.management.internal.configuration.messages.ConfigurationRequest;
import org.apache.geode.management.internal.configuration.messages.ConfigurationResponse;
import org.apache.geode.management.internal.configuration.messages.SharedConfigurationStatusResponse;
import org.apache.geode.management.internal.configuration.utils.XmlUtils;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ClusterConfigurationService {
    private static final Logger logger = LogService.getLogger();
    public static final String CLUSTER_CONFIG_ARTIFACTS_DIR_NAME = "cluster_config";
    private static final String CLUSTER_CONFIG_DISK_STORE_NAME = "cluster_config";
    public static final String CLUSTER_CONFIG_DISK_DIR_PREFIX = "ConfigDiskDir_";
    public static final String CLUSTER_CONFIG = "cluster";
    private static final String SHARED_CONFIG_LOCK_SERVICE_NAME = "__CLUSTER_CONFIG_LS";
    public static final String SHARED_CONFIG_LOCK_NAME = "__CLUSTER_CONFIG_LOCK";
    private static final String CONFIG_REGION_NAME = "_ConfigurationRegion";
    private final String configDirPath;
    private final String configDiskDirPath;
    private final Set<PersistentMemberPattern> newerSharedConfigurationLocatorInfo = new HashSet<PersistentMemberPattern>();
    private final AtomicReference<SharedConfigurationStatus> status = new AtomicReference();
    private GemFireCacheImpl cache;
    private final DistributedLockService sharedConfigLockingService;

    public ClusterConfigurationService(Cache cache) throws IOException {
        this.cache = (GemFireCacheImpl)cache;
        Properties properties = cache.getDistributedSystem().getProperties();
        String clusterConfigRootDir = properties.getProperty("cluster-configuration-dir");
        if (org.apache.geode.internal.lang.StringUtils.isBlank(clusterConfigRootDir)) {
            clusterConfigRootDir = System.getProperty("user.dir");
        } else {
            File diskDir = new File(clusterConfigRootDir);
            if (!diskDir.exists() && !diskDir.mkdirs()) {
                throw new IOException("Cannot create directory : " + clusterConfigRootDir);
            }
            clusterConfigRootDir = diskDir.getCanonicalPath();
        }
        String configDiskDirName = CLUSTER_CONFIG_DISK_DIR_PREFIX + cache.getDistributedSystem().getName();
        this.configDirPath = FilenameUtils.concat(clusterConfigRootDir, "cluster_config");
        this.configDiskDirPath = FilenameUtils.concat(clusterConfigRootDir, configDiskDirName);
        this.sharedConfigLockingService = this.getSharedConfigLockService(cache.getDistributedSystem());
        this.status.set(SharedConfigurationStatus.NOT_STARTED);
    }

    private DistributedLockService getSharedConfigLockService(DistributedSystem ds) {
        DistributedLockService sharedConfigDls = DLockService.getServiceNamed(SHARED_CONFIG_LOCK_SERVICE_NAME);
        try {
            if (sharedConfigDls == null) {
                sharedConfigDls = DLockService.create(SHARED_CONFIG_LOCK_SERVICE_NAME, (InternalDistributedSystem)ds, true, true);
            }
        }
        catch (IllegalArgumentException e) {
            return DLockService.getServiceNamed(SHARED_CONFIG_LOCK_SERVICE_NAME);
        }
        return sharedConfigDls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXmlEntity(XmlEntity xmlEntity, String[] groups) {
        this.lockSharedConfiguration();
        try {
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (groups == null || groups.length == 0) {
                groups = new String[]{CLUSTER_CONFIG};
            }
            for (String group : groups) {
                String xmlContent;
                Configuration configuration = configRegion.get(group);
                if (configuration == null) {
                    configuration = new Configuration(group);
                }
                if ((xmlContent = configuration.getCacheXmlContent()) == null || xmlContent.isEmpty()) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    CacheXmlGenerator.generateDefault(pw);
                    xmlContent = sw.toString();
                }
                try {
                    Document doc = XmlUtils.createAndUpgradeDocumentFromXml(xmlContent);
                    XmlUtils.addNewNode(doc, xmlEntity);
                    configuration.setCacheXmlContent(XmlUtils.prettyXml(doc));
                    configRegion.put(group, configuration);
                }
                catch (Exception e) {
                    logger.error("error updating cluster configuration for group " + group, (Throwable)e);
                }
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteXmlEntity(XmlEntity xmlEntity, String[] groups) {
        this.lockSharedConfiguration();
        try {
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (groups == null) {
                Set<String> groupSet = configRegion.keySet();
                groups = groupSet.toArray(new String[groupSet.size()]);
            }
            for (String group : groups) {
                Configuration configuration = configRegion.get(group);
                if (configuration == null) continue;
                String xmlContent = configuration.getCacheXmlContent();
                try {
                    if (xmlContent == null || xmlContent.isEmpty()) continue;
                    Document doc = XmlUtils.createAndUpgradeDocumentFromXml(xmlContent);
                    XmlUtils.deleteNode(doc, xmlEntity);
                    configuration.setCacheXmlContent(XmlUtils.prettyXml(doc));
                    configRegion.put(group, configuration);
                }
                catch (Exception e) {
                    logger.error("error updating cluster configuration for group " + group, (Throwable)e);
                }
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyXmlAndProperties(Properties properties, XmlEntity xmlEntity, String[] groups) {
        this.lockSharedConfiguration();
        try {
            if (groups == null) {
                groups = new String[]{CLUSTER_CONFIG};
            }
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            for (String group : groups) {
                Configuration configuration = configRegion.get(group);
                if (configuration == null) {
                    configuration = new Configuration(group);
                }
                if (xmlEntity != null) {
                    String xmlContent = configuration.getCacheXmlContent();
                    if (xmlContent == null || xmlContent.isEmpty()) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        CacheXmlGenerator.generateDefault(pw);
                        xmlContent = sw.toString();
                    }
                    try {
                        Document doc = XmlUtils.createAndUpgradeDocumentFromXml(xmlContent);
                        XmlUtils.modifyRootAttributes(doc, xmlEntity);
                        configuration.setCacheXmlContent(XmlUtils.prettyXml(doc));
                    }
                    catch (Exception e) {
                        logger.error("error updating cluster configuration for group " + group, (Throwable)e);
                    }
                }
                if (properties != null) {
                    configuration.getGemfireProperties().putAll((Map<?, ?>)properties);
                }
                configRegion.put(group, configuration);
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addJarsToThisLocator(String[] jarNames, byte[][] jarBytes, String[] groups) {
        boolean success = true;
        this.lockSharedConfiguration();
        try {
            if (groups == null) {
                groups = new String[]{CLUSTER_CONFIG};
            }
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            for (String group : groups) {
                Configuration configuration = configRegion.get(group);
                if (configuration == null) {
                    configuration = new Configuration(group);
                    this.createConfigDirIfNecessary(group);
                }
                String groupDir = FilenameUtils.concat(this.configDirPath, group);
                for (int i = 0; i < jarNames.length; ++i) {
                    String filePath = FilenameUtils.concat(groupDir, jarNames[i]);
                    File jarFile = new File(filePath);
                    try {
                        FileUtils.writeByteArrayToFile(jarFile, jarBytes[i]);
                        continue;
                    }
                    catch (IOException e) {
                        logger.info(e);
                    }
                }
                Configuration configurationCopy = new Configuration(configuration);
                configurationCopy.addJarNames(jarNames);
                configRegion.put(group, configurationCopy);
            }
        }
        catch (Exception e) {
            success = false;
            logger.info(e.getMessage(), (Throwable)e);
        }
        finally {
            this.unlockSharedConfiguration();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJars(String[] jarNames, String[] groups) {
        boolean success = true;
        this.lockSharedConfiguration();
        try {
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (groups == null) {
                groups = (String[])configRegion.keySet().stream().toArray(String[]::new);
            }
            for (String group : groups) {
                Configuration configuration = configRegion.get(group);
                if (configuration == null) {
                    break;
                }
                Configuration configurationCopy = new Configuration(configuration);
                configurationCopy.removeJarNames(jarNames);
                configRegion.put(group, configurationCopy);
            }
        }
        catch (Exception e) {
            logger.info("Exception occurred while deleting the jar files", (Throwable)e);
            success = false;
        }
        finally {
            this.unlockSharedConfiguration();
        }
        return success;
    }

    public byte[] getJarBytesFromThisLocator(String group, String jarName) throws Exception {
        Configuration configuration = this.getConfiguration(group);
        File jar = this.getPathToJarOnThisLocator(group, jarName).toFile();
        if (configuration == null || !configuration.getJarNames().contains(jarName) || !jar.exists()) {
            return null;
        }
        return FileUtils.readFileToByteArray(jar);
    }

    public void downloadJarFromOtherLocators(String groupName, String jarName) throws Exception {
        logger.info("Getting Jar files from other locators");
        DM dm = this.cache.getDistributionManager();
        InternalDistributedMember me = this.cache.getMyId();
        HashSet<InternalDistributedMember> locators = new HashSet<InternalDistributedMember>(dm.getAllHostedLocatorsWithSharedConfiguration().keySet());
        locators.remove(me);
        this.createConfigDirIfNecessary(groupName);
        byte[] jarBytes = locators.stream().map(locator -> this.downloadJarFromLocator((DistributedMember)locator, groupName, jarName)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("No locators have a deployed jar named " + jarName + " in " + groupName));
        File jarToWrite = this.getPathToJarOnThisLocator(groupName, jarName).toFile();
        FileUtils.writeByteArrayToFile(jarToWrite, jarBytes);
    }

    public Map<String, byte[]> getAllJarsFromThisLocator(Set<String> groups) throws Exception {
        String group;
        Configuration groupConfig;
        HashMap<String, byte[]> jarNamesToJarBytes = new HashMap<String, byte[]>();
        Iterator<String> iterator = groups.iterator();
        while (iterator.hasNext() && (groupConfig = this.getConfiguration(group = iterator.next())) != null) {
            Set<String> jars = groupConfig.getJarNames();
            for (String jar : jars) {
                byte[] jarBytes = this.getJarBytesFromThisLocator(group, jar);
                jarNamesToJarBytes.put(jar, jarBytes);
            }
        }
        return jarNamesToJarBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSharedConfiguration(boolean loadSharedConfigFromDir) throws Exception {
        this.status.set(SharedConfigurationStatus.STARTED);
        Region<String, Configuration> configRegion = this.getConfigurationRegion();
        this.lockSharedConfiguration();
        try {
            if (loadSharedConfigFromDir) {
                logger.info("Reading cluster configuration from '{}' directory", (Object)"cluster_config");
                this.loadSharedConfigurationFromDisk();
            } else {
                this.persistSecuritySettings(configRegion);
                Set<String> groups = configRegion.keySet();
                for (String group : groups) {
                    Configuration config = configRegion.get(group);
                    for (String jar : config.getJarNames()) {
                        if (this.getPathToJarOnThisLocator(group, jar).toFile().exists()) continue;
                        this.downloadJarFromOtherLocators(group, jar);
                    }
                }
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
        this.status.set(SharedConfigurationStatus.RUNNING);
    }

    private void persistSecuritySettings(Region<String, Configuration> configRegion) {
        Properties securityProps = this.cache.getDistributedSystem().getSecurityProperties();
        Configuration clusterPropertiesConfig = configRegion.get(CLUSTER_CONFIG);
        if (clusterPropertiesConfig == null) {
            clusterPropertiesConfig = new Configuration(CLUSTER_CONFIG);
            configRegion.put(CLUSTER_CONFIG, clusterPropertiesConfig);
        }
        Properties clusterProperties = clusterPropertiesConfig.getGemfireProperties();
        if (securityProps.containsKey("security-manager")) {
            clusterProperties.setProperty("security-manager", securityProps.getProperty("security-manager"));
        }
        if (securityProps.containsKey("security-post-processor")) {
            clusterProperties.setProperty("security-post-processor", securityProps.getProperty("security-post-processor"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationResponse createConfigurationReponse(ConfigurationRequest configRequest) throws Exception {
        ConfigurationResponse configResponse = new ConfigurationResponse();
        for (int i = 0; i < configRequest.getNumAttempts(); ++i) {
            boolean isLocked = this.sharedConfigLockingService.lock(SHARED_CONFIG_LOCK_NAME, 5000L, 5000L);
            try {
                if (!isLocked) continue;
                Set<String> groups = configRequest.getGroups();
                groups.add(CLUSTER_CONFIG);
                logger.info("Building up configuration response with following configurations: {}", (Object)groups);
                for (String group : groups) {
                    Configuration configuration = this.getConfiguration(group);
                    configResponse.addConfiguration(configuration);
                }
                Map<String, byte[]> jarNamesToJarBytes = this.getAllJarsFromThisLocator(groups);
                String[] jarNames = (String[])jarNamesToJarBytes.keySet().stream().toArray(String[]::new);
                byte[][] jarBytes = (byte[][])jarNamesToJarBytes.values().toArray((T[])new byte[jarNames.length][]);
                configResponse.addJarsToBeDeployed(jarNames, jarBytes);
                configResponse.setFailedToGetSharedConfig(false);
                ConfigurationResponse configurationResponse = configResponse;
                return configurationResponse;
            }
            finally {
                this.sharedConfigLockingService.unlock(SHARED_CONFIG_LOCK_NAME);
            }
        }
        configResponse.setFailedToGetSharedConfig(true);
        return configResponse;
    }

    public SharedConfigurationStatusResponse createStatusResponse() {
        SharedConfigurationStatusResponse response = new SharedConfigurationStatusResponse();
        response.setStatus(this.getStatus());
        response.addWaitingLocatorInfo(this.newerSharedConfigurationLocatorInfo);
        return response;
    }

    public void destroySharedConfiguration() {
        try {
            DiskStore configDiskStore;
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (configRegion != null) {
                configRegion.destroyRegion();
            }
            if ((configDiskStore = this.cache.findDiskStore("cluster_config")) != null) {
                configDiskStore.destroy();
                File file = new File(this.configDiskDirPath);
                FileUtils.deleteDirectory(file);
            }
            FileUtils.deleteDirectory(new File(this.configDirPath));
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public Path getPathToJarOnThisLocator(String groupName, String jarName) {
        return new File(this.configDirPath).toPath().resolve(groupName).resolve(jarName);
    }

    public Configuration getConfiguration(String groupName) {
        Configuration configuration = this.getConfigurationRegion().get(groupName);
        return configuration;
    }

    public Map<String, Configuration> getEntireConfiguration() throws Exception {
        Set<String> keys = this.getConfigurationRegion().keySet();
        return this.getConfigurationRegion().getAll(keys);
    }

    public String getSharedConfigurationDirPath() {
        return this.configDirPath;
    }

    public SharedConfigurationStatus getStatus() {
        PersistentMemberManager pmm;
        Map<String, Set<PersistentMemberID>> waitingRegions;
        SharedConfigurationStatus scStatus = this.status.get();
        if (scStatus == SharedConfigurationStatus.STARTED && !(waitingRegions = (pmm = this.cache.getPersistentMemberManager()).getWaitingRegions()).isEmpty()) {
            this.status.compareAndSet(SharedConfigurationStatus.STARTED, SharedConfigurationStatus.WAITING);
            Set<PersistentMemberID> persMemIds = waitingRegions.get("/_ConfigurationRegion");
            for (PersistentMemberID persMemId : persMemIds) {
                this.newerSharedConfigurationLocatorInfo.add(new PersistentMemberPattern(persMemId));
            }
        }
        return this.status.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSharedConfigurationFromDisk() throws Exception {
        this.lockSharedConfiguration();
        File[] groupNames = new File(this.configDirPath).listFiles(DirectoryFileFilter.INSTANCE);
        HashMap<String, Configuration> sharedConfiguration = new HashMap<String, Configuration>();
        try {
            for (File groupName : groupNames) {
                Configuration configuration = this.readConfiguration(groupName);
                sharedConfiguration.put(groupName.getName(), configuration);
            }
            Region<String, Configuration> clusterRegion = this.getConfigurationRegion();
            clusterRegion.clear();
            clusterRegion.putAll(sharedConfiguration);
            this.persistSecuritySettings(clusterRegion);
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    public void renameExistingSharedConfigDirectory() {
        File configDirFile = new File(this.configDirPath);
        if (configDirFile.exists()) {
            String configDirFileName2 = "cluster_config" + new SimpleDateFormat("yyyyMMddhhmm").format(new Date()) + "." + System.nanoTime();
            File configDirFile2 = new File(configDirFile.getParent(), configDirFileName2);
            try {
                FileUtils.moveDirectory(configDirFile, configDirFile2);
            }
            catch (IOException e) {
                logger.info(e);
            }
        }
    }

    public void writeConfigToFile(Configuration configuration) throws Exception {
        File configDir = this.createConfigDirIfNecessary(configuration.getConfigName());
        File propsFile = new File(configDir, configuration.getPropertiesFileName());
        BufferedWriter bw = new BufferedWriter(new FileWriter(propsFile));
        configuration.getGemfireProperties().store(bw, null);
        bw.close();
        File xmlFile = new File(configDir, configuration.getCacheXmlFileName());
        FileUtils.writeStringToFile(xmlFile, configuration.getCacheXmlContent(), "UTF-8");
    }

    private boolean lockSharedConfiguration() {
        return this.sharedConfigLockingService.lock(SHARED_CONFIG_LOCK_NAME, -1L, -1L);
    }

    private void unlockSharedConfiguration() {
        this.sharedConfigLockingService.unlock(SHARED_CONFIG_LOCK_NAME);
    }

    private byte[] downloadJarFromLocator(DistributedMember locator, String groupName, String jarName) {
        ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new UploadJarFunction(), (Object)new Object[]{groupName, jarName}, locator);
        List result = (List)rc.getResult();
        return result.stream().filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Region<String, Configuration> getConfigurationRegion() {
        Region configRegion = this.cache.getRegion(CONFIG_REGION_NAME);
        try {
            if (configRegion == null) {
                File diskDir = new File(this.configDiskDirPath);
                if (!diskDir.exists() && !diskDir.mkdirs()) {
                    throw new IOException("Cannot create directory at " + this.configDiskDirPath);
                }
                File[] diskDirs = new File[]{diskDir};
                this.cache.createDiskStoreFactory().setDiskDirs(diskDirs).setAutoCompact(true).setMaxOplogSize(10L).create("cluster_config");
                AttributesFactory<String, Configuration> regionAttrsFactory = new AttributesFactory<String, Configuration>();
                regionAttrsFactory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                regionAttrsFactory.setCacheListener(new ConfigurationChangeListener(this));
                regionAttrsFactory.setDiskStoreName("cluster_config");
                regionAttrsFactory.setScope(Scope.DISTRIBUTED_ACK);
                InternalRegionArguments internalArgs = new InternalRegionArguments();
                internalArgs.setIsUsedForMetaRegion(true);
                internalArgs.setMetaRegionWithTransactions(false);
                configRegion = this.cache.createVMRegion(CONFIG_REGION_NAME, regionAttrsFactory.create(), internalArgs);
            }
        }
        catch (CancelException e) {
            if (configRegion == null) {
                this.status.set(SharedConfigurationStatus.STOPPED);
            }
            throw e;
        }
        catch (Exception e) {
            if (configRegion == null) {
                this.status.set(SharedConfigurationStatus.STOPPED);
            }
            throw new RuntimeException("Error occurred while initializing cluster configuration", e);
        }
        return configRegion;
    }

    private Configuration readConfiguration(File groupConfigDir) throws SAXException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, IOException {
        Configuration configuration = new Configuration(groupConfigDir.getName());
        File cacheXmlFull = new File(groupConfigDir, configuration.getCacheXmlFileName());
        File propertiesFull = new File(groupConfigDir, configuration.getPropertiesFileName());
        configuration.setCacheXmlFile(cacheXmlFull);
        configuration.setPropertiesFile(propertiesFull);
        Set<String> jarFileNames = Arrays.stream(groupConfigDir.list()).filter(filename -> filename.endsWith(".jar")).collect(Collectors.toSet());
        configuration.addJarNames(jarFileNames);
        return configuration;
    }

    private File createConfigDirIfNecessary(String configName) throws Exception {
        File clusterConfigDir = new File(this.getSharedConfigurationDirPath());
        if (!clusterConfigDir.exists() && !clusterConfigDir.mkdirs()) {
            throw new IOException("Cannot create directory : " + this.getSharedConfigurationDirPath());
        }
        Path configDirPath = clusterConfigDir.toPath().resolve(configName);
        File configDir = configDirPath.toFile();
        if (!configDir.exists() && !configDir.mkdir()) {
            throw new IOException("Cannot create directory : " + configDirPath);
        }
        return configDir;
    }

    public static boolean isMisConfigured(Properties fromProps, Properties toProps, String key) {
        String fromPropValue = fromProps.getProperty(key);
        String toPropValue = toProps.getProperty(key);
        if (StringUtils.isBlank(toPropValue)) {
            return false;
        }
        if (StringUtils.isBlank(fromPropValue)) {
            return true;
        }
        return !fromPropValue.equals(toPropValue);
    }
}

