/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqListener;
import org.apache.geode.cache.query.internal.cq.CqAttributesImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CqAttributesFactory {
    private final CqAttributesImpl cqAttributes = new CqAttributesImpl();

    public CqAttributesFactory() {
    }

    public CqAttributesFactory(CqAttributes cqAttributes) {
        this.cqAttributes.setCqListeners(new ArrayList<CqListener>(Arrays.asList(cqAttributes.getCqListeners())));
    }

    public void addCqListener(CqListener cqListener) {
        if (cqListener == null) {
            throw new IllegalArgumentException(LocalizedStrings.CqAttributesFactory_ADDCQLISTENER_PARAMETER_WAS_NULL.toLocalizedString());
        }
        this.cqAttributes.addCqListener(cqListener);
    }

    public void initCqListeners(CqListener[] cqListeners) {
        if (cqListeners == null || cqListeners.length == 0) {
            this.cqAttributes.setCqListeners(null);
        } else {
            List<CqListener> nl = Arrays.asList(cqListeners);
            if (nl.contains(null)) {
                throw new IllegalArgumentException(LocalizedStrings.CqAttributesFactory_INITCQLISTENERS_PARAMETER_HAD_A_NULL_ELEMENT.toLocalizedString());
            }
            this.cqAttributes.setCqListeners(new ArrayList<CqListener>(nl));
        }
    }

    public CqAttributes create() {
        return (CqAttributes)this.cqAttributes.clone();
    }
}

