/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;

public class RegisterInterestOp {
    public static List execute(ExecutablePool pool, String region, Object key, int interestType2, InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, byte regionDataPolicy) {
        RegisterInterestOpImpl op = new RegisterInterestOpImpl(region, key, interestType2, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
        return (List)pool.executeOnQueuesAndReturnPrimaryResult(op);
    }

    public static List executeOn(ServerLocation sl, ExecutablePool pool, String region, Object key, int interestType2, InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, byte regionDataPolicy) {
        RegisterInterestOpImpl op = new RegisterInterestOpImpl(region, key, interestType2, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
        return (List)pool.executeOn(sl, (Op)op);
    }

    public static List executeOn(Connection conn, ExecutablePool pool, String region, Object key, int interestType2, InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, byte regionDataPolicy) {
        RegisterInterestOpImpl op = new RegisterInterestOpImpl(region, key, interestType2, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
        return (List)pool.executeOn(conn, (Op)op);
    }

    private RegisterInterestOp() {
    }

    protected static class RegisterInterestOpImpl
    extends AbstractOp {
        protected String region;

        public RegisterInterestOpImpl(String region, Object key, int interestType2, InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, byte regionDataPolicy) {
            super(20, 7);
            this.region = region;
            this.getMessage().addStringPart(region);
            this.getMessage().addIntPart(interestType2);
            this.getMessage().addObjPart(policy);
            byte durableByte = (byte)(isDurable ? 1 : 0);
            this.getMessage().addBytesPart(new byte[]{durableByte});
            this.getMessage().addStringOrObjPart(key);
            byte notifyByte = (byte)(receiveUpdatesAsInvalidates ? 1 : 0);
            this.getMessage().addBytesPart(new byte[]{notifyByte});
            this.getMessage().addBytesPart(new byte[]{regionDataPolicy, 1});
        }

        protected RegisterInterestOpImpl(String region, int msgType, int numParts) {
            super(msgType, numParts);
            this.region = region;
        }

        @Override
        protected Message createResponseMessage() {
            return new ChunkedMessage(1, Version.CURRENT);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object processResponse(Message m, Connection con) throws Exception {
            ChunkedMessage msg = (ChunkedMessage)m;
            msg.readHeader();
            switch (msg.getMessageType()) {
                case 32: {
                    ArrayList<List> serverKeys = new ArrayList<List>();
                    VersionedObjectList serverEntries = null;
                    LocalRegion r = null;
                    try {
                        r = (LocalRegion)GemFireCacheImpl.getInstance().getRegion(this.region);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    ArrayList<ArrayList<Object>> listOfList = new ArrayList<ArrayList<Object>>();
                    listOfList.add(list);
                    do {
                        msg.receiveChunk();
                        Part part = msg.getPart(0);
                        Object partObj = part.getObject();
                        if (partObj instanceof Throwable) {
                            String s = "While performing a remote " + this.getOpName();
                            throw new ServerOperationException(s, (Throwable)partObj);
                        }
                        if (partObj instanceof VersionedObjectList) {
                            if (serverEntries == null) {
                                serverEntries = new VersionedObjectList(true);
                            }
                            ((VersionedObjectList)partObj).replaceNullIDs(con.getEndpoint().getMemberId());
                            list.clear();
                            list.add(partObj);
                            if (r == null) continue;
                            try {
                                r.refreshEntriesFromServerKeys(con, listOfList, InterestResultPolicy.KEYS_VALUES);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        serverKeys.add((List)partObj);
                    } while (!msg.isLastChunk());
                    if (serverEntries != null) {
                        list.clear();
                        list.add(serverEntries);
                        return listOfList;
                    }
                    return serverKeys;
                }
                case 33: {
                    msg.receiveChunk();
                    return null;
                }
                case 2: {
                    msg.receiveChunk();
                    Part part = msg.getPart(0);
                    Object obj = part.getObject();
                    String s = this + ": While performing a remote " + this.getOpName();
                    throw new ServerOperationException(s, (Throwable)obj);
                }
                case 21: {
                    msg.receiveChunk();
                    String errorMessage = msg.getPart(0).getString();
                    String s = this + ": While performing a remote " + this.getOpName() + ": ";
                    throw new ServerOperationException(s + errorMessage);
                }
            }
            throw new InternalGemFireError("Unknown message type " + msg.getMessageType());
        }

        protected String getOpName() {
            return "registerInterest";
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 21;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startRegisterInterest();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endRegisterInterestSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endRegisterInterest(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

