/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.internal.cache.tier.sockets.Message;

public class MakePrimaryOp {
    public static void execute(ExecutablePool pool, Connection conn, boolean sentClientReady) {
        MakePrimaryOpImpl op = new MakePrimaryOpImpl(sentClientReady);
        pool.executeOn(conn, (Op)op);
    }

    private MakePrimaryOp() {
    }

    private static class MakePrimaryOpImpl
    extends AbstractOp {
        public MakePrimaryOpImpl(boolean sentClientReady) {
            super(31, 1);
            this.getMessage().addBytesPart(new byte[]{(byte)(sentClientReady ? 1 : 0)});
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "makePrimary");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startMakePrimary();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endMakePrimarySend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endMakePrimary(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

