/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.cache.GatewayConfigurationException;
import org.apache.geode.cache.client.ServerRefusedConnectionException;
import org.apache.geode.cache.client.internal.AuthenticateUserOp;
import org.apache.geode.cache.client.internal.ClientUpdater;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionFactory;
import org.apache.geode.cache.client.internal.ConnectionImpl;
import org.apache.geode.cache.client.internal.ConnectionSource;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.QueueManager;
import org.apache.geode.cache.client.internal.ServerBlackList;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.tier.sockets.CacheClientUpdater;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.HandShake;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    private static final Logger logger = LogService.getLogger();
    private final HandShake handshake;
    private final int socketBufferSize;
    private final int handShakeTimeout;
    private final boolean usedByGateway;
    private final ServerBlackList blackList;
    private final CancelCriterion cancelCriterion;
    private final SocketCreator socketCreator;
    private ConnectionSource source;
    private int readTimeout;
    private InternalDistributedSystem ds;
    private EndpointManager endpointManager;
    private GatewaySender gatewaySender;
    private PoolImpl pool;
    public static boolean testFailedConnectionToServer = false;

    public ConnectionFactoryImpl(ConnectionSource source, EndpointManager endpointManager, InternalDistributedSystem sys, int socketBufferSize, int handShakeTimeout, int readTimeout, ClientProxyMembershipID proxyId, CancelCriterion cancelCriterion, boolean usedByGateway, GatewaySender sender, long pingInterval, boolean multiuserSecureMode, PoolImpl pool) {
        this.handshake = new HandShake(proxyId, sys);
        this.handshake.setClientReadTimeout(readTimeout);
        this.source = source;
        this.endpointManager = endpointManager;
        this.ds = sys;
        this.socketBufferSize = socketBufferSize;
        this.handShakeTimeout = handShakeTimeout;
        this.handshake.setMultiuserSecureMode(multiuserSecureMode);
        this.readTimeout = readTimeout;
        this.usedByGateway = usedByGateway;
        this.gatewaySender = sender;
        this.blackList = new ServerBlackList(pingInterval);
        this.cancelCriterion = cancelCriterion;
        this.pool = pool;
        if (this.usedByGateway || this.gatewaySender != null) {
            this.socketCreator = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.GATEWAY);
            if (sender != null && !sender.getGatewayTransportFilters().isEmpty()) {
                this.socketCreator.initializeTransportFilterClientSocketFactory(sender);
            }
        } else {
            this.socketCreator = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.SERVER);
        }
    }

    public void start(ScheduledExecutorService background) {
        this.blackList.start(background);
    }

    private byte getCommMode(boolean forQueue) {
        if (this.usedByGateway || this.gatewaySender != null) {
            return 103;
        }
        if (forQueue) {
            return 107;
        }
        return 100;
    }

    @Override
    public ServerBlackList getBlackList() {
        return this.blackList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection createClientToServerConnection(ServerLocation location, boolean forQueue) throws GemFireSecurityException {
        ConnectionImpl connection = new ConnectionImpl(this.ds, this.cancelCriterion);
        ServerBlackList.FailureTracker failureTracker = this.blackList.getFailureTracker(location);
        boolean initialized = false;
        try {
            HandShake connHandShake = new HandShake(this.handshake);
            connection.connect(this.endpointManager, location, connHandShake, this.socketBufferSize, this.handShakeTimeout, this.readTimeout, this.getCommMode(forQueue), this.gatewaySender, this.socketCreator);
            failureTracker.reset();
            connection.setHandShake(connHandShake);
            this.authenticateIfRequired(connection);
            initialized = true;
        }
        catch (GemFireConfigException e) {
            throw e;
        }
        catch (CancelException e) {
            throw e;
        }
        catch (GemFireSecurityException e) {
            throw e;
        }
        catch (GatewayConfigurationException e) {
            throw e;
        }
        catch (ServerRefusedConnectionException src) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_COULD_NOT_CREATE_A_NEW_CONNECTION_TO_SERVER_0, src.getMessage()));
            testFailedConnectionToServer = true;
            throw src;
        }
        catch (Exception e) {
            if (e.getMessage() != null && (e.getMessage().equals("Connection refused") || e.getMessage().equals("Connection reset"))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unable to connect to {}: connection refused", (Object)location);
                }
            } else {
                logger.warn(LocalizedMessage.create(LocalizedStrings.ConnectException_COULD_NOT_CONNECT_TO_0, location), (Throwable)e);
            }
            testFailedConnectionToServer = true;
        }
        finally {
            if (!initialized) {
                connection.destroy();
                failureTracker.addFailure();
                connection = null;
            }
        }
        return connection;
    }

    private void authenticateIfRequired(Connection conn) {
        ServerLocation server;
        this.cancelCriterion.checkCancelInProgress(null);
        if (!this.pool.isUsedByGateway() && !this.pool.getMultiuserAuthentication() && (server = conn.getServer()).getRequiresCredentials() && server.getUserId() == -1L) {
            Long uniqueID = (Long)AuthenticateUserOp.executeOn(conn, this.pool);
            server.setUserId(uniqueID);
            if (logger.isDebugEnabled()) {
                logger.debug("CFI.authenticateIfRequired() Completed authentication on {}", (Object)conn);
            }
        }
    }

    @Override
    public ServerLocation findBestServer(ServerLocation currentServer, Set excludedServers) {
        if (currentServer != null && this.source.isBalanced()) {
            return currentServer;
        }
        HashSet origExcludedServers = excludedServers;
        excludedServers = new HashSet(excludedServers);
        Set blackListedServers = this.blackList.getBadServers();
        excludedServers.addAll(blackListedServers);
        ServerLocation server = this.source.findReplacementServer(currentServer, excludedServers);
        if (server == null && excludedServers.size() > origExcludedServers.size()) {
            server = this.source.findReplacementServer(currentServer, origExcludedServers);
        }
        if (server == null && logger.isDebugEnabled()) {
            logger.debug("Source was unable to findForReplacement any servers");
        }
        return server;
    }

    @Override
    public Connection createClientToServerConnection(Set excludedServers) throws GemFireSecurityException {
        HashSet origExcludedServers = excludedServers;
        excludedServers = new HashSet(excludedServers);
        Set blackListedServers = this.blackList.getBadServers();
        excludedServers.addAll(blackListedServers);
        Connection conn = null;
        ServerRefusedConnectionException fatalException = null;
        boolean tryBlackList = true;
        do {
            ServerLocation server;
            if ((server = this.source.findServer(excludedServers)) == null) {
                if (tryBlackList) {
                    tryBlackList = false;
                    int size = excludedServers.size();
                    excludedServers.removeAll(blackListedServers);
                    excludedServers.addAll(origExcludedServers);
                    if (excludedServers.size() < size) continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Source was unable to locate any servers");
                }
                if (fatalException != null) {
                    throw fatalException;
                }
                return null;
            }
            try {
                conn = this.createClientToServerConnection(server, false);
            }
            catch (CancelException e) {
                throw e;
            }
            catch (GemFireSecurityException e) {
                throw e;
            }
            catch (GatewayConfigurationException e) {
                throw e;
            }
            catch (ServerRefusedConnectionException srce) {
                fatalException = srce;
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerRefusedConnectionException attempting to connect to {}", (Object)server, (Object)srce);
                }
            }
            catch (Exception e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.ConnectException_COULD_NOT_CONNECT_TO_0, server), (Throwable)e);
            }
            excludedServers.add(server);
        } while (conn == null);
        return conn;
    }

    @Override
    public ClientUpdater createServerToClientConnection(Endpoint endpoint, QueueManager qManager, boolean isPrimary, ClientUpdater failedUpdater) {
        CacheClientUpdater updater;
        String clientUpdateName = "Cache Client Updater Thread  on " + endpoint.getMemberId() + " port " + endpoint.getLocation().getPort();
        if (logger.isDebugEnabled()) {
            logger.debug("Establishing: {}", (Object)clientUpdateName);
        }
        if (!(updater = new CacheClientUpdater(clientUpdateName, endpoint.getLocation(), isPrimary, this.ds, new HandShake(this.handshake), qManager, this.endpointManager, endpoint, this.handShakeTimeout, this.socketCreator)).isConnected()) {
            return null;
        }
        updater.setFailedUpdater(failedUpdater);
        updater.start();
        return updater;
    }
}

