/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.geode.admin.AdminDistributedSystem;
import org.apache.geode.admin.DistributedSystemConfig;
import org.apache.geode.admin.ManagedEntityConfig;
import org.apache.geode.admin.internal.DistributionLocatorImpl;
import org.apache.geode.admin.internal.InetAddressUtil;
import org.apache.geode.admin.internal.InternalManagedEntity;
import org.apache.geode.admin.internal.ManagedEntityController;
import org.apache.geode.internal.ProcessOutputReader;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

class EnabledManagedEntityController
implements ManagedEntityController {
    private static final Logger logger = LogService.getLogger();
    private static final String[] ERROR_OUTPUTS = new String[]{"No such file or directory", "The system cannot find the file specified.", "Access is denied.", "cannot open", "ERROR"};
    private static final String HOST = "{HOST}";
    private static final String CMD = "{CMD}";
    private final ThreadGroup threadGroup;
    private final AdminDistributedSystem system;

    EnabledManagedEntityController(AdminDistributedSystem system) {
        this.system = system;
        this.threadGroup = LoggingThreadGroup.createThreadGroup("ManagedEntityController threads", logger);
    }

    private boolean outputIsError(String output) {
        if (output == null) {
            return false;
        }
        boolean error = false;
        for (int i = 0; i < ERROR_OUTPUTS.length; ++i) {
            boolean bl = error = output.indexOf(ERROR_OUTPUTS[i]) > -1;
            if (!error) continue;
            return error;
        }
        return error;
    }

    protected String execute(String command, InternalManagedEntity entity) {
        if (command == null || command.length() == 0) {
            throw new IllegalArgumentException(LocalizedStrings.ManagedEntityController_EXECUTION_COMMAND_IS_EMPTY.toLocalizedString());
        }
        File workingDir = new File(entity.getEntityConfig().getWorkingDirectory());
        logger.info(LocalizedMessage.create(LocalizedStrings.ManagedEntityController_EXECUTING_REMOTE_COMMAND_0_IN_DIRECTORY_1, new Object[]{command, workingDir}));
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(command, null, workingDir);
        }
        catch (IOException e) {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.ManagedEntityController_WHILE_EXECUTING_0, command), (Throwable)e);
            return null;
        }
        ProcessOutputReader pos = new ProcessOutputReader(p);
        int retCode = pos.getExitCode();
        String output = pos.getOutput();
        logger.info(LocalizedMessage.create(LocalizedStrings.ManagedEntityController_RESULT_OF_EXECUTING_0_IS_1, new Object[]{command, retCode}));
        logger.info(LocalizedMessage.create(LocalizedStrings.ManagedEntityController_OUTPUT_OF_0_IS_1, new Object[]{command, output}));
        if (retCode != 0 || this.outputIsError(output)) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ManagedEntityController_REMOTE_EXECUTION_OF_0_FAILED, command));
            return null;
        }
        return output;
    }

    private boolean endsWithSeparator(String path) {
        return path.endsWith("/") || path.endsWith("\\");
    }

    private String getOSPath(String path) {
        if (this.pathIsWindows(path)) {
            return path.replace('/', '\\');
        }
        return path.replace('\\', '/');
    }

    private boolean pathIsWindows(String path) {
        if (path != null && path.length() > 1) {
            return Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' || path.startsWith("//") || path.startsWith("\\\\");
        }
        return false;
    }

    private String arrangeRemoteCommand(InternalManagedEntity entity, String cmd) {
        String end;
        String start;
        String host = entity.getEntityConfig().getHost();
        if (InetAddressUtil.isLocalHost(host)) {
            return cmd;
        }
        String prefix = entity.getEntityConfig().getRemoteCommand();
        if (prefix == null || prefix.length() <= 0) {
            prefix = entity.getDistributedSystem().getRemoteCommand();
        }
        if (prefix == null || prefix.length() <= 0) {
            throw new IllegalStateException(LocalizedStrings.ManagedEntityController_A_REMOTE_COMMAND_MUST_BE_SPECIFIED_TO_OPERATE_ON_A_MANAGED_ENTITY_ON_HOST_0.toLocalizedString(host));
        }
        int hostIdx = prefix.indexOf(HOST);
        int cmdIdx = prefix.indexOf(CMD);
        if (hostIdx == -1 && cmdIdx == -1) {
            return prefix + " " + host + " " + cmd;
        }
        if (hostIdx >= 0) {
            start = prefix.substring(0, hostIdx);
            end = null;
            end = hostIdx + HOST.length() >= prefix.length() ? "" : prefix.substring(hostIdx + HOST.length());
            prefix = start + host + end;
            cmdIdx = prefix.indexOf(CMD);
        }
        if (cmdIdx >= 0) {
            start = prefix.substring(0, cmdIdx);
            end = null;
            end = cmdIdx + CMD.length() >= prefix.length() ? "" : prefix.substring(cmdIdx + CMD.length());
            prefix = start + cmd + end;
        }
        return prefix;
    }

    @Override
    public String getProductExecutable(InternalManagedEntity entity, String executable) {
        String productDirectory = entity.getEntityConfig().getProductDirectory();
        String path = null;
        File productDir = new File(productDirectory);
        path = productDir.getPath();
        if (!this.endsWithSeparator(path)) {
            path = path + File.separator;
        }
        path = path + "bin" + File.separator;
        String bat = "";
        if (this.pathIsWindows(path)) {
            bat = ".bat";
        }
        return this.getOSPath(path) + executable + bat;
    }

    @Override
    public String buildSSLArguments(DistributedSystemConfig config) {
        Properties sslProps = this.buildSSLProperties(config, true);
        if (sslProps == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String string : sslProps.keySet()) {
            String value = sslProps.getProperty(string);
            sb.append(" -J-D" + string + "=" + value);
        }
        return sb.toString();
    }

    private Properties buildSSLProperties(DistributedSystemConfig config, boolean forCommandLine) {
        if (!config.isSSLEnabled()) {
            return null;
        }
        String prefix = "";
        if (forCommandLine) {
            prefix = "gemfire.";
        }
        Properties sslProps = (Properties)config.getSSLProperties().clone();
        sslProps.setProperty(prefix + "mcast-port", "0");
        sslProps.setProperty(prefix + "cluster-ssl-enabled", String.valueOf(config.isSSLEnabled()));
        sslProps.setProperty(prefix + "cluster-ssl-ciphers", config.getSSLCiphers());
        sslProps.setProperty(prefix + "cluster-ssl-protocols", config.getSSLProtocols());
        sslProps.setProperty(prefix + "cluster-ssl-require-authentication", String.valueOf(config.isSSLAuthenticationRequired()));
        return sslProps;
    }

    @Override
    public void start(final InternalManagedEntity entity) {
        final String command = this.arrangeRemoteCommand(entity, entity.getStartCommand());
        Thread start = new Thread(this.threadGroup, new Runnable(){

            @Override
            public void run() {
                EnabledManagedEntityController.this.execute(command, entity);
            }
        }, "Start " + entity.getEntityType());
        start.start();
    }

    @Override
    public void stop(final InternalManagedEntity entity) {
        final String command = this.arrangeRemoteCommand(entity, entity.getStopCommand());
        Thread stop = new Thread(this.threadGroup, new Runnable(){

            @Override
            public void run() {
                EnabledManagedEntityController.this.execute(command, entity);
            }
        }, "Stop " + entity.getEntityType());
        stop.start();
    }

    @Override
    public boolean isRunning(InternalManagedEntity entity) {
        String command = this.arrangeRemoteCommand(entity, entity.getIsRunningCommand());
        String output = this.execute(command, entity);
        if (output == null || output.indexOf("stop") != -1 || output.indexOf("killed") != -1 || output.indexOf("starting") != -1) {
            return false;
        }
        if (output.indexOf("running") != -1) {
            return true;
        }
        throw new IllegalStateException(LocalizedStrings.ManagedEntityController_COULD_NOT_DETERMINE_IF_MANAGED_ENTITY_WAS_RUNNING_0.toLocalizedString(output));
    }

    @Override
    public String getLog(DistributionLocatorImpl locator) {
        String command = this.arrangeRemoteCommand(locator, locator.getLogCommand());
        return this.execute(command, locator);
    }

    private String listDirectory(InternalManagedEntity entity, String dir) {
        ManagedEntityConfig config = entity.getEntityConfig();
        String listFile = this.pathIsWindows(config.getProductDirectory()) ? "dir " : "ls ";
        String command = this.arrangeRemoteCommand(entity, listFile + dir);
        return this.execute(command, entity);
    }
}

