/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.geode.admin.internal.BackupDataStoreResult;
import org.apache.geode.admin.internal.FinishBackupRequest;
import org.apache.geode.admin.internal.FlushToDiskRequest;
import org.apache.geode.admin.internal.PrepareBackupRequest;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.Assert;

public class BackupDataStoreHelper {
    public static String LOCK_SERVICE_NAME = BackupDataStoreHelper.class.getSimpleName();
    private static String LOCK_NAME = LOCK_SERVICE_NAME + "_token";
    private static Object LOCK_SYNC = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupDataStoreResult backupAllMembers(DM dm, Set recipients, File targetDir, File baselineDir) {
        Map<DistributedMember, Set<PersistentID>> successfulMembers;
        Map<DistributedMember, Set<PersistentID>> existingDataStores;
        FlushToDiskRequest.send(dm, recipients);
        boolean abort = true;
        try {
            existingDataStores = PrepareBackupRequest.send(dm, recipients);
            abort = false;
        }
        finally {
            successfulMembers = FinishBackupRequest.send(dm, recipients, targetDir, baselineDir, abort);
        }
        return new BackupDataStoreResult(existingDataStores, successfulMembers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DistributedLockService getLockService(DM dm) {
        DistributedLockService dls = DistributedLockService.getServiceNamed(LOCK_SERVICE_NAME);
        if (dls == null) {
            Object object = LOCK_SYNC;
            synchronized (object) {
                dls = DistributedLockService.getServiceNamed(LOCK_SERVICE_NAME);
                if (dls == null) {
                    dls = DistributedLockService.create(LOCK_SERVICE_NAME, dm.getSystem());
                }
            }
        }
        Assert.assertTrue(dls != null);
        return dls;
    }

    public static boolean obtainLock(DM dm) {
        return BackupDataStoreHelper.getLockService(dm).lock(LOCK_NAME, 0L, -1L);
    }

    public static void releaseLock(DM dm) {
        BackupDataStoreHelper.getLockService(dm).unlock(LOCK_NAME);
    }
}

