<!--
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Apache YuniKorn
Apache YuniKorn is a light-weight, universal resource scheduler for container orchestrator systems.
It was created to achieve fine-grained resource sharing for various workloads efficiently on a large scale, multi-tenant,
and cloud-native environment. YuniKorn brings a unified, cross-platform scheduling experience for mixed workloads consists
of stateless batch workloads and stateful services.

## Build pre-requisites
These instructions provided are tailored to the source release.
Details on how to set up a full development environment can be found in [Building YuniKorn](https://yunikorn.apache.org/docs/next/developer_guide/build).

General requirement for building YuniKorn images from this release:
* Make
* Docker

### Yunikorn Scheduler
The scheduler and shim are build as one set of artifacts and have one requirement:
* Go 1.23 or later

### Yunikorn web UI
The YuniKorn web UI uses a two stage docker build with predefined images.
All dependencies are included in the image.

NOTE: the scheduler can be used without a web UI build or deployed.

## Building
Run the `make` command to build docker images. To generate verifiable, reproducible binaries,
run `make REPRODUCIBLE_BUILDS=1`

```shell script
make
```
The local build only generates an image for one processor architecture.
The default for the architecture is the local processor type that is retrieved via the `uname -m` command.
The architecture can be overridden by setting the shell variable `HOST_ARCH`.
For details on how to change the architectures see the processing of `HOST_ARCH` in the `Makefile` included in the `k8shim` directory.

The command will generate the following four docker images in the local docker repository:
* apache/yunikorn:scheduler-_amd64_-1.6.2
* apache/yunikorn:scheduler-plugin-_amd64_-1.6.2
* apache/yunikorn:admission-_amd64_-1.6.2
* apache/yunikorn:web-_amd64_-1.6.2

Note: the naming of the images assumes a processor architecture that maps to the docker architecture _amd64_.

## Verifying the release
A script and configuration to create a simple cluster using the locally built images is provided in this release archive.
Follow the instructions in [Building](#building) to create the local docker images.
The script for validating the release and the build use the same defaults.

After the images have been created run the script for more instructions and to list the tools required for validating
the release:
```shell
./validate_cluster.sh
```
The `kind` cluster created using the included config is a small, but fully functional Kubernetes cluster, with
Apache YuniKorn deployed.

## Deploying YuniKorn
The simplest way to run Apache YuniKorn is to use the provided helm charts, you can find the templates in the release
package `helm-charts`.
There are a few prerequisites:
1. An existing K8s cluster is up and running.
2. Helm chart client is installed.

If you have a cluster, and the helm client you can simply run helm from the root directory:
```shell script
helm install yunikorn ./helm-charts/yunikorn
```

## Customising the build
The `make` command will pass on the following variables:
* VERSION
* REGISTRY
* HOST_ARCH
These variables can be used to generate customised build:
```shell script
HOST_ARCH="arm64" VERSION="1.1.0" REGISTRY="internal" make
```

These same variables can be set and will be picked up by the validate_cluster script.

The values defined in the helm charts assume a default build without changes to the variables.
Once you have built your own docker images, you will need to replace the docker image name in the helm chart templates.
Open `helm-charts/yunikorn/values.yaml` and replace the docker image information with ones you built.

For more instructions, please refer to [User Guide](https://yunikorn.apache.org/docs/).

## Deploying a convenience build
Apache YuniKorn provides a convenience release with pre-built Docker images and Helm charts.
These can be accessed via the [downloads page](https://yunikorn.apache.org/community/download) and instructions are
located in the [User Guide](https://yunikorn.apache.org/docs/).

The convenience build images are multi-architecture images. Supported architectures are `amd64` and `arm64`.

## Reproducible builds
Building YuniKorn from source generates reproducible build artifacts which
depend only on the version of YuniKorn built and the go compiler version used.

This release was compiled by the official release manager using Go version `1.23.7`
and generated binary artifacts with the following SHA-512 checksums:

### linux/amd64
```
310234e001a2c351760222ffe483fa87c2ff7e1b7f3ddc26be9ee329f07c2223f0e6442bc228a399a5352732f8987a37d37904c9d59706a736633c5652b85992  yunikorn-admission-controller
a396b4d8a82d99f0266053627cc48eaa2675ce8791c04b874ef3dad8aa21bd3be257c8d9719ae59e8fddd5239774ebd73c6596ebd88a8aa385d720e6f72a84f8  yunikorn-scheduler
749d64f1001660fc5aeeb33fcb6efc039dd0dd45653678067322f6babbda79f0b1b51e0b3b72b5f063b4a5d8c124ec81093c6ed695bb896bd6f022c9c43702da  yunikorn-scheduler-plugin
2922c4d6a6104f8aad22ebb3702cb154e0ce8a822f22388956884bd796ce0b0211607e0ff9dc1d2252fa55ed6284eb2d71f21b89067666315c853764cfad679c  yunikorn-web
```

### linux/arm64
```
a3aa8dd6bc29bc8c8e62b71bea691a4933df7ecb7fd35e3f0b40be0a52d739575ed0b6e6e388728a5531278941484699a1d2093273f668edf491645d63f3c131  yunikorn-admission-controller
b7187c6ce14658f150a1addd7039b4b0d7363ab85a170245b25c22183d7c742c02b15bbb86db7b0fa6167d9d75e14714ba1f468bfe9a92949d48d4fa0f1d82c6  yunikorn-scheduler
f9733dcf852a674108192c27c9dd8812408995a21d72a0e3b4eeef9c19bba79f8c5d9a718e6a09940aa0aad539b72448a4e0df381b804d62d3c4008f0236d009  yunikorn-scheduler-plugin
7a8d97ddd1a40963eccf7b2c8095426f8fe6577dc30c22a198b41c090fe17ebaf1f74fe3e07251c3849b8592601be521177dac76ebe7f78a89cb8760296baa9f  yunikorn-web
```

To verify your own binaries, be sure to execute your build in reproducible mode:
```shell script
make REPRODUCIBLE_BUILDS=1
```

## Testing the build
Running the unit tests is supported via the make command.
It will run the tests for all parts of YuniKorn in order:
```shell script
make test
```

### Yunikorn Scheduler
The scheduler tests runs in two parts: the core, and the k8shim.
There are no tests for the scheduler-interface.

Unit testing for the scheduler has no additional pre-requisites.

### Yunikorn web UI
The project requires a number of external tools to be installed for test and development.
A non image build requires the following tools to be installed:
* Node 18.20
* Angular CLI 16.2.10
* yarn 1.22

Running unit tests adds the following requirements:
* Karma
* json-server

Please check the [documentation](https://yunikorn.apache.org/docs/) for further details.

