<!--
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Apache YuniKorn
Apache YuniKorn is a light-weight, universal resource scheduler for container orchestrator systems.
It was created to achieve fine-grained resource sharing for various workloads efficiently on a large scale, multi-tenant,
and cloud-native environment. YuniKorn brings a unified, cross-platform scheduling experience for mixed workloads consists
of stateless batch workloads and stateful services.

## Build pre-requisites
These instructions provided are tailored to the source release.
Details on how to set up a full development environment can be found in [Building YuniKorn](https://yunikorn.apache.org/docs/next/developer_guide/build).

General requirement for building YuniKorn images from this release:
* Make
* Docker

### Yunikorn Scheduler
The scheduler and shim are build as one set of artifacts and have one requirement:
* Go 1.22 or later

### Yunikorn web UI
The YuniKorn web UI uses a two stage docker build with predefined images.
All dependencies are included in the image.

NOTE: the scheduler can be used without a web UI build or deployed.

## Building
Run the `make` command to build docker images. To generate verifiable, reproducible binaries,
run `make REPRODUCIBLE_BUILDS=1`

```shell script
make
```
The local build only generates an image for one processor architecture.
The default for the architecture is the local processor type that is retrieved via the `uname -m` command.
The architecture can be overridden by setting the shell variable `HOST_ARCH`.
For details on how to change the architectures see the processing of `HOST_ARCH` in the `Makefile` included in the `k8shim` directory.

The command will generate the following four docker images in the local docker repository:
* apache/yunikorn:scheduler-_amd64_-1.6.1
* apache/yunikorn:scheduler-plugin-_amd64_-1.6.1
* apache/yunikorn:admission-_amd64_-1.6.1
* apache/yunikorn:web-_amd64_-1.6.1

Note: the naming of the images assumes a processor architecture that maps to the docker architecture _amd64_.

## Verifying the release
A script and configuration to create a simple cluster using the locally built images is provided in this release archive.
Follow the instructions in [Building](#building) to create the local docker images.
The script for validating the release and the build use the same defaults.

After the images have been created run the script for more instructions and to list the tools required for validating
the release:
```shell
./validate_cluster.sh
```
The `kind` cluster created using the included config is a small, but fully functional Kubernetes cluster, with
Apache YuniKorn deployed.

## Deploying YuniKorn
The simplest way to run Apache YuniKorn is to use the provided helm charts, you can find the templates in the release
package `helm-charts`.
There are a few prerequisites:
1. An existing K8s cluster is up and running.
2. Helm chart client is installed.

If you have a cluster, and the helm client you can simply run helm from the root directory:
```shell script
helm install yunikorn ./helm-charts/yunikorn
```

## Customising the build
The `make` command will pass on the following variables:
* VERSION
* REGISTRY
* HOST_ARCH
These variables can be used to generate customised build:
```shell script
HOST_ARCH="arm64" VERSION="1.1.0" REGISTRY="internal" make
```

These same variables can be set and will be picked up by the validate_cluster script.

The values defined in the helm charts assume a default build without changes to the variables.
Once you have built your own docker images, you will need to replace the docker image name in the helm chart templates.
Open `helm-charts/yunikorn/values.yaml` and replace the docker image information with ones you built.

For more instructions, please refer to [User Guide](https://yunikorn.apache.org/docs/).

## Deploying a convenience build
Apache YuniKorn provides a convenience release with pre-built Docker images and Helm charts.
These can be accessed via the [downloads page](https://yunikorn.apache.org/community/download) and instructions are
located in the [User Guide](https://yunikorn.apache.org/docs/).

The convenience build images are multi-architecture images. Supported architectures are `amd64` and `arm64`.

## Reproducible builds
Building YuniKorn from source generates reproducible build artifacts which
depend only on the version of YuniKorn built and the go compiler version used.

This release was compiled by the official release manager using Go version `1.22.10`
and generated binary artifacts with the following SHA-512 checksums:

### linux/amd64
```
8cf7bbd40200e6e8894b872f7525c82a380f570ef34003b5628c20c2f148b588fa3e4ed086a0ecff349bacf4780ced73e80b78c762388783673afb64caf8d1de  yunikorn-admission-controller
23774b41cf3c303055db8c15940fcf4e25ea834e10cf589eeb16ed6a5ac08db893f793b2f330ca84f71419db82fb07705c207fb98fc73d33edaca79265978d9e  yunikorn-scheduler
1b9f6b969b25b4faa588ce80f95b1e30f420d0f92a3b716a06c4a5962e83fa6e1bec2b69244e5ad4de2c0d12946fe5bf5abfac22b8b5fbaf36fd1f4754e41a9d  yunikorn-scheduler-plugin
6f59430845cedbdd4198b088e792f79bfdc31b293581c154e92dd809278a4cb0002900539dcb8001cbac1ba55c7b554e97ecf2144e258dbcf66db8572919bbc2  yunikorn-web
```

### linux/arm64
```
224570e763fddf526a58968de64252df41e7cc5b25a25e22cd910cdec423db12e56fee7bed49944d9448eb3666c13d32a21e749afcabcde2eec99db76fd5b22c  yunikorn-admission-controller
a5139f0ba568491343940aabdf10988119a7566c308edfd5f227c7142525aaacbe9c3f5966be8a36d7ea01f60c56eace1386d8781356e64ff0128a21591ddd34  yunikorn-scheduler
35038ca43e0a59bb4b4a3fe6a4820d3ddf483445568affd1d2867071bb566d2fd7a13ba6b55884099e91cd0c15b2152734fc0624c2d3bb3fe55ce56fad5b1c84  yunikorn-scheduler-plugin
fb66955b114f13c8d0b446fc00d4d359ca1c553e6841b7feb40b549cb22b2d9c13504dbe63e46bab5818aee7b265626498f85f28ffd606640e295fb2c2b93a38  yunikorn-web
```

To verify your own binaries, be sure to execute your build in reproducible mode:
```shell script
make REPRODUCIBLE_BUILDS=1
```

## Testing the build
Running the unit tests is supported via the make command.
It will run the tests for all parts of YuniKorn in order:
```shell script
make test
```

### Yunikorn Scheduler
The scheduler tests runs in two parts: the core, and the k8shim.
There are no tests for the scheduler-interface.

Unit testing for the scheduler has no additional pre-requisites.

### Yunikorn web UI
The project requires a number of external tools to be installed for test and development.
A non image build requires the following tools to be installed:
* Node 18.20
* Angular CLI 16.2.10
* yarn 1.22

Running unit tests adds the following requirements:
* Karma
* json-server

Please check the [documentation](https://yunikorn.apache.org/docs/) for further details.

