<!--
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Apache YuniKorn
Apache YuniKorn is a light-weight, universal resource scheduler for container orchestrator systems.
It was created to achieve fine-grained resource sharing for various workloads efficiently on a large scale, multi-tenant,
and cloud-native environment. YuniKorn brings a unified, cross-platform scheduling experience for mixed workloads consists
of stateless batch workloads and stateful services.

## Build pre-requisites
These instructions provided are tailored to the source release.
Details on how to set up a full development environment can be found in [Building YuniKorn](https://yunikorn.apache.org/docs/next/developer_guide/build).

General requirement for building YuniKorn images from this release:
* Make
* Docker

### Yunikorn Scheduler
The scheduler and shim are build as one set of artifacts and have one requirement:
* Go 1.22 or later

### Yunikorn web UI
The YuniKorn web UI uses a two stage docker build with predefined images.
All dependencies are included in the image.

NOTE: the scheduler can be used without a web UI build or deployed.

## Building
Run the `make` command to build docker images. To generate verifiable, reproducible binaries,
run `make REPRODUCIBLE_BUILDS=1`

```shell script
make
```
The local build only generates an image for one processor architecture.
The default for the architecture is the local processor type that is retrieved via the `uname -m` command.
The architecture can be overridden by setting the shell variable `HOST_ARCH`.
For details on how to change the architectures see the processing of `HOST_ARCH` in the `Makefile` included in the `k8shim` directory.

The command will generate the following four docker images in the local docker repository:
* apache/yunikorn:scheduler-_amd64_-1.6.0
* apache/yunikorn:scheduler-plugin-_amd64_-1.6.0
* apache/yunikorn:admission-_amd64_-1.6.0
* apache/yunikorn:web-_amd64_-1.6.0

Note: the naming of the images assumes a processor architecture that maps to the docker architecture _amd64_.

## Verifying the release
A script and configuration to create a simple cluster using the locally built images is provided in this release archive.
Follow the instructions in [Building](#building) to create the local docker images.
The script for validating the release and the build use the same defaults.

After the images have been created run the script for more instructions and to list the tools required for validating
the release:
```shell
./validate_cluster.sh
```
The `kind` cluster created using the included config is a small, but fully functional Kubernetes cluster, with
Apache YuniKorn deployed.

## Deploying YuniKorn
The simplest way to run Apache YuniKorn is to use the provided helm charts, you can find the templates in the release
package `helm-charts`.
There are a few prerequisites:
1. An existing K8s cluster is up and running.
2. Helm chart client is installed.

If you have a cluster, and the helm client you can simply run helm from the root directory:
```shell script
helm install yunikorn ./helm-charts/yunikorn
```

## Customising the build
The `make` command will pass on the following variables:
* VERSION
* REGISTRY
* HOST_ARCH
These variables can be used to generate customised build:
```shell script
HOST_ARCH="arm64" VERSION="1.1.0" REGISTRY="internal" make
```

These same variables can be set and will be picked up by the validate_cluster script.

The values defined in the helm charts assume a default build without changes to the variables.
Once you have built your own docker images, you will need to replace the docker image name in the helm chart templates.
Open `helm-charts/yunikorn/values.yaml` and replace the docker image information with ones you built.

For more instructions, please refer to [User Guide](https://yunikorn.apache.org/docs/).

## Deploying a convenience build
Apache YuniKorn provides a convenience release with pre-built Docker images and Helm charts.
These can be accessed via the [downloads page](https://yunikorn.apache.org/community/download) and instructions are
located in the [User Guide](https://yunikorn.apache.org/docs/).

The convenience build images are multi-architecture images. Supported architectures are `amd64` and `arm64`.

## Reproducible builds
Building YuniKorn from source generates reproducible build artifacts which
depend only on the version of YuniKorn built and the go compiler version used.

This release was compiled by the official release manager using Go version `1.22.7`
and generated binary artifacts with the following SHA-512 checksums:

### linux/amd64
```
8864d9b11646f026fd25aa8c7df035b7fca0feb3136b82fc7513e74324b88493b2d60b661ad6a9e4c69c5cc459159efdf89e848dda79c8e7201d3ff01e624c38  yunikorn-admission-controller
f75650f75f778bb8ebfac5e91132b5416c46128a789cbd490dc92e545483001f094d62a22ed87fd1e4ed9232ade0c6659f24f163b5b12ec1e868a36ac96777b7  yunikorn-scheduler
db8040561276d3d76db7dbc9f2085a396c3215ef4e18fb0fa51da368891cba9b4a7b31cab613cfa8b610c8176c07d06d58c10d20ef4608ae0d68b57bd501f496  yunikorn-scheduler-plugin
5b743af185abc0ff8e8ccdb7584cce1d946f18ab9639e90887b1c888ab47d117e5a8a009516f0c71c9d8d73bacade0e9539fe6c5403b36472bc1eda249755def  yunikorn-web
```

### linux/arm64
```
a2428f13255934c56725a741afbdb2eec7e339365c0a98c084748a3baedb240359fceda493e6cf4ab098221495601b76593319e3cf10a887270081cbaba59b53  yunikorn-admission-controller
88fa0030f022103d413ad3a5081f753317518d22ae60a3d7196a9f002e890c0237c83cb832b7c0bac5017bb60d4fc1dcd8c9b54c105e859e4ad323e9793887e6  yunikorn-scheduler
d7d294961a0d4d9c7943d800983779734fb55e5338e6a08f945be8b116ca18a8a2bfa35fba6e9f861e22a60dbbb50d3482a9ba99b9657ddd75e84414cd86c9a9  yunikorn-scheduler-plugin
d3f9dd37518aa68732dcc1eb0e07e8b2cb55bd53999b66200b9e7039463844b7f5b458c8a85060b02436712de293fa5f0ce999f8089a8de14551dc7df605a2ee  yunikorn-web
```

To verify your own binaries, be sure to execute your build in reproducible mode:
```shell script
make REPRODUCIBLE_BUILDS=1
```

## Testing the build
Running the unit tests is supported via the make command.
It will run the tests for all parts of YuniKorn in order:
```shell script
make test
```

### Yunikorn Scheduler
The scheduler tests runs in two parts: the core, and the k8shim.
There are no tests for the scheduler-interface.

Unit testing for the scheduler has no additional pre-requisites.

### Yunikorn web UI
The project requires a number of external tools to be installed for test and development.
A non image build requires the following tools to be installed:
* Node 18.20
* Angular CLI 16.2.10
* yarn 1.22

Running unit tests adds the following requirements:
* Karma
* json-server

Please check the [documentation](https://yunikorn.apache.org/docs/) for further details.

