// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//     http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by make build. DO NOT EDIT

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: yunikorn-scheduler-interface/si.proto

package si

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	descriptorpb "google.golang.org/protobuf/types/descriptorpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type TerminationType int32

const (
	TerminationType_UNKNOWN_TERMINATION_TYPE TerminationType = 0 //TerminationType not set
	TerminationType_STOPPED_BY_RM            TerminationType = 1 // Stopped or killed by ResourceManager (created by RM)
	TerminationType_TIMEOUT                  TerminationType = 2 // Timed out based on the executionTimeoutMilliSeconds (created by core)
	TerminationType_PREEMPTED_BY_SCHEDULER   TerminationType = 3 // Preempted allocation by scheduler (created by core)
	TerminationType_PLACEHOLDER_REPLACED     TerminationType = 4 // Placeholder allocation replaced by real allocation (created by core)
)

// Enum value maps for TerminationType.
var (
	TerminationType_name = map[int32]string{
		0: "UNKNOWN_TERMINATION_TYPE",
		1: "STOPPED_BY_RM",
		2: "TIMEOUT",
		3: "PREEMPTED_BY_SCHEDULER",
		4: "PLACEHOLDER_REPLACED",
	}
	TerminationType_value = map[string]int32{
		"UNKNOWN_TERMINATION_TYPE": 0,
		"STOPPED_BY_RM":            1,
		"TIMEOUT":                  2,
		"PREEMPTED_BY_SCHEDULER":   3,
		"PLACEHOLDER_REPLACED":     4,
	}
)

func (x TerminationType) Enum() *TerminationType {
	p := new(TerminationType)
	*p = x
	return p
}

func (x TerminationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TerminationType) Descriptor() protoreflect.EnumDescriptor {
	return file_yunikorn_scheduler_interface_si_proto_enumTypes[0].Descriptor()
}

func (TerminationType) Type() protoreflect.EnumType {
	return &file_yunikorn_scheduler_interface_si_proto_enumTypes[0]
}

func (x TerminationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TerminationType.Descriptor instead.
func (TerminationType) EnumDescriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{0}
}

// Action from RM
type NodeInfo_ActionFromRM int32

const (
	// ActionFromRM not set
	NodeInfo_UNKNOWN_ACTION_FROM_RM NodeInfo_ActionFromRM = 0
	// Create Node as initially schedulable.
	NodeInfo_CREATE NodeInfo_ActionFromRM = 1
	// Update node resources, attributes.
	NodeInfo_UPDATE NodeInfo_ActionFromRM = 2
	// Do not allocate new allocations on the node.
	NodeInfo_DRAIN_NODE NodeInfo_ActionFromRM = 3
	// Decomission node, it will immediately stop allocations on the node and
	// remove the node from schedulable lists.
	NodeInfo_DECOMISSION NodeInfo_ActionFromRM = 4
	// From Draining state to SCHEDULABLE state.
	// If node is not in draining state, error will be thrown
	NodeInfo_DRAIN_TO_SCHEDULABLE NodeInfo_ActionFromRM = 5
	// Create Node as initially draining (i.e. unschedulable). Before scheduling can proceed,
	// DRAIN_TO_SCHEDULABLE must be called.
	NodeInfo_CREATE_DRAIN NodeInfo_ActionFromRM = 6
)

// Enum value maps for NodeInfo_ActionFromRM.
var (
	NodeInfo_ActionFromRM_name = map[int32]string{
		0: "UNKNOWN_ACTION_FROM_RM",
		1: "CREATE",
		2: "UPDATE",
		3: "DRAIN_NODE",
		4: "DECOMISSION",
		5: "DRAIN_TO_SCHEDULABLE",
		6: "CREATE_DRAIN",
	}
	NodeInfo_ActionFromRM_value = map[string]int32{
		"UNKNOWN_ACTION_FROM_RM": 0,
		"CREATE":                 1,
		"UPDATE":                 2,
		"DRAIN_NODE":             3,
		"DECOMISSION":            4,
		"DRAIN_TO_SCHEDULABLE":   5,
		"CREATE_DRAIN":           6,
	}
)

func (x NodeInfo_ActionFromRM) Enum() *NodeInfo_ActionFromRM {
	p := new(NodeInfo_ActionFromRM)
	*p = x
	return p
}

func (x NodeInfo_ActionFromRM) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeInfo_ActionFromRM) Descriptor() protoreflect.EnumDescriptor {
	return file_yunikorn_scheduler_interface_si_proto_enumTypes[1].Descriptor()
}

func (NodeInfo_ActionFromRM) Type() protoreflect.EnumType {
	return &file_yunikorn_scheduler_interface_si_proto_enumTypes[1]
}

func (x NodeInfo_ActionFromRM) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeInfo_ActionFromRM.Descriptor instead.
func (NodeInfo_ActionFromRM) EnumDescriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{24, 0}
}

// container scheduling states
type UpdateContainerSchedulingStateRequest_SchedulingState int32

const (
	// SchedulingState not set
	UpdateContainerSchedulingStateRequest_UNKNOWN_SCHEDULING_STATE UpdateContainerSchedulingStateRequest_SchedulingState = 0
	// the container is being skipped by the scheduler
	UpdateContainerSchedulingStateRequest_SKIPPED UpdateContainerSchedulingStateRequest_SchedulingState = 1
	// the container is scheduled and it has been assigned to a node
	UpdateContainerSchedulingStateRequest_SCHEDULED UpdateContainerSchedulingStateRequest_SchedulingState = 2
	// the container is reserved on some node, but not yet assigned
	UpdateContainerSchedulingStateRequest_RESERVED UpdateContainerSchedulingStateRequest_SchedulingState = 3
	// scheduler has visited all candidate nodes for this container
	// but non of them could satisfy this container's requirement
	UpdateContainerSchedulingStateRequest_FAILED UpdateContainerSchedulingStateRequest_SchedulingState = 4
)

// Enum value maps for UpdateContainerSchedulingStateRequest_SchedulingState.
var (
	UpdateContainerSchedulingStateRequest_SchedulingState_name = map[int32]string{
		0: "UNKNOWN_SCHEDULING_STATE",
		1: "SKIPPED",
		2: "SCHEDULED",
		3: "RESERVED",
		4: "FAILED",
	}
	UpdateContainerSchedulingStateRequest_SchedulingState_value = map[string]int32{
		"UNKNOWN_SCHEDULING_STATE": 0,
		"SKIPPED":                  1,
		"SCHEDULED":                2,
		"RESERVED":                 3,
		"FAILED":                   4,
	}
)

func (x UpdateContainerSchedulingStateRequest_SchedulingState) Enum() *UpdateContainerSchedulingStateRequest_SchedulingState {
	p := new(UpdateContainerSchedulingStateRequest_SchedulingState)
	*p = x
	return p
}

func (x UpdateContainerSchedulingStateRequest_SchedulingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpdateContainerSchedulingStateRequest_SchedulingState) Descriptor() protoreflect.EnumDescriptor {
	return file_yunikorn_scheduler_interface_si_proto_enumTypes[2].Descriptor()
}

func (UpdateContainerSchedulingStateRequest_SchedulingState) Type() protoreflect.EnumType {
	return &file_yunikorn_scheduler_interface_si_proto_enumTypes[2]
}

func (x UpdateContainerSchedulingStateRequest_SchedulingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpdateContainerSchedulingStateRequest_SchedulingState.Descriptor instead.
func (UpdateContainerSchedulingStateRequest_SchedulingState) EnumDescriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{30, 0}
}

type EventRecord_Type int32

const (
	// EventRecord Type not set
	EventRecord_UNKNOWN_EVENTRECORD_TYPE EventRecord_Type = 0
	EventRecord_REQUEST                  EventRecord_Type = 1
	EventRecord_APP                      EventRecord_Type = 2
	EventRecord_NODE                     EventRecord_Type = 3
	EventRecord_QUEUE                    EventRecord_Type = 4
)

// Enum value maps for EventRecord_Type.
var (
	EventRecord_Type_name = map[int32]string{
		0: "UNKNOWN_EVENTRECORD_TYPE",
		1: "REQUEST",
		2: "APP",
		3: "NODE",
		4: "QUEUE",
	}
	EventRecord_Type_value = map[string]int32{
		"UNKNOWN_EVENTRECORD_TYPE": 0,
		"REQUEST":                  1,
		"APP":                      2,
		"NODE":                     3,
		"QUEUE":                    4,
	}
)

func (x EventRecord_Type) Enum() *EventRecord_Type {
	p := new(EventRecord_Type)
	*p = x
	return p
}

func (x EventRecord_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventRecord_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yunikorn_scheduler_interface_si_proto_enumTypes[3].Descriptor()
}

func (EventRecord_Type) Type() protoreflect.EnumType {
	return &file_yunikorn_scheduler_interface_si_proto_enumTypes[3]
}

func (x EventRecord_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventRecord_Type.Descriptor instead.
func (EventRecord_Type) EnumDescriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{32, 0}
}

type EventRecord_ChangeType int32

const (
	EventRecord_NONE   EventRecord_ChangeType = 0
	EventRecord_SET    EventRecord_ChangeType = 1
	EventRecord_ADD    EventRecord_ChangeType = 2
	EventRecord_REMOVE EventRecord_ChangeType = 3
)

// Enum value maps for EventRecord_ChangeType.
var (
	EventRecord_ChangeType_name = map[int32]string{
		0: "NONE",
		1: "SET",
		2: "ADD",
		3: "REMOVE",
	}
	EventRecord_ChangeType_value = map[string]int32{
		"NONE":   0,
		"SET":    1,
		"ADD":    2,
		"REMOVE": 3,
	}
)

func (x EventRecord_ChangeType) Enum() *EventRecord_ChangeType {
	p := new(EventRecord_ChangeType)
	*p = x
	return p
}

func (x EventRecord_ChangeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventRecord_ChangeType) Descriptor() protoreflect.EnumDescriptor {
	return file_yunikorn_scheduler_interface_si_proto_enumTypes[4].Descriptor()
}

func (EventRecord_ChangeType) Type() protoreflect.EnumType {
	return &file_yunikorn_scheduler_interface_si_proto_enumTypes[4]
}

func (x EventRecord_ChangeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventRecord_ChangeType.Descriptor instead.
func (EventRecord_ChangeType) EnumDescriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{32, 1}
}

type EventRecord_ChangeDetail int32

const (
	EventRecord_DETAILS_NONE      EventRecord_ChangeDetail = 0
	EventRecord_REQUEST_CANCEL    EventRecord_ChangeDetail = 100 // Request cancelled by the RM
	EventRecord_REQUEST_ALLOC     EventRecord_ChangeDetail = 101 // Request allocated
	EventRecord_REQUEST_TIMEOUT   EventRecord_ChangeDetail = 102 // Request cancelled due to timeout
	EventRecord_APP_ALLOC         EventRecord_ChangeDetail = 200 // Allocation changed
	EventRecord_APP_REQUEST       EventRecord_ChangeDetail = 201 // Request changed
	EventRecord_APP_REJECT        EventRecord_ChangeDetail = 202 // Application rejected on create
	EventRecord_APP_NEW           EventRecord_ChangeDetail = 203 // Application added with state new
	EventRecord_APP_ACCEPTED      EventRecord_ChangeDetail = 204 // State change to accepted
	EventRecord_APP_STARTING      EventRecord_ChangeDetail = 205 // State change to starting
	EventRecord_APP_RUNNING       EventRecord_ChangeDetail = 206 // State change to running
	EventRecord_APP_COMPLETING    EventRecord_ChangeDetail = 207 // State change to completing
	EventRecord_APP_COMPLETED     EventRecord_ChangeDetail = 208 // State change to completed
	EventRecord_APP_FAILING       EventRecord_ChangeDetail = 209 // State change to failing
	EventRecord_APP_FAILED        EventRecord_ChangeDetail = 210 // State change to failed
	EventRecord_APP_RESUMING      EventRecord_ChangeDetail = 211 // State change to resuming
	EventRecord_APP_EXPIRED       EventRecord_ChangeDetail = 212 // State change to expired
	EventRecord_NODE_DECOMISSION  EventRecord_ChangeDetail = 300 // Node removal
	EventRecord_NODE_READY        EventRecord_ChangeDetail = 301 // Node ready state change
	EventRecord_NODE_SCHEDULABLE  EventRecord_ChangeDetail = 302 // Node schedulable state change (cordon)
	EventRecord_NODE_ALLOC        EventRecord_ChangeDetail = 303 // Allocation changed
	EventRecord_NODE_CAPACITY     EventRecord_ChangeDetail = 304 // Capacity changed
	EventRecord_NODE_OCCUPIED     EventRecord_ChangeDetail = 305 // Occupied resource changed
	EventRecord_NODE_RESERVATION  EventRecord_ChangeDetail = 306 // Reservation/unreservation occurred
	EventRecord_QUEUE_CONFIG      EventRecord_ChangeDetail = 400 // Managed queue update or removal
	EventRecord_QUEUE_DYNAMIC     EventRecord_ChangeDetail = 401 // Dynamic queue update or removal
	EventRecord_QUEUE_TYPE        EventRecord_ChangeDetail = 402 // Queue type change
	EventRecord_QUEUE_MAX         EventRecord_ChangeDetail = 403 // Max resource changed
	EventRecord_QUEUE_GUARANTEED  EventRecord_ChangeDetail = 404 // Guaranteed resource changed
	EventRecord_QUEUE_APP         EventRecord_ChangeDetail = 405 // Application changed
	EventRecord_QUEUE_ALLOC       EventRecord_ChangeDetail = 406 // Allocation changed
	EventRecord_ALLOC_CANCEL      EventRecord_ChangeDetail = 500 // Allocation cancelled by the RM
	EventRecord_ALLOC_PREEMPT     EventRecord_ChangeDetail = 501 // Allocation preempted by the core
	EventRecord_ALLOC_TIMEOUT     EventRecord_ChangeDetail = 502 // Allocation cancelled due to timeout
	EventRecord_ALLOC_REPLACED    EventRecord_ChangeDetail = 503 // Allocation replacement (placeholder)
	EventRecord_ALLOC_NODEREMOVED EventRecord_ChangeDetail = 504 // Allocation cancelled, node removal
)

// Enum value maps for EventRecord_ChangeDetail.
var (
	EventRecord_ChangeDetail_name = map[int32]string{
		0:   "DETAILS_NONE",
		100: "REQUEST_CANCEL",
		101: "REQUEST_ALLOC",
		102: "REQUEST_TIMEOUT",
		200: "APP_ALLOC",
		201: "APP_REQUEST",
		202: "APP_REJECT",
		203: "APP_NEW",
		204: "APP_ACCEPTED",
		205: "APP_STARTING",
		206: "APP_RUNNING",
		207: "APP_COMPLETING",
		208: "APP_COMPLETED",
		209: "APP_FAILING",
		210: "APP_FAILED",
		211: "APP_RESUMING",
		212: "APP_EXPIRED",
		300: "NODE_DECOMISSION",
		301: "NODE_READY",
		302: "NODE_SCHEDULABLE",
		303: "NODE_ALLOC",
		304: "NODE_CAPACITY",
		305: "NODE_OCCUPIED",
		306: "NODE_RESERVATION",
		400: "QUEUE_CONFIG",
		401: "QUEUE_DYNAMIC",
		402: "QUEUE_TYPE",
		403: "QUEUE_MAX",
		404: "QUEUE_GUARANTEED",
		405: "QUEUE_APP",
		406: "QUEUE_ALLOC",
		500: "ALLOC_CANCEL",
		501: "ALLOC_PREEMPT",
		502: "ALLOC_TIMEOUT",
		503: "ALLOC_REPLACED",
		504: "ALLOC_NODEREMOVED",
	}
	EventRecord_ChangeDetail_value = map[string]int32{
		"DETAILS_NONE":      0,
		"REQUEST_CANCEL":    100,
		"REQUEST_ALLOC":     101,
		"REQUEST_TIMEOUT":   102,
		"APP_ALLOC":         200,
		"APP_REQUEST":       201,
		"APP_REJECT":        202,
		"APP_NEW":           203,
		"APP_ACCEPTED":      204,
		"APP_STARTING":      205,
		"APP_RUNNING":       206,
		"APP_COMPLETING":    207,
		"APP_COMPLETED":     208,
		"APP_FAILING":       209,
		"APP_FAILED":        210,
		"APP_RESUMING":      211,
		"APP_EXPIRED":       212,
		"NODE_DECOMISSION":  300,
		"NODE_READY":        301,
		"NODE_SCHEDULABLE":  302,
		"NODE_ALLOC":        303,
		"NODE_CAPACITY":     304,
		"NODE_OCCUPIED":     305,
		"NODE_RESERVATION":  306,
		"QUEUE_CONFIG":      400,
		"QUEUE_DYNAMIC":     401,
		"QUEUE_TYPE":        402,
		"QUEUE_MAX":         403,
		"QUEUE_GUARANTEED":  404,
		"QUEUE_APP":         405,
		"QUEUE_ALLOC":       406,
		"ALLOC_CANCEL":      500,
		"ALLOC_PREEMPT":     501,
		"ALLOC_TIMEOUT":     502,
		"ALLOC_REPLACED":    503,
		"ALLOC_NODEREMOVED": 504,
	}
)

func (x EventRecord_ChangeDetail) Enum() *EventRecord_ChangeDetail {
	p := new(EventRecord_ChangeDetail)
	*p = x
	return p
}

func (x EventRecord_ChangeDetail) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventRecord_ChangeDetail) Descriptor() protoreflect.EnumDescriptor {
	return file_yunikorn_scheduler_interface_si_proto_enumTypes[5].Descriptor()
}

func (EventRecord_ChangeDetail) Type() protoreflect.EnumType {
	return &file_yunikorn_scheduler_interface_si_proto_enumTypes[5]
}

func (x EventRecord_ChangeDetail) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventRecord_ChangeDetail.Descriptor instead.
func (EventRecord_ChangeDetail) EnumDescriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{32, 2}
}

type RegisterResourceManagerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An ID which can uniquely identify a RM **cluster**. (For example, if a RM cluster has multiple manager instances for HA purpose, they should use the same information when do registration).
	// If RM register with the same ID, all previous scheduling state in memory will be cleaned up, and expect RM report full scheduling state after registration.
	RmID string `protobuf:"bytes,1,opt,name=rmID,proto3" json:"rmID,omitempty"`
	// Version of RM scheduler interface client.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Policy group name:
	// This defines which policy to use. Policy should be statically configured. (Think about network security group concept of ec2).
	// Different RMs can refer to the same policyGroup if their static configuration is identical.
	PolicyGroup string `protobuf:"bytes,3,opt,name=policyGroup,proto3" json:"policyGroup,omitempty"`
	// Pass the build information of k8shim to core.
	BuildInfo map[string]string `protobuf:"bytes,4,rep,name=buildInfo,proto3" json:"buildInfo,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Pass the serialized configuration for this policyGroup to core.
	Config string `protobuf:"bytes,5,opt,name=config,proto3" json:"config,omitempty"`
	// Additional configuration key/value pairs for configuration not related to the policyGroup.
	ExtraConfig map[string]string `protobuf:"bytes,6,rep,name=extraConfig,proto3" json:"extraConfig,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RegisterResourceManagerRequest) Reset() {
	*x = RegisterResourceManagerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResourceManagerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResourceManagerRequest) ProtoMessage() {}

func (x *RegisterResourceManagerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResourceManagerRequest.ProtoReflect.Descriptor instead.
func (*RegisterResourceManagerRequest) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{0}
}

func (x *RegisterResourceManagerRequest) GetRmID() string {
	if x != nil {
		return x.RmID
	}
	return ""
}

func (x *RegisterResourceManagerRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *RegisterResourceManagerRequest) GetPolicyGroup() string {
	if x != nil {
		return x.PolicyGroup
	}
	return ""
}

func (x *RegisterResourceManagerRequest) GetBuildInfo() map[string]string {
	if x != nil {
		return x.BuildInfo
	}
	return nil
}

func (x *RegisterResourceManagerRequest) GetConfig() string {
	if x != nil {
		return x.Config
	}
	return ""
}

func (x *RegisterResourceManagerRequest) GetExtraConfig() map[string]string {
	if x != nil {
		return x.ExtraConfig
	}
	return nil
}

// Upon success, scheduler returns RegisterResourceManagerResponse to RM, otherwise RM receives exception.
type RegisterResourceManagerResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RegisterResourceManagerResponse) Reset() {
	*x = RegisterResourceManagerResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResourceManagerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResourceManagerResponse) ProtoMessage() {}

func (x *RegisterResourceManagerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResourceManagerResponse.ProtoReflect.Descriptor instead.
func (*RegisterResourceManagerResponse) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{1}
}

type AllocationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// New allocation requests or replace existing allocation request (if allocationID is same)
	Asks []*AllocationAsk `protobuf:"bytes,1,rep,name=asks,proto3" json:"asks,omitempty"`
	// Allocations can be released.
	Releases *AllocationReleasesRequest `protobuf:"bytes,2,opt,name=releases,proto3" json:"releases,omitempty"`
	// ID of RM, this will be used to identify which RM of the request comes from.
	RmID string `protobuf:"bytes,3,opt,name=rmID,proto3" json:"rmID,omitempty"`
	// Existing allocations to be added.
	Allocations []*Allocation `protobuf:"bytes,4,rep,name=allocations,proto3" json:"allocations,omitempty"`
}

func (x *AllocationRequest) Reset() {
	*x = AllocationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationRequest) ProtoMessage() {}

func (x *AllocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationRequest.ProtoReflect.Descriptor instead.
func (*AllocationRequest) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{2}
}

func (x *AllocationRequest) GetAsks() []*AllocationAsk {
	if x != nil {
		return x.Asks
	}
	return nil
}

func (x *AllocationRequest) GetReleases() *AllocationReleasesRequest {
	if x != nil {
		return x.Releases
	}
	return nil
}

func (x *AllocationRequest) GetRmID() string {
	if x != nil {
		return x.RmID
	}
	return ""
}

func (x *AllocationRequest) GetAllocations() []*Allocation {
	if x != nil {
		return x.Allocations
	}
	return nil
}

type ApplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// RM should explicitly add application when allocation request also explictly belongs to application.
	// This is optional if allocation request doesn't belong to a application. (Independent allocation)
	New []*AddApplicationRequest `protobuf:"bytes,1,rep,name=new,proto3" json:"new,omitempty"`
	// RM can also remove applications, all allocation/allocation requests associated with the application will be removed
	Remove []*RemoveApplicationRequest `protobuf:"bytes,2,rep,name=remove,proto3" json:"remove,omitempty"`
	// ID of RM, this will be used to identify which RM of the request comes from.
	RmID string `protobuf:"bytes,3,opt,name=rmID,proto3" json:"rmID,omitempty"`
}

func (x *ApplicationRequest) Reset() {
	*x = ApplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationRequest) ProtoMessage() {}

func (x *ApplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationRequest.ProtoReflect.Descriptor instead.
func (*ApplicationRequest) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{3}
}

func (x *ApplicationRequest) GetNew() []*AddApplicationRequest {
	if x != nil {
		return x.New
	}
	return nil
}

func (x *ApplicationRequest) GetRemove() []*RemoveApplicationRequest {
	if x != nil {
		return x.Remove
	}
	return nil
}

func (x *ApplicationRequest) GetRmID() string {
	if x != nil {
		return x.RmID
	}
	return ""
}

type NodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// New node can be scheduled. If a node is notified to be "unscheduable", it needs to be part of this field as well.
	Nodes []*NodeInfo `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	// ID of RM, this will be used to identify which RM of the request comes from.
	RmID string `protobuf:"bytes,2,opt,name=rmID,proto3" json:"rmID,omitempty"`
}

func (x *NodeRequest) Reset() {
	*x = NodeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeRequest) ProtoMessage() {}

func (x *NodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeRequest.ProtoReflect.Descriptor instead.
func (*NodeRequest) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{4}
}

func (x *NodeRequest) GetNodes() []*NodeInfo {
	if x != nil {
		return x.Nodes
	}
	return nil
}

func (x *NodeRequest) GetRmID() string {
	if x != nil {
		return x.RmID
	}
	return ""
}

type AllocationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// New allocations
	New []*Allocation `protobuf:"bytes,1,rep,name=new,proto3" json:"new,omitempty"`
	// Released allocations, this could be either ack from scheduler when RM asks to terminate some allocations.
	// Or it could be decision made by scheduler (such as preemption or timeout).
	Released []*AllocationRelease `protobuf:"bytes,2,rep,name=released,proto3" json:"released,omitempty"`
	// Released allocation asks(placeholder), when the placeholder allocation times out
	ReleasedAsks []*AllocationAskRelease `protobuf:"bytes,3,rep,name=releasedAsks,proto3" json:"releasedAsks,omitempty"`
	// Rejected allocation requests
	Rejected []*RejectedAllocationAsk `protobuf:"bytes,4,rep,name=rejected,proto3" json:"rejected,omitempty"`
	// Rejected allocations
	RejectedAllocations []*RejectedAllocation `protobuf:"bytes,5,rep,name=rejectedAllocations,proto3" json:"rejectedAllocations,omitempty"`
}

func (x *AllocationResponse) Reset() {
	*x = AllocationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationResponse) ProtoMessage() {}

func (x *AllocationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationResponse.ProtoReflect.Descriptor instead.
func (*AllocationResponse) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{5}
}

func (x *AllocationResponse) GetNew() []*Allocation {
	if x != nil {
		return x.New
	}
	return nil
}

func (x *AllocationResponse) GetReleased() []*AllocationRelease {
	if x != nil {
		return x.Released
	}
	return nil
}

func (x *AllocationResponse) GetReleasedAsks() []*AllocationAskRelease {
	if x != nil {
		return x.ReleasedAsks
	}
	return nil
}

func (x *AllocationResponse) GetRejected() []*RejectedAllocationAsk {
	if x != nil {
		return x.Rejected
	}
	return nil
}

func (x *AllocationResponse) GetRejectedAllocations() []*RejectedAllocation {
	if x != nil {
		return x.RejectedAllocations
	}
	return nil
}

type ApplicationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Rejected Applications
	Rejected []*RejectedApplication `protobuf:"bytes,1,rep,name=rejected,proto3" json:"rejected,omitempty"`
	// Accepted Applications
	Accepted []*AcceptedApplication `protobuf:"bytes,2,rep,name=accepted,proto3" json:"accepted,omitempty"`
	// Updated Applications
	Updated []*UpdatedApplication `protobuf:"bytes,3,rep,name=updated,proto3" json:"updated,omitempty"`
}

func (x *ApplicationResponse) Reset() {
	*x = ApplicationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationResponse) ProtoMessage() {}

func (x *ApplicationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationResponse.ProtoReflect.Descriptor instead.
func (*ApplicationResponse) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{6}
}

func (x *ApplicationResponse) GetRejected() []*RejectedApplication {
	if x != nil {
		return x.Rejected
	}
	return nil
}

func (x *ApplicationResponse) GetAccepted() []*AcceptedApplication {
	if x != nil {
		return x.Accepted
	}
	return nil
}

func (x *ApplicationResponse) GetUpdated() []*UpdatedApplication {
	if x != nil {
		return x.Updated
	}
	return nil
}

type NodeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Rejected Node Registrations
	Rejected []*RejectedNode `protobuf:"bytes,1,rep,name=rejected,proto3" json:"rejected,omitempty"`
	// Accepted Node Registrations
	Accepted []*AcceptedNode `protobuf:"bytes,2,rep,name=accepted,proto3" json:"accepted,omitempty"`
}

func (x *NodeResponse) Reset() {
	*x = NodeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeResponse) ProtoMessage() {}

func (x *NodeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeResponse.ProtoReflect.Descriptor instead.
func (*NodeResponse) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{7}
}

func (x *NodeResponse) GetRejected() []*RejectedNode {
	if x != nil {
		return x.Rejected
	}
	return nil
}

func (x *NodeResponse) GetAccepted() []*AcceptedNode {
	if x != nil {
		return x.Accepted
	}
	return nil
}

type UpdatedApplication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The application ID that was updated
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// State of the application
	State string `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	// Timestamp of the state transition
	StateTransitionTimestamp int64 `protobuf:"varint,3,opt,name=stateTransitionTimestamp,proto3" json:"stateTransitionTimestamp,omitempty"`
	// Detailed message
	Message string `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *UpdatedApplication) Reset() {
	*x = UpdatedApplication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatedApplication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatedApplication) ProtoMessage() {}

func (x *UpdatedApplication) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatedApplication.ProtoReflect.Descriptor instead.
func (*UpdatedApplication) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{8}
}

func (x *UpdatedApplication) GetApplicationID() string {
	if x != nil {
		return x.ApplicationID
	}
	return ""
}

func (x *UpdatedApplication) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *UpdatedApplication) GetStateTransitionTimestamp() int64 {
	if x != nil {
		return x.StateTransitionTimestamp
	}
	return 0
}

func (x *UpdatedApplication) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type RejectedApplication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The application ID that was rejected
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// A human-readable reason message
	Reason string `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (x *RejectedApplication) Reset() {
	*x = RejectedApplication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RejectedApplication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejectedApplication) ProtoMessage() {}

func (x *RejectedApplication) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejectedApplication.ProtoReflect.Descriptor instead.
func (*RejectedApplication) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{9}
}

func (x *RejectedApplication) GetApplicationID() string {
	if x != nil {
		return x.ApplicationID
	}
	return ""
}

func (x *RejectedApplication) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

type AcceptedApplication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The application ID that was accepted
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
}

func (x *AcceptedApplication) Reset() {
	*x = AcceptedApplication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceptedApplication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceptedApplication) ProtoMessage() {}

func (x *AcceptedApplication) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceptedApplication.ProtoReflect.Descriptor instead.
func (*AcceptedApplication) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{10}
}

func (x *AcceptedApplication) GetApplicationID() string {
	if x != nil {
		return x.ApplicationID
	}
	return ""
}

type RejectedNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The node ID that was rejected
	NodeID string `protobuf:"bytes,1,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// A human-readable reason message
	Reason string `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (x *RejectedNode) Reset() {
	*x = RejectedNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RejectedNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejectedNode) ProtoMessage() {}

func (x *RejectedNode) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejectedNode.ProtoReflect.Descriptor instead.
func (*RejectedNode) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{11}
}

func (x *RejectedNode) GetNodeID() string {
	if x != nil {
		return x.NodeID
	}
	return ""
}

func (x *RejectedNode) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

type AcceptedNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The node ID that was accepted
	NodeID string `protobuf:"bytes,1,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
}

func (x *AcceptedNode) Reset() {
	*x = AcceptedNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceptedNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceptedNode) ProtoMessage() {}

func (x *AcceptedNode) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceptedNode.ProtoReflect.Descriptor instead.
func (*AcceptedNode) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{12}
}

func (x *AcceptedNode) GetNodeID() string {
	if x != nil {
		return x.NodeID
	}
	return ""
}

// A sparse map of resource to Quantity.
type Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Resources map[string]*Quantity `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Resource) Reset() {
	*x = Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{13}
}

func (x *Resource) GetResources() map[string]*Quantity {
	if x != nil {
		return x.Resources
	}
	return nil
}

// Quantity includes a single int64 value
type Quantity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value int64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Quantity) Reset() {
	*x = Quantity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Quantity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Quantity) ProtoMessage() {}

func (x *Quantity) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Quantity.ProtoReflect.Descriptor instead.
func (*Quantity) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{14}
}

func (x *Quantity) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

type AllocationAsk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Allocation key is used by both of scheduler and RM to track allocations.
	// It doesn't have to be same as RM's internal allocation id (such as Pod name of K8s or ContainerID of YARN).
	// Allocations from the same AllocationAsk which are returned to the RM at the same time will have the same allocationKey.
	// The request is considered an update of the existing AllocationAsk if an AllocationAsk with the same allocationKey
	// already exists.
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// The application ID this allocation ask belongs to
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// The partition the application belongs to
	PartitionName string `protobuf:"bytes,3,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// The amount of resources per ask
	ResourceAsk *Resource `protobuf:"bytes,4,opt,name=resourceAsk,proto3" json:"resourceAsk,omitempty"`
	// Maximum number of allocations
	MaxAllocations int32 `protobuf:"varint,5,opt,name=maxAllocations,proto3" json:"maxAllocations,omitempty"`
	// Priority of ask
	Priority int32 `protobuf:"varint,6,opt,name=priority,proto3" json:"priority,omitempty"`
	// Execution timeout: How long this allocation will be terminated (by scheduler)
	// once allocated by scheduler, 0 or negative value means never expire.
	ExecutionTimeoutMilliSeconds int64 `protobuf:"varint,7,opt,name=executionTimeoutMilliSeconds,proto3" json:"executionTimeoutMilliSeconds,omitempty"`
	// A set of tags for this spscific AllocationAsk. Allocation level tags are used in placing this specific
	// ask on nodes in the cluster. These tags are used in the PlacementConstraints.
	// These tags are optional.
	Tags map[string]string `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of the TaskGroup this ask belongs to
	TaskGroupName string `protobuf:"bytes,9,opt,name=taskGroupName,proto3" json:"taskGroupName,omitempty"`
	// Is this a placeholder ask (true) or a real ask (false), defaults to false
	// ignored if the taskGroupName is not set
	Placeholder bool `protobuf:"varint,10,opt,name=placeholder,proto3" json:"placeholder,omitempty"`
	// Is this ask the originator of the application?
	Originator bool `protobuf:"varint,11,opt,name=Originator,proto3" json:"Originator,omitempty"`
	// The preemption policy for this ask
	PreemptionPolicy *PreemptionPolicy `protobuf:"bytes,12,opt,name=preemptionPolicy,proto3" json:"preemptionPolicy,omitempty"`
}

func (x *AllocationAsk) Reset() {
	*x = AllocationAsk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationAsk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationAsk) ProtoMessage() {}

func (x *AllocationAsk) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationAsk.ProtoReflect.Descriptor instead.
func (*AllocationAsk) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{15}
}

func (x *AllocationAsk) GetAllocationKey() string {
	if x != nil {
		return x.AllocationKey
	}
	return ""
}

func (x *AllocationAsk) GetApplicationID() string {
	if x != nil {
		return x.ApplicationID
	}
	return ""
}

func (x *AllocationAsk) GetPartitionName() string {
	if x != nil {
		return x.PartitionName
	}
	return ""
}

func (x *AllocationAsk) GetResourceAsk() *Resource {
	if x != nil {
		return x.ResourceAsk
	}
	return nil
}

func (x *AllocationAsk) GetMaxAllocations() int32 {
	if x != nil {
		return x.MaxAllocations
	}
	return 0
}

func (x *AllocationAsk) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *AllocationAsk) GetExecutionTimeoutMilliSeconds() int64 {
	if x != nil {
		return x.ExecutionTimeoutMilliSeconds
	}
	return 0
}

func (x *AllocationAsk) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *AllocationAsk) GetTaskGroupName() string {
	if x != nil {
		return x.TaskGroupName
	}
	return ""
}

func (x *AllocationAsk) GetPlaceholder() bool {
	if x != nil {
		return x.Placeholder
	}
	return false
}

func (x *AllocationAsk) GetOriginator() bool {
	if x != nil {
		return x.Originator
	}
	return false
}

func (x *AllocationAsk) GetPreemptionPolicy() *PreemptionPolicy {
	if x != nil {
		return x.PreemptionPolicy
	}
	return nil
}

type PreemptionPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opt-out from preemption
	AllowPreemptSelf bool `protobuf:"varint,1,opt,name=allowPreemptSelf,proto3" json:"allowPreemptSelf,omitempty"`
	// Allow preemption of other tasks with same or lower priority
	AllowPreemptOther bool `protobuf:"varint,2,opt,name=allowPreemptOther,proto3" json:"allowPreemptOther,omitempty"`
}

func (x *PreemptionPolicy) Reset() {
	*x = PreemptionPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreemptionPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreemptionPolicy) ProtoMessage() {}

func (x *PreemptionPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreemptionPolicy.ProtoReflect.Descriptor instead.
func (*PreemptionPolicy) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{16}
}

func (x *PreemptionPolicy) GetAllowPreemptSelf() bool {
	if x != nil {
		return x.AllowPreemptSelf
	}
	return false
}

func (x *PreemptionPolicy) GetAllowPreemptOther() bool {
	if x != nil {
		return x.AllowPreemptOther
	}
	return false
}

type AddApplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the application, must be unique
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// The queue this application is requesting. The scheduler will place the application into a
	// queue according to policy, taking into account the requested queue as per the policy.
	QueueName string `protobuf:"bytes,2,opt,name=queueName,proto3" json:"queueName,omitempty"`
	// The partition the application belongs to
	PartitionName string `protobuf:"bytes,3,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// The user group information of the application owner
	Ugi *UserGroupInformation `protobuf:"bytes,4,opt,name=ugi,proto3" json:"ugi,omitempty"`
	// A set of tags for the application. These tags provide application level generic inforamtion.
	// The tags are optional and are used in placing an appliction or scheduling.
	// Application tags are not considered when processing AllocationAsks.
	Tags map[string]string `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Execution timeout: How long this application can be in a running state
	// 0 or negative value means never expire.
	ExecutionTimeoutMilliSeconds int64 `protobuf:"varint,6,opt,name=executionTimeoutMilliSeconds,proto3" json:"executionTimeoutMilliSeconds,omitempty"`
	// The total amount of resources gang placeholders will request
	PlaceholderAsk *Resource `protobuf:"bytes,7,opt,name=placeholderAsk,proto3" json:"placeholderAsk,omitempty"`
	// Gang scheduling style can be hard (the application will fail after placeholder timeout)
	// or soft (after the timeout the application will be scheduled as a normal application)
	GangSchedulingStyle string `protobuf:"bytes,8,opt,name=gangSchedulingStyle,proto3" json:"gangSchedulingStyle,omitempty"`
}

func (x *AddApplicationRequest) Reset() {
	*x = AddApplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddApplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddApplicationRequest) ProtoMessage() {}

func (x *AddApplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddApplicationRequest.ProtoReflect.Descriptor instead.
func (*AddApplicationRequest) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{17}
}

func (x *AddApplicationRequest) GetApplicationID() string {
	if x != nil {
		return x.ApplicationID
	}
	return ""
}

func (x *AddApplicationRequest) GetQueueName() string {
	if x != nil {
		return x.QueueName
	}
	return ""
}

func (x *AddApplicationRequest) GetPartitionName() string {
	if x != nil {
		return x.PartitionName
	}
	return ""
}

func (x *AddApplicationRequest) GetUgi() *UserGroupInformation {
	if x != nil {
		return x.Ugi
	}
	return nil
}

func (x *AddApplicationRequest) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *AddApplicationRequest) GetExecutionTimeoutMilliSeconds() int64 {
	if x != nil {
		return x.ExecutionTimeoutMilliSeconds
	}
	return 0
}

func (x *AddApplicationRequest) GetPlaceholderAsk() *Resource {
	if x != nil {
		return x.PlaceholderAsk
	}
	return nil
}

func (x *AddApplicationRequest) GetGangSchedulingStyle() string {
	if x != nil {
		return x.GangSchedulingStyle
	}
	return ""
}

type RemoveApplicationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the application to remove
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// The partition the application belongs to
	PartitionName string `protobuf:"bytes,2,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
}

func (x *RemoveApplicationRequest) Reset() {
	*x = RemoveApplicationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveApplicationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveApplicationRequest) ProtoMessage() {}

func (x *RemoveApplicationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveApplicationRequest.ProtoReflect.Descriptor instead.
func (*RemoveApplicationRequest) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{18}
}

func (x *RemoveApplicationRequest) GetApplicationID() string {
	if x != nil {
		return x.ApplicationID
	}
	return ""
}

func (x *RemoveApplicationRequest) GetPartitionName() string {
	if x != nil {
		return x.PartitionName
	}
	return ""
}

type UserGroupInformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the user name
	User string `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	// the list of groups of the user, can be empty
	Groups []string `protobuf:"bytes,2,rep,name=groups,proto3" json:"groups,omitempty"`
}

func (x *UserGroupInformation) Reset() {
	*x = UserGroupInformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserGroupInformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserGroupInformation) ProtoMessage() {}

func (x *UserGroupInformation) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserGroupInformation.ProtoReflect.Descriptor instead.
func (*UserGroupInformation) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{19}
}

func (x *UserGroupInformation) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *UserGroupInformation) GetGroups() []string {
	if x != nil {
		return x.Groups
	}
	return nil
}

type Allocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// AllocationKey from AllocationAsk
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// Allocation tags from AllocationAsk
	AllocationTags map[string]string `protobuf:"bytes,2,rep,name=allocationTags,proto3" json:"allocationTags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// UUID of the allocation
	UUID string `protobuf:"bytes,3,opt,name=UUID,proto3" json:"UUID,omitempty"`
	// Resource for each allocation
	ResourcePerAlloc *Resource `protobuf:"bytes,5,opt,name=resourcePerAlloc,proto3" json:"resourcePerAlloc,omitempty"`
	// Priority of ask
	Priority int32 `protobuf:"varint,6,opt,name=priority,proto3" json:"priority,omitempty"`
	// Node which the allocation belongs to
	NodeID string `protobuf:"bytes,8,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// The ID of the application
	ApplicationID string `protobuf:"bytes,9,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// Partition of the allocation
	PartitionName string `protobuf:"bytes,10,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// The name of the TaskGroup this allocation belongs to
	TaskGroupName string `protobuf:"bytes,11,opt,name=taskGroupName,proto3" json:"taskGroupName,omitempty"`
	// Is this a placeholder allocation (true) or a real allocation (false), defaults to false
	// ignored if the taskGroupName is not set
	Placeholder bool `protobuf:"varint,12,opt,name=placeholder,proto3" json:"placeholder,omitempty"`
}

func (x *Allocation) Reset() {
	*x = Allocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Allocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Allocation) ProtoMessage() {}

func (x *Allocation) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Allocation.ProtoReflect.Descriptor instead.
func (*Allocation) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{20}
}

func (x *Allocation) GetAllocationKey() string {
	if x != nil {
		return x.AllocationKey
	}
	return ""
}

func (x *Allocation) GetAllocationTags() map[string]string {
	if x != nil {
		return x.AllocationTags
	}
	return nil
}

func (x *Allocation) GetUUID() string {
	if x != nil {
		return x.UUID
	}
	return ""
}

func (x *Allocation) GetResourcePerAlloc() *Resource {
	if x != nil {
		return x.ResourcePerAlloc
	}
	return nil
}

func (x *Allocation) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *Allocation) GetNodeID() string {
	if x != nil {
		return x.NodeID
	}
	return ""
}

func (x *Allocation) GetApplicationID() string {
	if x != nil {
		return x.ApplicationID
	}
	return ""
}

func (x *Allocation) GetPartitionName() string {
	if x != nil {
		return x.PartitionName
	}
	return ""
}

func (x *Allocation) GetTaskGroupName() string {
	if x != nil {
		return x.TaskGroupName
	}
	return ""
}

func (x *Allocation) GetPlaceholder() bool {
	if x != nil {
		return x.Placeholder
	}
	return false
}

type AllocationReleasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The allocations to release
	AllocationsToRelease []*AllocationRelease `protobuf:"bytes,1,rep,name=allocationsToRelease,proto3" json:"allocationsToRelease,omitempty"`
	// The asks to release
	AllocationAsksToRelease []*AllocationAskRelease `protobuf:"bytes,2,rep,name=allocationAsksToRelease,proto3" json:"allocationAsksToRelease,omitempty"`
}

func (x *AllocationReleasesRequest) Reset() {
	*x = AllocationReleasesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationReleasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationReleasesRequest) ProtoMessage() {}

func (x *AllocationReleasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationReleasesRequest.ProtoReflect.Descriptor instead.
func (*AllocationReleasesRequest) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{21}
}

func (x *AllocationReleasesRequest) GetAllocationsToRelease() []*AllocationRelease {
	if x != nil {
		return x.AllocationsToRelease
	}
	return nil
}

func (x *AllocationReleasesRequest) GetAllocationAsksToRelease() []*AllocationAskRelease {
	if x != nil {
		return x.AllocationAsksToRelease
	}
	return nil
}

// Release allocation: this is a bidirectional message. The Terminationtype defines the origin, or creator,
// as per the comment. The confirmation or response from the receiver is the same message with the same
// termination type set.
type AllocationRelease struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the partition the allocation belongs to
	PartitionName string `protobuf:"bytes,1,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// The application the allocation belongs to
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// The UUID of the allocation to release, if not set all allocations are released for
	// the applicationID
	UUID string `protobuf:"bytes,3,opt,name=UUID,proto3" json:"UUID,omitempty"`
	// Termination type of the released allocation
	TerminationType TerminationType `protobuf:"varint,4,opt,name=terminationType,proto3,enum=si.v1.TerminationType" json:"terminationType,omitempty"`
	// human-readable message
	Message string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	// AllocationKey from AllocationAsk
	AllocationKey string `protobuf:"bytes,6,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
}

func (x *AllocationRelease) Reset() {
	*x = AllocationRelease{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationRelease) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationRelease) ProtoMessage() {}

func (x *AllocationRelease) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationRelease.ProtoReflect.Descriptor instead.
func (*AllocationRelease) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{22}
}

func (x *AllocationRelease) GetPartitionName() string {
	if x != nil {
		return x.PartitionName
	}
	return ""
}

func (x *AllocationRelease) GetApplicationID() string {
	if x != nil {
		return x.ApplicationID
	}
	return ""
}

func (x *AllocationRelease) GetUUID() string {
	if x != nil {
		return x.UUID
	}
	return ""
}

func (x *AllocationRelease) GetTerminationType() TerminationType {
	if x != nil {
		return x.TerminationType
	}
	return TerminationType_UNKNOWN_TERMINATION_TYPE
}

func (x *AllocationRelease) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *AllocationRelease) GetAllocationKey() string {
	if x != nil {
		return x.AllocationKey
	}
	return ""
}

// Release ask
type AllocationAskRelease struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which partition to release the ask from, required.
	PartitionName string `protobuf:"bytes,1,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// optional, when this is set, filter allocation key by application id.
	// when application id is set and allocationKey is not set, release all allocations key under the application id.
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// optional, when this is set, only release allocation ask by specified
	AllocationKey string `protobuf:"bytes,3,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// Termination type of the released allocation ask
	TerminationType TerminationType `protobuf:"varint,4,opt,name=terminationType,proto3,enum=si.v1.TerminationType" json:"terminationType,omitempty"`
	// For human-readable message
	Message string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *AllocationAskRelease) Reset() {
	*x = AllocationAskRelease{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationAskRelease) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationAskRelease) ProtoMessage() {}

func (x *AllocationAskRelease) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationAskRelease.ProtoReflect.Descriptor instead.
func (*AllocationAskRelease) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{23}
}

func (x *AllocationAskRelease) GetPartitionName() string {
	if x != nil {
		return x.PartitionName
	}
	return ""
}

func (x *AllocationAskRelease) GetApplicationID() string {
	if x != nil {
		return x.ApplicationID
	}
	return ""
}

func (x *AllocationAskRelease) GetAllocationKey() string {
	if x != nil {
		return x.AllocationKey
	}
	return ""
}

func (x *AllocationAskRelease) GetTerminationType() TerminationType {
	if x != nil {
		return x.TerminationType
	}
	return TerminationType_UNKNOWN_TERMINATION_TYPE
}

func (x *AllocationAskRelease) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type NodeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of node, the node must exist to be updated
	NodeID string `protobuf:"bytes,1,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// Action to perform by the scheduler
	Action NodeInfo_ActionFromRM `protobuf:"varint,2,opt,name=action,proto3,enum=si.v1.NodeInfo_ActionFromRM" json:"action,omitempty"`
	// New attributes of node, which will replace previously reported attribute.
	Attributes map[string]string `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// new schedulable resource, scheduler may preempt allocations on the
	// node or schedule more allocations accordingly.
	SchedulableResource *Resource `protobuf:"bytes,4,opt,name=schedulableResource,proto3" json:"schedulableResource,omitempty"`
	// when the scheduler is co-exist with some other schedulers, some node
	// resources might be occupied (allocated) by other schedulers.
	OccupiedResource *Resource `protobuf:"bytes,5,opt,name=occupiedResource,proto3" json:"occupiedResource,omitempty"`
	// Allocated resources, this will be added when node registered to RM (recovery)
	ExistingAllocations []*Allocation `protobuf:"bytes,6,rep,name=existingAllocations,proto3" json:"existingAllocations,omitempty"`
}

func (x *NodeInfo) Reset() {
	*x = NodeInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeInfo) ProtoMessage() {}

func (x *NodeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeInfo.ProtoReflect.Descriptor instead.
func (*NodeInfo) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{24}
}

func (x *NodeInfo) GetNodeID() string {
	if x != nil {
		return x.NodeID
	}
	return ""
}

func (x *NodeInfo) GetAction() NodeInfo_ActionFromRM {
	if x != nil {
		return x.Action
	}
	return NodeInfo_UNKNOWN_ACTION_FROM_RM
}

func (x *NodeInfo) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *NodeInfo) GetSchedulableResource() *Resource {
	if x != nil {
		return x.SchedulableResource
	}
	return nil
}

func (x *NodeInfo) GetOccupiedResource() *Resource {
	if x != nil {
		return x.OccupiedResource
	}
	return nil
}

func (x *NodeInfo) GetExistingAllocations() []*Allocation {
	if x != nil {
		return x.ExistingAllocations
	}
	return nil
}

type RejectedAllocationAsk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the ID of the allocation ask
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// The ID of the application
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// A human-readable reason message
	Reason string `protobuf:"bytes,3,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (x *RejectedAllocationAsk) Reset() {
	*x = RejectedAllocationAsk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RejectedAllocationAsk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejectedAllocationAsk) ProtoMessage() {}

func (x *RejectedAllocationAsk) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejectedAllocationAsk.ProtoReflect.Descriptor instead.
func (*RejectedAllocationAsk) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{25}
}

func (x *RejectedAllocationAsk) GetAllocationKey() string {
	if x != nil {
		return x.AllocationKey
	}
	return ""
}

func (x *RejectedAllocationAsk) GetApplicationID() string {
	if x != nil {
		return x.ApplicationID
	}
	return ""
}

func (x *RejectedAllocationAsk) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

type RejectedAllocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the ID of the allocation
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// The ID of the application
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// A human-readable reason message
	Reason string `protobuf:"bytes,3,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (x *RejectedAllocation) Reset() {
	*x = RejectedAllocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RejectedAllocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejectedAllocation) ProtoMessage() {}

func (x *RejectedAllocation) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejectedAllocation.ProtoReflect.Descriptor instead.
func (*RejectedAllocation) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{26}
}

func (x *RejectedAllocation) GetAllocationKey() string {
	if x != nil {
		return x.AllocationKey
	}
	return ""
}

func (x *RejectedAllocation) GetApplicationID() string {
	if x != nil {
		return x.ApplicationID
	}
	return ""
}

func (x *RejectedAllocation) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

type PredicatesArgs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// allocation key identifies a container, the predicates function is going to check
	// if this container is eligible to be placed ont to a node.
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// the node ID the container is assigned to.
	NodeID string `protobuf:"bytes,2,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// run the predicates for alloactions (true) or reservations (false)
	Allocate bool `protobuf:"varint,3,opt,name=allocate,proto3" json:"allocate,omitempty"`
}

func (x *PredicatesArgs) Reset() {
	*x = PredicatesArgs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PredicatesArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredicatesArgs) ProtoMessage() {}

func (x *PredicatesArgs) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredicatesArgs.ProtoReflect.Descriptor instead.
func (*PredicatesArgs) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{27}
}

func (x *PredicatesArgs) GetAllocationKey() string {
	if x != nil {
		return x.AllocationKey
	}
	return ""
}

func (x *PredicatesArgs) GetNodeID() string {
	if x != nil {
		return x.NodeID
	}
	return ""
}

func (x *PredicatesArgs) GetAllocate() bool {
	if x != nil {
		return x.Allocate
	}
	return false
}

type PreemptionPredicatesArgs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the allocation key of the container to check
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// the node ID the container should be attempted to be scheduled on
	NodeID string `protobuf:"bytes,2,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// a list of existing allocations that should be tentatively removed before checking
	PreemptAllocationKeys []string `protobuf:"bytes,3,rep,name=preemptAllocationKeys,proto3" json:"preemptAllocationKeys,omitempty"`
	// index of last allocation in starting attempt (first attempt should be 0..startIndex)
	StartIndex int32 `protobuf:"varint,4,opt,name=startIndex,proto3" json:"startIndex,omitempty"`
}

func (x *PreemptionPredicatesArgs) Reset() {
	*x = PreemptionPredicatesArgs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreemptionPredicatesArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreemptionPredicatesArgs) ProtoMessage() {}

func (x *PreemptionPredicatesArgs) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreemptionPredicatesArgs.ProtoReflect.Descriptor instead.
func (*PreemptionPredicatesArgs) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{28}
}

func (x *PreemptionPredicatesArgs) GetAllocationKey() string {
	if x != nil {
		return x.AllocationKey
	}
	return ""
}

func (x *PreemptionPredicatesArgs) GetNodeID() string {
	if x != nil {
		return x.NodeID
	}
	return ""
}

func (x *PreemptionPredicatesArgs) GetPreemptAllocationKeys() []string {
	if x != nil {
		return x.PreemptAllocationKeys
	}
	return nil
}

func (x *PreemptionPredicatesArgs) GetStartIndex() int32 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

type PreemptionPredicatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// whether or not container will schedule on the node
	Success bool `protobuf:"varint,1,opt,name=success,proto3" json:"success,omitempty"`
	// index of last allocation which was removed before success (ignored during failure)
	Index int32 `protobuf:"varint,2,opt,name=index,proto3" json:"index,omitempty"`
}

func (x *PreemptionPredicatesResponse) Reset() {
	*x = PreemptionPredicatesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreemptionPredicatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreemptionPredicatesResponse) ProtoMessage() {}

func (x *PreemptionPredicatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreemptionPredicatesResponse.ProtoReflect.Descriptor instead.
func (*PreemptionPredicatesResponse) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{29}
}

func (x *PreemptionPredicatesResponse) GetSuccess() bool {
	if x != nil {
		return x.Success
	}
	return false
}

func (x *PreemptionPredicatesResponse) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

type UpdateContainerSchedulingStateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// application ID
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// allocation key used to identify a container.
	AllocationKey string `protobuf:"bytes,2,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// container scheduling state
	State UpdateContainerSchedulingStateRequest_SchedulingState `protobuf:"varint,3,opt,name=state,proto3,enum=si.v1.UpdateContainerSchedulingStateRequest_SchedulingState" json:"state,omitempty"`
	// an optional plain message to explain why it is in such state
	Reason string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (x *UpdateContainerSchedulingStateRequest) Reset() {
	*x = UpdateContainerSchedulingStateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateContainerSchedulingStateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateContainerSchedulingStateRequest) ProtoMessage() {}

func (x *UpdateContainerSchedulingStateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateContainerSchedulingStateRequest.ProtoReflect.Descriptor instead.
func (*UpdateContainerSchedulingStateRequest) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateContainerSchedulingStateRequest) GetApplicationID() string {
	if x != nil {
		return x.ApplicationID
	}
	return ""
}

func (x *UpdateContainerSchedulingStateRequest) GetAllocationKey() string {
	if x != nil {
		return x.AllocationKey
	}
	return ""
}

func (x *UpdateContainerSchedulingStateRequest) GetState() UpdateContainerSchedulingStateRequest_SchedulingState {
	if x != nil {
		return x.State
	}
	return UpdateContainerSchedulingStateRequest_UNKNOWN_SCHEDULING_STATE
}

func (x *UpdateContainerSchedulingStateRequest) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

type UpdateConfigurationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// RM ID to update
	RmID string `protobuf:"bytes,2,opt,name=rmID,proto3" json:"rmID,omitempty"`
	// PolicyGroup to update
	PolicyGroup string `protobuf:"bytes,3,opt,name=policyGroup,proto3" json:"policyGroup,omitempty"`
	// New configuration to update
	Config string `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	// Additional configuration key/value pairs for configuration not related to the policyGroup.
	ExtraConfig map[string]string `protobuf:"bytes,5,rep,name=extraConfig,proto3" json:"extraConfig,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *UpdateConfigurationRequest) Reset() {
	*x = UpdateConfigurationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConfigurationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConfigurationRequest) ProtoMessage() {}

func (x *UpdateConfigurationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConfigurationRequest.ProtoReflect.Descriptor instead.
func (*UpdateConfigurationRequest) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{31}
}

func (x *UpdateConfigurationRequest) GetRmID() string {
	if x != nil {
		return x.RmID
	}
	return ""
}

func (x *UpdateConfigurationRequest) GetPolicyGroup() string {
	if x != nil {
		return x.PolicyGroup
	}
	return ""
}

func (x *UpdateConfigurationRequest) GetConfig() string {
	if x != nil {
		return x.Config
	}
	return ""
}

func (x *UpdateConfigurationRequest) GetExtraConfig() map[string]string {
	if x != nil {
		return x.ExtraConfig
	}
	return nil
}

type EventRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the type of the object associated with the event
	Type EventRecord_Type `protobuf:"varint,1,opt,name=type,proto3,enum=si.v1.EventRecord_Type" json:"type,omitempty"`
	// ID of the object associated with the event
	ObjectID string `protobuf:"bytes,2,opt,name=objectID,proto3" json:"objectID,omitempty"`
	// the detailed message as string
	Message string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	// timestamp of the event
	TimestampNano int64 `protobuf:"varint,6,opt,name=timestampNano,proto3" json:"timestampNano,omitempty"`
	// the type of the change
	EventChangeType EventRecord_ChangeType `protobuf:"varint,7,opt,name=eventChangeType,proto3,enum=si.v1.EventRecord_ChangeType" json:"eventChangeType,omitempty"`
	// details about the change
	EventChangeDetail EventRecord_ChangeDetail `protobuf:"varint,8,opt,name=eventChangeDetail,proto3,enum=si.v1.EventRecord_ChangeDetail" json:"eventChangeDetail,omitempty"`
	// the secondary object in the event (eg. allocation UUID, request ID)
	ReferenceID string `protobuf:"bytes,9,opt,name=referenceID,proto3" json:"referenceID,omitempty"`
	// the resource value if the change involves setting/modifying a resource
	Resource *Resource `protobuf:"bytes,10,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *EventRecord) Reset() {
	*x = EventRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventRecord) ProtoMessage() {}

func (x *EventRecord) ProtoReflect() protoreflect.Message {
	mi := &file_yunikorn_scheduler_interface_si_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventRecord.ProtoReflect.Descriptor instead.
func (*EventRecord) Descriptor() ([]byte, []int) {
	return file_yunikorn_scheduler_interface_si_proto_rawDescGZIP(), []int{32}
}

func (x *EventRecord) GetType() EventRecord_Type {
	if x != nil {
		return x.Type
	}
	return EventRecord_UNKNOWN_EVENTRECORD_TYPE
}

func (x *EventRecord) GetObjectID() string {
	if x != nil {
		return x.ObjectID
	}
	return ""
}

func (x *EventRecord) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *EventRecord) GetTimestampNano() int64 {
	if x != nil {
		return x.TimestampNano
	}
	return 0
}

func (x *EventRecord) GetEventChangeType() EventRecord_ChangeType {
	if x != nil {
		return x.EventChangeType
	}
	return EventRecord_NONE
}

func (x *EventRecord) GetEventChangeDetail() EventRecord_ChangeDetail {
	if x != nil {
		return x.EventChangeDetail
	}
	return EventRecord_DETAILS_NONE
}

func (x *EventRecord) GetReferenceID() string {
	if x != nil {
		return x.ReferenceID
	}
	return ""
}

func (x *EventRecord) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

var file_yunikorn_scheduler_interface_si_proto_extTypes = []protoimpl.ExtensionInfo{
	{
		ExtendedType:  (*descriptorpb.FieldOptions)(nil),
		ExtensionType: (*bool)(nil),
		Field:         1059,
		Name:          "si.v1.si_secret",
		Tag:           "varint,1059,opt,name=si_secret",
		Filename:      "yunikorn-scheduler-interface/si.proto",
	},
}

// Extension fields to descriptorpb.FieldOptions.
var (
	// Indicates that a field MAY contain information that is sensitive
	// and MUST be treated as such (e.g. not logged).
	//
	// optional bool si_secret = 1059;
	E_SiSecret = &file_yunikorn_scheduler_interface_si_proto_extTypes[0]
)

var File_yunikorn_scheduler_interface_si_proto protoreflect.FileDescriptor

var file_yunikorn_scheduler_interface_si_proto_rawDesc = []byte{
	0x0a, 0x25, 0x79, 0x75, 0x6e, 0x69, 0x6b, 0x6f, 0x72, 0x6e, 0x2d, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x72, 0x2d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x2f, 0x73,
	0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x05, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xb4, 0x03, 0x0a, 0x1e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6d, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x72, 0x6d, 0x49, 0x44, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x52, 0x0a, 0x09, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x58, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x72, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x72,
	0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x65, 0x78,
	0x74, 0x72, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3c, 0x0a, 0x0e, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x45, 0x78, 0x74, 0x72, 0x61,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x21, 0x0a, 0x1f, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x11, 0x41,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x28, 0x0a, 0x04, 0x61, 0x73, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x73, 0x6b, 0x52, 0x04, 0x61, 0x73, 0x6b, 0x73, 0x12, 0x3c, 0x0a, 0x08, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x73,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x08,
	0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6d, 0x49, 0x44,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6d, 0x49, 0x44, 0x12, 0x33, 0x0a, 0x0b,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x11, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x22, 0x91, 0x01, 0x0a, 0x12, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2e, 0x0a, 0x03, 0x6e, 0x65, 0x77, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64,
	0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x52, 0x03, 0x6e, 0x65, 0x77, 0x12, 0x37, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6d, 0x49, 0x44, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x72, 0x6d, 0x49, 0x44, 0x22, 0x48, 0x0a, 0x0b, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x72,
	0x6d, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6d, 0x49, 0x44, 0x22,
	0xb7, 0x02, 0x0a, 0x12, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x03, 0x6e, 0x65, 0x77, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x6e, 0x65, 0x77, 0x12, 0x34, 0x0a, 0x08, 0x72,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x08, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x64, 0x12, 0x3f, 0x0a, 0x0c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x64, 0x41, 0x73, 0x6b,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x6b, 0x52, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x64, 0x41, 0x73,
	0x6b, 0x73, 0x12, 0x38, 0x0a, 0x08, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6a,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x12, 0x4b, 0x0a, 0x13,
	0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x73, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xba, 0x01, 0x0a, 0x13, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x36, 0x0a, 0x08, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6a, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x08, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x12, 0x36, 0x0a, 0x08, 0x61, 0x63, 0x63,
	0x65, 0x70, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x73, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65,
	0x64, 0x12, 0x33, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x22, 0x70, 0x0a, 0x0c, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x08, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x08, 0x72,
	0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x12, 0x2f, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x65, 0x70,
	0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x08,
	0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x22, 0xa6, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x24, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3a, 0x0a, 0x18, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x22, 0x53, 0x0a, 0x13, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x16,
	0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x3b, 0x0a, 0x13, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74,
	0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a,
	0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x44, 0x22, 0x3e, 0x0a, 0x0c, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4e,
	0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x22, 0x26, 0x0a, 0x0c, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x4e,
	0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x22, 0x97, 0x01, 0x0a, 0x08,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3c, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x73, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x4d, 0x0a, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x25, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x20, 0x0a, 0x08, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xd6, 0x04, 0x0a, 0x0d, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x6b, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12,
	0x24, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x24, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x0b, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0f, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x73, 0x6b, 0x12, 0x26,
	0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x42, 0x0a, 0x1c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x53,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x32, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x6b, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x74, 0x61,
	0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74,
	0x6f, 0x72, 0x12, 0x43, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x73,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x10, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x6c, 0x0a, 0x10, 0x50, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x2a, 0x0a, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x50, 0x72, 0x65,
	0x65, 0x6d, 0x70, 0x74, 0x53, 0x65, 0x6c, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x50, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x53, 0x65, 0x6c, 0x66,
	0x12, 0x2c, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x50, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74,
	0x4f, 0x74, 0x68, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x50, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x22, 0xd4,
	0x03, 0x0a, 0x15, 0x41, 0x64, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x1c,
	0x0a, 0x09, 0x71, 0x75, 0x65, 0x75, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x71, 0x75, 0x65, 0x75, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x03, 0x75, 0x67, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x75, 0x67,
	0x69, 0x12, 0x3a, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x61,
	0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x42, 0x0a,
	0x1c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x1c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x73, 0x12, 0x37, 0x0a, 0x0e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x41, 0x73, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0e, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x41, 0x73, 0x6b, 0x12, 0x30, 0x0a, 0x13, 0x67, 0x61,
	0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x79, 0x6c,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x67, 0x61, 0x6e, 0x67, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x1a, 0x37, 0x0a, 0x09,
	0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x66, 0x0a, 0x18, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x24, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x42, 0x0a,
	0x14, 0x55, 0x73, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x22, 0xee, 0x03, 0x0a, 0x0a, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x24, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x4d, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x61, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x55, 0x55, 0x49, 0x44, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x55, 0x55, 0x49, 0x44, 0x12, 0x3b, 0x0a, 0x10, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x65,
	0x72, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44,
	0x12, 0x24, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74,
	0x61, 0x73, 0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x1a, 0x41,
	0x0a, 0x13, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x4a, 0x04, 0x08, 0x07, 0x10, 0x08, 0x52, 0x09, 0x71, 0x75, 0x65, 0x75, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0xc0, 0x01, 0x0a, 0x19, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4c, 0x0a, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x54,
	0x6f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x54, 0x6f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x55,
	0x0a, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x6b, 0x73,
	0x54, 0x6f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x73, 0x6b, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x17, 0x61, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x6b, 0x73, 0x54, 0x6f, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x22, 0xf5, 0x01, 0x0a, 0x11, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x12, 0x0a, 0x04, 0x55, 0x55, 0x49, 0x44, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x55, 0x55, 0x49, 0x44, 0x12, 0x40, 0x0a, 0x0f, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x22, 0xe4, 0x01,
	0x0a, 0x14, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x6b, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x40, 0x0a, 0x0f, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x16, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x22, 0xaf, 0x04, 0x0a, 0x08, 0x4e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x12, 0x34, 0x0a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x73, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x72, 0x6f, 0x6d, 0x52, 0x4d, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3f, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x12, 0x41, 0x0a, 0x13, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e,
	0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x13,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x10, 0x6f, 0x63, 0x63, 0x75, 0x70, 0x69, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e,
	0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x10,
	0x6f, 0x63, 0x63, 0x75, 0x70, 0x69, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x43, 0x0a, 0x13, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x13, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x8f, 0x01, 0x0a, 0x0c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x46,
	0x72, 0x6f, 0x6d, 0x52, 0x4d, 0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x52, 0x4d, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x52, 0x41,
	0x49, 0x4e, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x45, 0x43,
	0x4f, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x44, 0x52,
	0x41, 0x49, 0x4e, 0x5f, 0x54, 0x4f, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x41, 0x42,
	0x4c, 0x45, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x44,
	0x52, 0x41, 0x49, 0x4e, 0x10, 0x06, 0x22, 0x7b, 0x0a, 0x15, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x6b, 0x12,
	0x24, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x22, 0x78, 0x0a, 0x12, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12,
	0x24, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x6a, 0x0a,
	0x0e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x41, 0x72, 0x67, 0x73, 0x12,
	0x24, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x12, 0x1a, 0x0a,
	0x08, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x08, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x22, 0xae, 0x01, 0x0a, 0x18, 0x50, 0x72,
	0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x73, 0x41, 0x72, 0x67, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x16, 0x0a, 0x06,
	0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x6f,
	0x64, 0x65, 0x49, 0x44, 0x12, 0x34, 0x0a, 0x15, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x41,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x15, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x4e, 0x0a, 0x1c, 0x50, 0x72,
	0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xc6, 0x02, 0x0a, 0x25, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x12, 0x52, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3c, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x65, 0x0a, 0x0f,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x1c, 0x0a, 0x18, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44,
	0x55, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x43,
	0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53,
	0x45, 0x52, 0x56, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x04, 0x22, 0x8f, 0x02, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6d, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x72, 0x6d, 0x49, 0x44, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x54, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x72, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3e, 0x0a, 0x10, 0x45, 0x78, 0x74, 0x72, 0x61, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x52, 0x07, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x22, 0xe2, 0x09, 0x0a, 0x0b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x2b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x44, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x44, 0x12, 0x18,
	0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x4e, 0x61, 0x6e, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0d, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4e, 0x61, 0x6e, 0x6f, 0x12, 0x47,
	0x0a, 0x0f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4d, 0x0a, 0x11, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x52, 0x11, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x49, 0x44, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x44, 0x12, 0x2b, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x4f, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a,
	0x18, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x52, 0x45,
	0x43, 0x4f, 0x52, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x50, 0x50, 0x10,
	0x02, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x51,
	0x55, 0x45, 0x55, 0x45, 0x10, 0x04, 0x22, 0x34, 0x0a, 0x0a, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x07,
	0x0a, 0x03, 0x53, 0x45, 0x54, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x44, 0x44, 0x10, 0x02,
	0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x10, 0x03, 0x22, 0xbe, 0x05, 0x0a,
	0x0c, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x10, 0x0a,
	0x0c, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x53, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12,
	0x12, 0x0a, 0x0e, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45,
	0x4c, 0x10, 0x64, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x41,
	0x4c, 0x4c, 0x4f, 0x43, 0x10, 0x65, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53,
	0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x66, 0x12, 0x0e, 0x0a, 0x09, 0x41,
	0x50, 0x50, 0x5f, 0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x10, 0xc8, 0x01, 0x12, 0x10, 0x0a, 0x0b, 0x41,
	0x50, 0x50, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0xc9, 0x01, 0x12, 0x0f, 0x0a,
	0x0a, 0x41, 0x50, 0x50, 0x5f, 0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x10, 0xca, 0x01, 0x12, 0x0c,
	0x0a, 0x07, 0x41, 0x50, 0x50, 0x5f, 0x4e, 0x45, 0x57, 0x10, 0xcb, 0x01, 0x12, 0x11, 0x0a, 0x0c,
	0x41, 0x50, 0x50, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x45, 0x44, 0x10, 0xcc, 0x01, 0x12,
	0x11, 0x0a, 0x0c, 0x41, 0x50, 0x50, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0xcd, 0x01, 0x12, 0x10, 0x0a, 0x0b, 0x41, 0x50, 0x50, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e,
	0x47, 0x10, 0xce, 0x01, 0x12, 0x13, 0x0a, 0x0e, 0x41, 0x50, 0x50, 0x5f, 0x43, 0x4f, 0x4d, 0x50,
	0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0xcf, 0x01, 0x12, 0x12, 0x0a, 0x0d, 0x41, 0x50, 0x50,
	0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0xd0, 0x01, 0x12, 0x10, 0x0a,
	0x0b, 0x41, 0x50, 0x50, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0xd1, 0x01, 0x12,
	0x0f, 0x0a, 0x0a, 0x41, 0x50, 0x50, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0xd2, 0x01,
	0x12, 0x11, 0x0a, 0x0c, 0x41, 0x50, 0x50, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4d, 0x49, 0x4e, 0x47,
	0x10, 0xd3, 0x01, 0x12, 0x10, 0x0a, 0x0b, 0x41, 0x50, 0x50, 0x5f, 0x45, 0x58, 0x50, 0x49, 0x52,
	0x45, 0x44, 0x10, 0xd4, 0x01, 0x12, 0x15, 0x0a, 0x10, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x45,
	0x43, 0x4f, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0xac, 0x02, 0x12, 0x0f, 0x0a, 0x0a,
	0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0xad, 0x02, 0x12, 0x15, 0x0a,
	0x10, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x41, 0x42, 0x4c,
	0x45, 0x10, 0xae, 0x02, 0x12, 0x0f, 0x0a, 0x0a, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x41, 0x4c, 0x4c,
	0x4f, 0x43, 0x10, 0xaf, 0x02, 0x12, 0x12, 0x0a, 0x0d, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x43, 0x41,
	0x50, 0x41, 0x43, 0x49, 0x54, 0x59, 0x10, 0xb0, 0x02, 0x12, 0x12, 0x0a, 0x0d, 0x4e, 0x4f, 0x44,
	0x45, 0x5f, 0x4f, 0x43, 0x43, 0x55, 0x50, 0x49, 0x45, 0x44, 0x10, 0xb1, 0x02, 0x12, 0x15, 0x0a,
	0x10, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0xb2, 0x02, 0x12, 0x11, 0x0a, 0x0c, 0x51, 0x55, 0x45, 0x55, 0x45, 0x5f, 0x43, 0x4f,
	0x4e, 0x46, 0x49, 0x47, 0x10, 0x90, 0x03, 0x12, 0x12, 0x0a, 0x0d, 0x51, 0x55, 0x45, 0x55, 0x45,
	0x5f, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x10, 0x91, 0x03, 0x12, 0x0f, 0x0a, 0x0a, 0x51,
	0x55, 0x45, 0x55, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x92, 0x03, 0x12, 0x0e, 0x0a, 0x09,
	0x51, 0x55, 0x45, 0x55, 0x45, 0x5f, 0x4d, 0x41, 0x58, 0x10, 0x93, 0x03, 0x12, 0x15, 0x0a, 0x10,
	0x51, 0x55, 0x45, 0x55, 0x45, 0x5f, 0x47, 0x55, 0x41, 0x52, 0x41, 0x4e, 0x54, 0x45, 0x45, 0x44,
	0x10, 0x94, 0x03, 0x12, 0x0e, 0x0a, 0x09, 0x51, 0x55, 0x45, 0x55, 0x45, 0x5f, 0x41, 0x50, 0x50,
	0x10, 0x95, 0x03, 0x12, 0x10, 0x0a, 0x0b, 0x51, 0x55, 0x45, 0x55, 0x45, 0x5f, 0x41, 0x4c, 0x4c,
	0x4f, 0x43, 0x10, 0x96, 0x03, 0x12, 0x11, 0x0a, 0x0c, 0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x5f, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x10, 0xf4, 0x03, 0x12, 0x12, 0x0a, 0x0d, 0x41, 0x4c, 0x4c, 0x4f,
	0x43, 0x5f, 0x50, 0x52, 0x45, 0x45, 0x4d, 0x50, 0x54, 0x10, 0xf5, 0x03, 0x12, 0x12, 0x0a, 0x0d,
	0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0xf6, 0x03,
	0x12, 0x13, 0x0a, 0x0e, 0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43,
	0x45, 0x44, 0x10, 0xf7, 0x03, 0x12, 0x16, 0x0a, 0x11, 0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x5f, 0x4e,
	0x4f, 0x44, 0x45, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10, 0xf8, 0x03, 0x4a, 0x04, 0x08,
	0x03, 0x10, 0x04, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x49, 0x44, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x2a, 0x85, 0x01, 0x0a, 0x0f, 0x54,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c,
	0x0a, 0x18, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d,
	0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x52, 0x4d, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16,
	0x50, 0x52, 0x45, 0x45, 0x4d, 0x50, 0x54, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x53, 0x43, 0x48,
	0x45, 0x44, 0x55, 0x4c, 0x45, 0x52, 0x10, 0x03, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x4c, 0x41, 0x43,
	0x45, 0x48, 0x4f, 0x4c, 0x44, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x44,
	0x10, 0x04, 0x32, 0xd5, 0x02, 0x0a, 0x09, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72,
	0x12, 0x6a, 0x0a, 0x17, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12, 0x25, 0x2e, 0x73, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x26, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4d, 0x0a, 0x10,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x18, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x73, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0x50, 0x0a, 0x11, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x19, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x73, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0x3b, 0x0a,
	0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x2e, 0x73, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x13, 0x2e, 0x73, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x3a, 0x3b, 0x0a, 0x09, 0x73, 0x69,
	0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xa3, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73,
	0x69, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x42, 0x0b, 0x5a, 0x09, 0x6c, 0x69, 0x62, 0x2f, 0x67,
	0x6f, 0x2f, 0x73, 0x69, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yunikorn_scheduler_interface_si_proto_rawDescOnce sync.Once
	file_yunikorn_scheduler_interface_si_proto_rawDescData = file_yunikorn_scheduler_interface_si_proto_rawDesc
)

func file_yunikorn_scheduler_interface_si_proto_rawDescGZIP() []byte {
	file_yunikorn_scheduler_interface_si_proto_rawDescOnce.Do(func() {
		file_yunikorn_scheduler_interface_si_proto_rawDescData = protoimpl.X.CompressGZIP(file_yunikorn_scheduler_interface_si_proto_rawDescData)
	})
	return file_yunikorn_scheduler_interface_si_proto_rawDescData
}

var file_yunikorn_scheduler_interface_si_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_yunikorn_scheduler_interface_si_proto_msgTypes = make([]protoimpl.MessageInfo, 41)
var file_yunikorn_scheduler_interface_si_proto_goTypes = []interface{}{
	(TerminationType)(0),       // 0: si.v1.TerminationType
	(NodeInfo_ActionFromRM)(0), // 1: si.v1.NodeInfo.ActionFromRM
	(UpdateContainerSchedulingStateRequest_SchedulingState)(0), // 2: si.v1.UpdateContainerSchedulingStateRequest.SchedulingState
	(EventRecord_Type)(0),                         // 3: si.v1.EventRecord.Type
	(EventRecord_ChangeType)(0),                   // 4: si.v1.EventRecord.ChangeType
	(EventRecord_ChangeDetail)(0),                 // 5: si.v1.EventRecord.ChangeDetail
	(*RegisterResourceManagerRequest)(nil),        // 6: si.v1.RegisterResourceManagerRequest
	(*RegisterResourceManagerResponse)(nil),       // 7: si.v1.RegisterResourceManagerResponse
	(*AllocationRequest)(nil),                     // 8: si.v1.AllocationRequest
	(*ApplicationRequest)(nil),                    // 9: si.v1.ApplicationRequest
	(*NodeRequest)(nil),                           // 10: si.v1.NodeRequest
	(*AllocationResponse)(nil),                    // 11: si.v1.AllocationResponse
	(*ApplicationResponse)(nil),                   // 12: si.v1.ApplicationResponse
	(*NodeResponse)(nil),                          // 13: si.v1.NodeResponse
	(*UpdatedApplication)(nil),                    // 14: si.v1.UpdatedApplication
	(*RejectedApplication)(nil),                   // 15: si.v1.RejectedApplication
	(*AcceptedApplication)(nil),                   // 16: si.v1.AcceptedApplication
	(*RejectedNode)(nil),                          // 17: si.v1.RejectedNode
	(*AcceptedNode)(nil),                          // 18: si.v1.AcceptedNode
	(*Resource)(nil),                              // 19: si.v1.Resource
	(*Quantity)(nil),                              // 20: si.v1.Quantity
	(*AllocationAsk)(nil),                         // 21: si.v1.AllocationAsk
	(*PreemptionPolicy)(nil),                      // 22: si.v1.PreemptionPolicy
	(*AddApplicationRequest)(nil),                 // 23: si.v1.AddApplicationRequest
	(*RemoveApplicationRequest)(nil),              // 24: si.v1.RemoveApplicationRequest
	(*UserGroupInformation)(nil),                  // 25: si.v1.UserGroupInformation
	(*Allocation)(nil),                            // 26: si.v1.Allocation
	(*AllocationReleasesRequest)(nil),             // 27: si.v1.AllocationReleasesRequest
	(*AllocationRelease)(nil),                     // 28: si.v1.AllocationRelease
	(*AllocationAskRelease)(nil),                  // 29: si.v1.AllocationAskRelease
	(*NodeInfo)(nil),                              // 30: si.v1.NodeInfo
	(*RejectedAllocationAsk)(nil),                 // 31: si.v1.RejectedAllocationAsk
	(*RejectedAllocation)(nil),                    // 32: si.v1.RejectedAllocation
	(*PredicatesArgs)(nil),                        // 33: si.v1.PredicatesArgs
	(*PreemptionPredicatesArgs)(nil),              // 34: si.v1.PreemptionPredicatesArgs
	(*PreemptionPredicatesResponse)(nil),          // 35: si.v1.PreemptionPredicatesResponse
	(*UpdateContainerSchedulingStateRequest)(nil), // 36: si.v1.UpdateContainerSchedulingStateRequest
	(*UpdateConfigurationRequest)(nil),            // 37: si.v1.UpdateConfigurationRequest
	(*EventRecord)(nil),                           // 38: si.v1.EventRecord
	nil,                                           // 39: si.v1.RegisterResourceManagerRequest.BuildInfoEntry
	nil,                                           // 40: si.v1.RegisterResourceManagerRequest.ExtraConfigEntry
	nil,                                           // 41: si.v1.Resource.ResourcesEntry
	nil,                                           // 42: si.v1.AllocationAsk.TagsEntry
	nil,                                           // 43: si.v1.AddApplicationRequest.TagsEntry
	nil,                                           // 44: si.v1.Allocation.AllocationTagsEntry
	nil,                                           // 45: si.v1.NodeInfo.AttributesEntry
	nil,                                           // 46: si.v1.UpdateConfigurationRequest.ExtraConfigEntry
	(*descriptorpb.FieldOptions)(nil),             // 47: google.protobuf.FieldOptions
}
var file_yunikorn_scheduler_interface_si_proto_depIdxs = []int32{
	39, // 0: si.v1.RegisterResourceManagerRequest.buildInfo:type_name -> si.v1.RegisterResourceManagerRequest.BuildInfoEntry
	40, // 1: si.v1.RegisterResourceManagerRequest.extraConfig:type_name -> si.v1.RegisterResourceManagerRequest.ExtraConfigEntry
	21, // 2: si.v1.AllocationRequest.asks:type_name -> si.v1.AllocationAsk
	27, // 3: si.v1.AllocationRequest.releases:type_name -> si.v1.AllocationReleasesRequest
	26, // 4: si.v1.AllocationRequest.allocations:type_name -> si.v1.Allocation
	23, // 5: si.v1.ApplicationRequest.new:type_name -> si.v1.AddApplicationRequest
	24, // 6: si.v1.ApplicationRequest.remove:type_name -> si.v1.RemoveApplicationRequest
	30, // 7: si.v1.NodeRequest.nodes:type_name -> si.v1.NodeInfo
	26, // 8: si.v1.AllocationResponse.new:type_name -> si.v1.Allocation
	28, // 9: si.v1.AllocationResponse.released:type_name -> si.v1.AllocationRelease
	29, // 10: si.v1.AllocationResponse.releasedAsks:type_name -> si.v1.AllocationAskRelease
	31, // 11: si.v1.AllocationResponse.rejected:type_name -> si.v1.RejectedAllocationAsk
	32, // 12: si.v1.AllocationResponse.rejectedAllocations:type_name -> si.v1.RejectedAllocation
	15, // 13: si.v1.ApplicationResponse.rejected:type_name -> si.v1.RejectedApplication
	16, // 14: si.v1.ApplicationResponse.accepted:type_name -> si.v1.AcceptedApplication
	14, // 15: si.v1.ApplicationResponse.updated:type_name -> si.v1.UpdatedApplication
	17, // 16: si.v1.NodeResponse.rejected:type_name -> si.v1.RejectedNode
	18, // 17: si.v1.NodeResponse.accepted:type_name -> si.v1.AcceptedNode
	41, // 18: si.v1.Resource.resources:type_name -> si.v1.Resource.ResourcesEntry
	19, // 19: si.v1.AllocationAsk.resourceAsk:type_name -> si.v1.Resource
	42, // 20: si.v1.AllocationAsk.tags:type_name -> si.v1.AllocationAsk.TagsEntry
	22, // 21: si.v1.AllocationAsk.preemptionPolicy:type_name -> si.v1.PreemptionPolicy
	25, // 22: si.v1.AddApplicationRequest.ugi:type_name -> si.v1.UserGroupInformation
	43, // 23: si.v1.AddApplicationRequest.tags:type_name -> si.v1.AddApplicationRequest.TagsEntry
	19, // 24: si.v1.AddApplicationRequest.placeholderAsk:type_name -> si.v1.Resource
	44, // 25: si.v1.Allocation.allocationTags:type_name -> si.v1.Allocation.AllocationTagsEntry
	19, // 26: si.v1.Allocation.resourcePerAlloc:type_name -> si.v1.Resource
	28, // 27: si.v1.AllocationReleasesRequest.allocationsToRelease:type_name -> si.v1.AllocationRelease
	29, // 28: si.v1.AllocationReleasesRequest.allocationAsksToRelease:type_name -> si.v1.AllocationAskRelease
	0,  // 29: si.v1.AllocationRelease.terminationType:type_name -> si.v1.TerminationType
	0,  // 30: si.v1.AllocationAskRelease.terminationType:type_name -> si.v1.TerminationType
	1,  // 31: si.v1.NodeInfo.action:type_name -> si.v1.NodeInfo.ActionFromRM
	45, // 32: si.v1.NodeInfo.attributes:type_name -> si.v1.NodeInfo.AttributesEntry
	19, // 33: si.v1.NodeInfo.schedulableResource:type_name -> si.v1.Resource
	19, // 34: si.v1.NodeInfo.occupiedResource:type_name -> si.v1.Resource
	26, // 35: si.v1.NodeInfo.existingAllocations:type_name -> si.v1.Allocation
	2,  // 36: si.v1.UpdateContainerSchedulingStateRequest.state:type_name -> si.v1.UpdateContainerSchedulingStateRequest.SchedulingState
	46, // 37: si.v1.UpdateConfigurationRequest.extraConfig:type_name -> si.v1.UpdateConfigurationRequest.ExtraConfigEntry
	3,  // 38: si.v1.EventRecord.type:type_name -> si.v1.EventRecord.Type
	4,  // 39: si.v1.EventRecord.eventChangeType:type_name -> si.v1.EventRecord.ChangeType
	5,  // 40: si.v1.EventRecord.eventChangeDetail:type_name -> si.v1.EventRecord.ChangeDetail
	19, // 41: si.v1.EventRecord.resource:type_name -> si.v1.Resource
	20, // 42: si.v1.Resource.ResourcesEntry.value:type_name -> si.v1.Quantity
	47, // 43: si.v1.si_secret:extendee -> google.protobuf.FieldOptions
	6,  // 44: si.v1.Scheduler.RegisterResourceManager:input_type -> si.v1.RegisterResourceManagerRequest
	8,  // 45: si.v1.Scheduler.UpdateAllocation:input_type -> si.v1.AllocationRequest
	9,  // 46: si.v1.Scheduler.UpdateApplication:input_type -> si.v1.ApplicationRequest
	10, // 47: si.v1.Scheduler.UpdateNode:input_type -> si.v1.NodeRequest
	7,  // 48: si.v1.Scheduler.RegisterResourceManager:output_type -> si.v1.RegisterResourceManagerResponse
	11, // 49: si.v1.Scheduler.UpdateAllocation:output_type -> si.v1.AllocationResponse
	12, // 50: si.v1.Scheduler.UpdateApplication:output_type -> si.v1.ApplicationResponse
	13, // 51: si.v1.Scheduler.UpdateNode:output_type -> si.v1.NodeResponse
	48, // [48:52] is the sub-list for method output_type
	44, // [44:48] is the sub-list for method input_type
	44, // [44:44] is the sub-list for extension type_name
	43, // [43:44] is the sub-list for extension extendee
	0,  // [0:43] is the sub-list for field type_name
}

func init() { file_yunikorn_scheduler_interface_si_proto_init() }
func file_yunikorn_scheduler_interface_si_proto_init() {
	if File_yunikorn_scheduler_interface_si_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_yunikorn_scheduler_interface_si_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResourceManagerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResourceManagerResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatedApplication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RejectedApplication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcceptedApplication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RejectedNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcceptedNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Quantity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationAsk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreemptionPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddApplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveApplicationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserGroupInformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Allocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationReleasesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationRelease); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocationAskRelease); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RejectedAllocationAsk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RejectedAllocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PredicatesArgs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreemptionPredicatesArgs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreemptionPredicatesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateContainerSchedulingStateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConfigurationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yunikorn_scheduler_interface_si_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yunikorn_scheduler_interface_si_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   41,
			NumExtensions: 1,
			NumServices:   1,
		},
		GoTypes:           file_yunikorn_scheduler_interface_si_proto_goTypes,
		DependencyIndexes: file_yunikorn_scheduler_interface_si_proto_depIdxs,
		EnumInfos:         file_yunikorn_scheduler_interface_si_proto_enumTypes,
		MessageInfos:      file_yunikorn_scheduler_interface_si_proto_msgTypes,
		ExtensionInfos:    file_yunikorn_scheduler_interface_si_proto_extTypes,
	}.Build()
	File_yunikorn_scheduler_interface_si_proto = out.File
	file_yunikorn_scheduler_interface_si_proto_rawDesc = nil
	file_yunikorn_scheduler_interface_si_proto_goTypes = nil
	file_yunikorn_scheduler_interface_si_proto_depIdxs = nil
}
