/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFCharset;
import org.apache.fontbox.cff.CFFEncoding;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.render.pdf.pdfbox.FOPPDFFont;
import org.apache.fop.render.pdf.pdfbox.FOPPDFMultiByteFont;
import org.apache.fop.render.pdf.pdfbox.FOPPDFSingleByteFont;
import org.apache.fop.render.pdf.pdfbox.FontContainer;
import org.apache.fop.render.pdf.pdfbox.MergeCFFFonts;
import org.apache.fop.render.pdf.pdfbox.PDFWriter;
import org.apache.fop.render.pdf.pdfbox.UniqueName;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class MergeFontsPDFWriter
extends PDFWriter {
    protected static final Log log = LogFactory.getLog(MergeFontsPDFWriter.class);
    private COSDictionary fonts;
    private FontInfo fontInfo;
    private Typeface font;
    private FontContainer oldFont = null;
    protected Map<COSName, String> fontsToRemove = new HashMap<COSName, String>();
    private final Map<COSDictionary, FontContainer> fontMap = new HashMap<COSDictionary, FontContainer>();
    private static final Pattern SUBSET_PATTERN = Pattern.compile("[A-Z][A-Z][A-Z][A-Z][A-Z][A-Z]\\+.+");
    private Collection<String> parentFonts;

    public MergeFontsPDFWriter(COSDictionary fonts, FontInfo fontInfo, UniqueName key, Collection<String> parentFonts, int mcid) {
        super(key, mcid);
        this.fonts = fonts;
        this.fontInfo = fontInfo;
        this.parentFonts = parentFonts;
    }

    @Override
    public String writeText(PDStream pdStream) throws IOException {
        String txt = super.writeText(pdStream);
        if (this.fontsToRemove.isEmpty()) {
            return null;
        }
        for (COSName cn : this.fontsToRemove.keySet()) {
            this.fonts.removeItem(cn);
        }
        this.parentFonts.clear();
        this.parentFonts.addAll(this.fontsToRemove.values());
        return txt;
    }

    @Override
    protected void readPDFArguments(Operator op, Collection<COSBase> arguments) throws IOException {
        for (COSBase c : arguments) {
            if (c instanceof COSName) {
                COSName cn = (COSName)c;
                COSDictionary fontData = (COSDictionary)this.fonts.getDictionaryObject(cn.getName());
                String internalName = this.fontsToRemove.get(cn);
                if (internalName == null && fontData != null) {
                    internalName = this.getNewFont(fontData, this.fontInfo, this.fontsToRemove.values());
                }
                if (fontData == null || internalName == null) {
                    this.key.writeName(this.s, cn);
                    if (op.getName().equals("Tf")) {
                        this.font = null;
                        this.oldFont = null;
                    }
                } else {
                    this.s.append("/" + internalName);
                    this.fontsToRemove.put(cn, internalName);
                    this.font = (Typeface)this.fontInfo.getUsedFonts().get(internalName);
                    this.oldFont = this.getFont(fontData);
                }
                this.s.append(" ");
                continue;
            }
            if (c instanceof COSString && this.font != null && ((FOPPDFFont)this.font).size() != 1) {
                List<String> word = this.readCOSString((COSString)c, this.oldFont);
                if (word == null) {
                    this.s.append(PDFText.escapeString((String)this.getString((COSString)c)));
                    continue;
                }
                String x = ((FOPPDFFont)this.font).getMappedWord(word, ((COSString)c).getBytes(), this.oldFont);
                if (x == null) {
                    this.s.append(PDFText.escapeString((String)this.getString((COSString)c)));
                    continue;
                }
                this.s.append(x);
                continue;
            }
            this.processArg(op, c);
        }
    }

    private String getNewFont(COSDictionary fontData, FontInfo fontinfo, Collection<String> usedFonts) throws IOException {
        String base = this.getUniqueFontName(fontData);
        if (base == null || usedFonts.contains(base) || this.parentFonts != null && this.parentFonts.contains(base)) {
            return null;
        }
        try {
            for (Typeface t : fontinfo.getUsedFonts().values()) {
                if (!(t instanceof FOPPDFFont) || !base.equals(t.getFontName())) continue;
                return ((FOPPDFFont)t).addFont(fontData);
            }
            if (base.endsWith("cid") || fontData.getItem(COSName.SUBTYPE) != COSName.TYPE1 && fontData.getItem(COSName.SUBTYPE) != COSName.TRUE_TYPE) {
                fontinfo.addMetrics(base, (FontMetrics)new FOPPDFMultiByteFont(fontData, base));
            } else {
                fontinfo.addMetrics(base, (FontMetrics)new FOPPDFSingleByteFont(fontData, base));
            }
        }
        catch (IOException e) {
            log.warn((Object)e.getMessage());
            return null;
        }
        fontinfo.useFont(base);
        return base;
    }

    private String getUniqueFontName(COSDictionary fontData) throws IOException {
        FontContainer fontContainer = this.getFont(fontData);
        PDFont font = fontContainer.font;
        if (font.getName() != null) {
            String extra = "";
            String name = MergeFontsPDFWriter.getName(font.getName()) + "_" + ((COSName)fontData.getItem(COSName.SUBTYPE)).getName();
            if (font instanceof PDType0Font) {
                PDCIDFont descendantFont = ((PDType0Font)font).getDescendantFont();
                if (descendantFont instanceof PDCIDFontType0) {
                    CFFFont cffFont = ((PDCIDFontType0)descendantFont).getCFFFont();
                    if (cffFont instanceof CFFCIDFont && ((CFFCIDFont)cffFont).getFdSelect().getClass().getName().equals("org.apache.fontbox.cff.CFFParser$Format0FDSelect")) {
                        extra = extra + "format0";
                    }
                    return name + extra + "cff";
                }
                if (descendantFont instanceof PDCIDFontType2 && fontContainer.getToUnicode() != null) {
                    if (!MergeFontsPDFWriter.isSubsetFont(font.getName())) {
                        extra = "f3";
                    }
                    return name + extra;
                }
            } else {
                if (font instanceof PDTrueTypeFont && MergeFontsPDFWriter.isSubsetFont(font.getName())) {
                    TrueTypeFont tt = ((PDTrueTypeFont)font).getTrueTypeFont();
                    for (CmapSubtable c : tt.getCmap().getCmaps()) {
                        if (c.getGlyphId(1) <= 0) continue;
                        extra = "cid";
                    }
                    return name + extra;
                }
                if (font instanceof PDType1CFont) {
                    return this.getNamePDType1Font(name, (PDType1CFont)font);
                }
                if (font instanceof PDType1Font) {
                    return name;
                }
            }
        }
        return null;
    }

    private String getNamePDType1Font(String name, PDType1CFont font) throws IOException {
        String enc;
        String extra = "";
        CFFEncoding encoding = font.getCFFType1Font().getEncoding();
        String eClass = encoding.getClass().getName();
        if (eClass.equals("org.apache.fontbox.cff.CFFParser$Format1Encoding")) {
            extra = "f1enc";
        } else if (eClass.equals("org.apache.fontbox.cff.CFFParser$Format0Encoding")) {
            extra = "f0enc";
        }
        CFFCharset cs = font.getCFFType1Font().getCharset();
        List<Integer> sids = MergeCFFFonts.getSids(cs);
        if (!sids.isEmpty() && sids.get(0) < 391) {
            extra = extra + "stdcs";
        }
        if (cs.getClass().getName().equals("org.apache.fontbox.cff.CFFParser$Format1Charset")) {
            extra = extra + "f1cs";
        }
        if (font.getEncoding() != null && !"DictionaryEncoding".equals(enc = font.getEncoding().getClass().getSimpleName())) {
            extra = extra + enc;
        }
        return name + extra;
    }

    private String getString(COSString s) throws UnsupportedEncodingException {
        String encoding = "ISO-8859-1";
        byte[] data = s.getBytes();
        int start = 0;
        if (data.length > 2) {
            if (data[0] == -1 && data[1] == -2) {
                encoding = "UTF-16LE";
                start = 2;
            } else if (data[0] == -2 && data[1] == -1) {
                encoding = "UTF-16BE";
                start = 2;
            }
        }
        return new String(data, start, data.length - start, encoding);
    }

    private List<String> readCOSString(COSString s, FontContainer oldFont) throws IOException {
        ArrayList<String> word = new ArrayList<String>();
        byte[] string = s.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(string);
        while (((InputStream)in).available() > 0) {
            int code = oldFont.font.readCode((InputStream)in);
            String unicode = oldFont.font.toUnicode(code);
            if (unicode == null) {
                return null;
            }
            word.add(unicode);
        }
        return word;
    }

    protected FontContainer getFont(COSDictionary fontData) throws IOException {
        if (!this.fontMap.containsKey(fontData)) {
            if (this.fontMap.size() > 10) {
                this.fontMap.clear();
            }
            this.fontMap.put(fontData, new FontContainer(fontData));
        }
        return this.fontMap.get(fontData);
    }

    private static boolean isSubsetFont(String s) {
        return SUBSET_PATTERN.matcher(s).matches();
    }

    protected static String getName(String name) {
        if (MergeFontsPDFWriter.isSubsetFont(name)) {
            return name.split("\\+")[1].replace(" ", "");
        }
        return name.replace(" ", "");
    }
}

