/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.pdf.Version;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.apache.fop.render.pdf.pdfbox.ImagePDF;
import org.apache.fop.render.pdf.pdfbox.PDFBoxAdapter;
import org.apache.fop.render.pdf.pdfbox.PDFBoxEventProducer;
import org.apache.fop.render.pdf.pdfbox.TaggedPDFConductor;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.image.loader.util.SoftMapCache;

public abstract class AbstractPDFBoxHandler {
    protected Object createStreamForPDF(ImagePDF image, PDFPage targetPage, FOUserAgent userAgent, AffineTransform at, FontInfo fontinfo, Rectangle pos, Map<Integer, PDFArray> pageNumbers, PDFLogicalStructureHandler handler, PDFStructElem curentSessionElem) throws IOException {
        EventBroadcaster eventBroadcaster = null;
        if (userAgent != null) {
            eventBroadcaster = userAgent.getEventBroadcaster();
        }
        String originalImageUri = image.getInfo().getOriginalURI();
        int selectedPage = ImageUtil.needPageIndexFromURI((String)originalImageUri);
        PDDocument pddoc = image.getPDDocument();
        float pdfVersion = pddoc.getDocument().getVersion();
        Version inputDocVersion = Version.getValueOf((String)String.valueOf(pdfVersion));
        PDFDocument pdfDoc = targetPage.getDocument();
        if (pdfDoc.getPDFVersion().compareTo((Enum)inputDocVersion) < 0) {
            try {
                pdfDoc.setPDFVersion(inputDocVersion);
            }
            catch (IllegalStateException e) {
                this.getEventProducer(eventBroadcaster).pdfVersionMismatch(this, pdfDoc.getPDFVersionString(), String.valueOf(pdfVersion));
            }
        }
        if (pddoc.isEncrypted()) {
            this.getEventProducer(eventBroadcaster).encryptedPdf(this);
            return null;
        }
        if (pdfDoc.getProfile().isPDFAActive()) {
            this.getEventProducer(eventBroadcaster).pdfAActive(this);
        }
        if (pdfDoc.getProfile().isPDFXActive()) {
            this.getEventProducer(eventBroadcaster).pdfXActive(this);
        }
        Map<Object, Object> objectCachePerFile = this.getObjectCache(this.getImagePath(originalImageUri), userAgent);
        PDPage page = pddoc.getPage(selectedPage);
        if (targetPage.getPDFResources().getParentResources() == null) {
            PDFResources res = pdfDoc.getFactory().makeResources();
            res.setParentResources(pdfDoc.getResources());
            res.addContext((PDFResourceContext)targetPage);
            targetPage.put("Resources", (Object)res);
        }
        Map<Object, Object> objectCache = this.getObjectCache(this.getClass().getName(), userAgent);
        PDFBoxAdapter adapter = new PDFBoxAdapter(targetPage, objectCachePerFile, pageNumbers, objectCache);
        if (handler != null) {
            adapter.setCurrentMCID(handler.getPageParentTree().length());
        }
        Object stream = adapter.createStreamFromPDFBoxPage(pddoc, page, originalImageUri, at, fontinfo, pos);
        if (userAgent.isAccessibilityEnabled() && curentSessionElem != null) {
            TaggedPDFConductor conductor = new TaggedPDFConductor(curentSessionElem, handler, page, adapter);
            conductor.handleLogicalStructure(pddoc);
        }
        return stream;
    }

    private Map<Object, Object> getObjectCache(String path, FOUserAgent userAgent) {
        SoftMapCache objectCache = userAgent.getPDFObjectCache();
        if (objectCache.get((Object)path) == null) {
            objectCache.put((Object)path, new HashMap());
        }
        return (Map)objectCache.get((Object)path);
    }

    private String getImagePath(String originalImageUri) {
        int hashIndex = originalImageUri.indexOf(35);
        if (hashIndex > 0) {
            return originalImageUri.substring(0, hashIndex);
        }
        return originalImageUri;
    }

    private PDFBoxEventProducer getEventProducer(EventBroadcaster eventBroadcaster) {
        return PDFBoxEventProducer.Provider.get(eventBroadcaster);
    }
}

