/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test;

import java.util.Arrays;
import java.util.Vector;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.TestReport;

public abstract class PerformanceTest
extends AbstractTest {
    protected double referenceScore = -1.0;
    protected double allowedScoreDeviation = 0.15;
    protected double lastScore = -1.0;

    public double getLastScore() {
        return this.lastScore;
    }

    public double getReferenceScore() {
        return this.referenceScore;
    }

    public void setReferenceScore(double referenceScore) {
        this.referenceScore = referenceScore;
    }

    public double getAllowedScoreDeviation() {
        return this.allowedScoreDeviation;
    }

    public void setAllowedScoreDeviation(double allowedScoreDeviation) {
        this.allowedScoreDeviation = allowedScoreDeviation;
    }

    @Override
    public final TestReport run() {
        return super.run();
    }

    @Override
    public final boolean runImplBasic() {
        return false;
    }

    @Override
    public final TestReport runImpl() throws Exception {
        int trim;
        int iter = 50;
        this.runRef();
        this.runOp();
        double[] scores = new double[iter];
        int badScores = 0;
        int i = 0;
        while (i < iter) {
            double opLength;
            double refUnit;
            long opEnd;
            long refEnd;
            if (i % 2 == 0) {
                long refStart = System.currentTimeMillis();
                this.runRef();
                refEnd = System.currentTimeMillis();
                this.runOp();
                opEnd = System.currentTimeMillis();
                refUnit = refEnd - refStart;
                opLength = opEnd - refEnd;
            } else {
                long opStart = System.currentTimeMillis();
                this.runOp();
                opEnd = System.currentTimeMillis();
                this.runRef();
                refEnd = System.currentTimeMillis();
                refUnit = refEnd - opEnd;
                opLength = opEnd - opStart;
            }
            if (opLength > 0.0 && refUnit > 0.0) {
                scores[i++] = opLength / refUnit;
                System.err.print(".");
            } else {
                System.err.print("!");
                if (++badScores > iter) {
                    throw new IllegalStateException("Unable to obtain reliable timings");
                }
            }
            System.gc();
        }
        System.err.println();
        Arrays.sort(scores);
        double score = 0.0;
        for (int i2 = trim = 5; i2 < scores.length - trim; ++i2) {
            score += scores[i2];
        }
        this.lastScore = score /= (double)(iter - 2 * trim);
        if (this.referenceScore == -1.0) {
            TestReport report = this.reportError("no.reference.score.set");
            report.addDescriptionEntry("computed.score", "" + score);
            return report;
        }
        double scoreMin = this.referenceScore * (1.0 - this.allowedScoreDeviation);
        double scoreMax = this.referenceScore * (1.0 + this.allowedScoreDeviation);
        if (score > scoreMax) {
            TestReport report = this.reportError("performance.regression");
            report.addDescriptionEntry("reference.score", "" + this.referenceScore);
            report.addDescriptionEntry("computed.score", "" + score);
            report.addDescriptionEntry("score.deviation", "" + 100.0 * ((score - this.referenceScore) / this.referenceScore));
            return report;
        }
        if (score < scoreMin) {
            TestReport report = this.reportError("unexpected.performance.improvement");
            report.addDescriptionEntry("reference.score", "" + this.referenceScore);
            report.addDescriptionEntry("computed.score", "" + score);
            report.addDescriptionEntry("score.deviation", "" + 100.0 * ((score - this.referenceScore) / this.referenceScore));
            return report;
        }
        return this.reportSuccess();
    }

    protected void runRef() {
        int i;
        Vector<String> v = new Vector<String>();
        for (i = 0; i < 10000; ++i) {
            v.addElement("" + i);
        }
        for (i = 0; i < 10000; ++i) {
            if (!v.contains("" + i)) continue;
            v.remove("" + i);
        }
    }

    protected abstract void runOp() throws Exception;
}

