/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.AbstractCspHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.JavaScriptLibrarySettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.AttributeMap;

public class OnEventHeaderItem
extends AbstractCspHeaderItem {
    private static final long serialVersionUID = 1L;
    private final String target;
    private final String event;
    private final CharSequence javaScript;

    public static OnEventHeaderItem forScript(String literalTarget, String event, CharSequence javaScript) {
        return new OnEventHeaderItem(literalTarget, event, javaScript);
    }

    public static OnEventHeaderItem forComponent(Component target, String event, CharSequence javaScript) {
        return OnEventHeaderItem.forMarkupId(target.getMarkupId(), event, javaScript);
    }

    public static OnEventHeaderItem forMarkupId(String id, String event, CharSequence javaScript) {
        return OnEventHeaderItem.forScript("'" + id + "'", event, javaScript);
    }

    public OnEventHeaderItem(String target, String event) {
        this(target, event, null);
    }

    public OnEventHeaderItem(String target, String event, CharSequence javaScript) {
        this.target = Args.notEmpty((String)target, (String)"target");
        Args.notEmpty((String)event, (String)"event");
        this.event = event = event.toLowerCase(Locale.ROOT);
        this.javaScript = javaScript;
    }

    public String getTarget() {
        return this.target;
    }

    public String getEvent() {
        return this.event;
    }

    public CharSequence getJavaScript() {
        return this.javaScript;
    }

    @Override
    public void render(Response response) {
        if (!Strings.isEmpty((CharSequence)this.getJavaScript())) {
            AttributeMap attributes = new AttributeMap();
            attributes.putAttribute("type", (CharSequence)"text/javascript");
            attributes.putAttribute("nonce", (CharSequence)this.getNonce());
            JavaScriptUtils.writeInlineScript(response, this.getCompleteJavaScript(), attributes);
        }
    }

    public CharSequence getCompleteJavaScript() {
        StringBuilder result = new StringBuilder();
        result.append("Wicket.Event.add(").append(this.getTarget()).append(", '").append(this.getEvent()).append("', function(event) { ").append(this.getJavaScript()).append(";});");
        return result;
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Collections.singletonList("javascript-event-" + this.getTarget() + "-" + this.getEvent() + "-" + this.getJavaScript());
    }

    public String toString() {
        return "OnEventHeaderItem(" + this.getTarget() + ", '" + this.getEvent() + "', '" + this.getJavaScript() + "')";
    }

    public int hashCode() {
        return Objects.hash(this.target, this.event, this.javaScript);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnEventHeaderItem that = (OnEventHeaderItem)o;
        return Objects.equals(this.target, that.target) && Objects.equals(this.event, that.event) && Objects.equals(this.javaScript, that.javaScript);
    }

    @Override
    public List<HeaderItem> getDependencies() {
        JavaScriptLibrarySettings ajaxSettings = Application.get().getJavaScriptLibrarySettings();
        ResourceReference wicketAjaxReference = ajaxSettings.getWicketAjaxReference();
        List<HeaderItem> dependencies = super.getDependencies();
        dependencies.add(JavaScriptHeaderItem.forReference(wicketAjaxReference));
        return dependencies;
    }
}

