/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Objects;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.ISubresourceHeaderItem;
import org.apache.wicket.markup.html.CrossOrigin;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.value.AttributeMap;

public abstract class AbstractCssReferenceHeaderItem
extends CssHeaderItem
implements ISubresourceHeaderItem {
    private final String media;
    private final String rel;
    private CrossOrigin crossOrigin;
    private String integrity;

    public AbstractCssReferenceHeaderItem(String media, String rel) {
        this.media = media;
        this.rel = rel;
    }

    @Override
    public CrossOrigin getCrossOrigin() {
        return this.crossOrigin;
    }

    @Override
    public AbstractCssReferenceHeaderItem setCrossOrigin(CrossOrigin crossOrigin) {
        this.crossOrigin = crossOrigin;
        return this;
    }

    public String getMedia() {
        return this.media;
    }

    public String getRel() {
        return this.rel;
    }

    @Override
    public String getIntegrity() {
        return this.integrity;
    }

    @Override
    public AbstractCssReferenceHeaderItem setIntegrity(String integrity) {
        this.integrity = integrity;
        return this;
    }

    protected final void internalRenderCSSReference(Response response, String url) {
        Args.notEmpty((String)url, (String)"url");
        AttributeMap attributes = new AttributeMap();
        attributes.putAttribute("rel", (CharSequence)(this.getRel() == null ? "stylesheet" : this.getRel()));
        attributes.putAttribute("type", (CharSequence)"text/css");
        attributes.putAttribute("href", (CharSequence)url);
        attributes.putAttribute("id", (CharSequence)this.getId());
        attributes.putAttribute("media", (CharSequence)this.getMedia());
        attributes.putAttribute("crossOrigin", this.crossOrigin == null ? null : this.crossOrigin.getRealName());
        attributes.putAttribute("integrity", (CharSequence)this.integrity);
        attributes.putAttribute("nonce", (CharSequence)this.getNonce());
        CssUtils.writeLink(response, attributes);
        response.write((CharSequence)"\n");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCssReferenceHeaderItem that = (AbstractCssReferenceHeaderItem)o;
        return Objects.equals(this.integrity, that.integrity) && Objects.equals((Object)this.crossOrigin, (Object)that.crossOrigin);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.integrity, this.crossOrigin});
    }
}

