/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.util.Collection;
import java.util.Collections;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.ws.WebSocketSettings;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.api.registry.IKey;
import org.apache.wicket.protocol.ws.api.registry.IWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.concurrent.Executor;
import org.apache.wicket.util.lang.Args;

public class WebSocketPushBroadcaster {
    private final IWebSocketConnectionRegistry registry;

    public WebSocketPushBroadcaster(IWebSocketConnectionRegistry registry) {
        Args.notNull((Object)registry, (String)"registry");
        this.registry = registry;
    }

    public void broadcast(ConnectedMessage connection, IWebSocketPushMessage message) {
        Args.notNull((Object)connection, (String)"connection");
        Args.notNull((Object)message, (String)"message");
        Application application = connection.getApplication();
        String sessionId = connection.getSessionId();
        IKey key = connection.getKey();
        IWebSocketConnection wsConnection = this.registry.getConnection(application, sessionId, key);
        if (wsConnection == null) {
            return;
        }
        this.process(application, Collections.singletonList(wsConnection), message);
    }

    public void broadcastAll(Application application, IWebSocketPushMessage message) {
        Args.notNull((Object)application, (String)"application");
        Args.notNull((Object)message, (String)"message");
        Collection<IWebSocketConnection> wsConnections = this.registry.getConnections(application);
        if (wsConnections == null) {
            return;
        }
        this.process(application, wsConnections, message);
    }

    public void broadcastAllInSession(Application application, String sessionId, IWebSocketPushMessage message) {
        Args.notNull((Object)application, (String)"application");
        Args.notNull((Object)message, (String)"message");
        Args.notNull((Object)sessionId, (String)"sessionId");
        Collection<IWebSocketConnection> wsConnections = this.registry.getConnections(application, sessionId);
        if (wsConnections == null || wsConnections.isEmpty()) {
            return;
        }
        this.process(application, wsConnections, message);
    }

    public void broadcastAllMatchingFilter(Application application, IWebSocketConnectionRegistry.IConnectionsFilter connectionsFilter, IWebSocketPushMessage message) {
        Args.notNull((Object)application, (String)"application");
        Args.notNull((Object)message, (String)"message");
        Args.notNull((Object)connectionsFilter, (String)"connectionsFilter");
        Collection<IWebSocketConnection> wsConnections = this.registry.getConnections(application, connectionsFilter);
        if (wsConnections == null || wsConnections.isEmpty()) {
            return;
        }
        this.process(application, wsConnections, message);
    }

    private void process(Application application, Collection<IWebSocketConnection> wsConnections, final IWebSocketPushMessage message) {
        WebSocketSettings webSocketSettings = WebSocketSettings.Holder.get(application);
        Executor executor = webSocketSettings.getWebSocketPushMessageExecutor();
        for (final IWebSocketConnection wsConnection : wsConnections) {
            executor.run(new Runnable(){

                @Override
                public void run() {
                    wsConnection.sendMessage(message);
                }
            });
        }
    }
}

