/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Application;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.ws.WebSocketSettings;
import org.apache.wicket.protocol.ws.api.ConnectionRejected;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.IWebSocketConnectionFilter;
import org.apache.wicket.protocol.ws.api.IWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.ServletRequestCopy;
import org.apache.wicket.protocol.ws.api.WebSocketMessageBroadcastHandler;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.WebSocketRequestMapper;
import org.apache.wicket.protocol.ws.api.event.WebSocketAbortedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketBinaryPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketClosedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketConnectedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketErrorPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketPushPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketTextPayload;
import org.apache.wicket.protocol.ws.api.message.AbortedMessage;
import org.apache.wicket.protocol.ws.api.message.BinaryMessage;
import org.apache.wicket.protocol.ws.api.message.ClosedMessage;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.protocol.ws.api.message.ErrorMessage;
import org.apache.wicket.protocol.ws.api.message.IWebSocketMessage;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.api.message.TextMessage;
import org.apache.wicket.protocol.ws.api.registry.AbstractKey;
import org.apache.wicket.protocol.ws.api.registry.IKey;
import org.apache.wicket.protocol.ws.api.registry.IWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.api.registry.PageIdKey;
import org.apache.wicket.protocol.ws.api.registry.ResourceNameKey;
import org.apache.wicket.protocol.ws.api.registry.ResourceNameTokenKey;
import org.apache.wicket.request.IExceptionMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.cycle.RequestCycleContext;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebSocketProcessor
implements IWebSocketProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWebSocketProcessor.class);
    static final int NO_PAGE_ID = -1;
    static final String NO_PAGE_CLASS = "_NO_PAGE";
    private final WebRequest webRequest;
    private final int pageId;
    private final String context;
    private final String resourceName;
    private final String connectionToken;
    private final Url baseUrl;
    private final WebApplication application;
    private final String sessionId;
    private final WebSocketSettings webSocketSettings;
    private final IWebSocketConnectionRegistry connectionRegistry;
    private final IWebSocketConnectionFilter connectionFilter;
    private final HttpServletRequest servletRequest;

    public AbstractWebSocketProcessor(HttpServletRequest request, WebApplication application) {
        HttpSession httpSession = request.getSession(true);
        if (httpSession == null) {
            throw new IllegalStateException("There is no HTTP Session bound. Without a session Wicket won't be able to find the stored page to update its components");
        }
        this.sessionId = httpSession.getId();
        String pageId = request.getParameter("pageId");
        this.context = request.getParameter("context");
        this.resourceName = request.getParameter("resourceName");
        this.connectionToken = request.getParameter("connectionToken");
        if (Strings.isEmpty((CharSequence)pageId) && Strings.isEmpty((CharSequence)this.resourceName)) {
            throw new IllegalArgumentException("The request should have either 'pageId' or 'resourceName' parameter!");
        }
        this.pageId = !Strings.isEmpty((CharSequence)pageId) ? Integer.parseInt(pageId, 10) : -1;
        String baseUrl = request.getParameter("wicket-ajax-baseurl");
        Checks.notNull((Object)baseUrl, (String)String.format("Request parameter '%s' is required!", "wicket-ajax-baseurl"), (Object[])new Object[0]);
        this.baseUrl = Url.parse((CharSequence)baseUrl);
        WicketFilter wicketFilter = application.getWicketFilter();
        this.servletRequest = new ServletRequestCopy(request);
        this.application = (WebApplication)Args.notNull((Object)application, (String)"application");
        this.webSocketSettings = WebSocketSettings.Holder.get((Application)application);
        this.webRequest = this.webSocketSettings.newWebSocketRequest(request, wicketFilter.getFilterPath());
        this.connectionRegistry = this.webSocketSettings.getConnectionRegistry();
        this.connectionFilter = this.webSocketSettings.getConnectionFilter();
    }

    @Override
    public void onMessage(String message) {
        this.broadcastMessage(new TextMessage((Application)this.getApplication(), this.getSessionId(), this.getRegistryKey(), message));
    }

    @Override
    public void onMessage(byte[] data, int offset, int length) {
        BinaryMessage binaryMessage = new BinaryMessage(this.getApplication(), this.getSessionId(), this.getRegistryKey(), data, offset, length);
        this.broadcastMessage(binaryMessage);
    }

    protected final void onConnect(IWebSocketConnection connection) {
        ConnectionRejected connectionRejected;
        IKey key = this.getRegistryKey();
        this.connectionRegistry.setConnection((Application)this.getApplication(), this.getSessionId(), key, connection);
        if (this.connectionFilter != null && (connectionRejected = this.connectionFilter.doFilter(this.servletRequest)) != null) {
            this.broadcastMessage(new AbortedMessage((Application)this.getApplication(), this.getSessionId(), key));
            this.connectionRegistry.removeConnection((Application)this.getApplication(), this.getSessionId(), key);
            connection.close(connectionRejected.getCode(), connectionRejected.getReason());
            return;
        }
        this.broadcastMessage(new ConnectedMessage((Application)this.getApplication(), this.getSessionId(), key), connection);
    }

    @Override
    public void onClose(int closeCode, String message) {
        IKey key = this.getRegistryKey();
        if (this.webSocketSettings.shouldNotifyOnCloseEvent(closeCode)) {
            this.broadcastMessage(new ClosedMessage((Application)this.getApplication(), this.getSessionId(), key, closeCode, message));
        }
        this.connectionRegistry.removeConnection((Application)this.getApplication(), this.getSessionId(), key);
    }

    @Override
    public void onError(Throwable t) {
        if (this.webSocketSettings.shouldNotifyOnErrorEvent(t)) {
            IKey key = this.getRegistryKey();
            this.broadcastMessage(new ErrorMessage((Application)this.getApplication(), this.getSessionId(), key, t));
        }
    }

    public final void broadcastMessage(IWebSocketMessage message) {
        IKey key = this.getRegistryKey();
        IWebSocketConnection connection = this.connectionRegistry.getConnection((Application)this.application, this.sessionId, key);
        this.broadcastMessage(message, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void broadcastMessage(IWebSocketMessage message, IWebSocketConnection connection) {
        if (connection != null && (connection.isOpen() || AbstractWebSocketProcessor.isSpecialMessage(message))) {
            Application oldApplication = ThreadContext.getApplication();
            Session oldSession = ThreadContext.getSession();
            RequestCycle oldRequestCycle = ThreadContext.getRequestCycle();
            WebResponse webResponse = this.webSocketSettings.newWebSocketResponse(connection);
            try {
                Session session;
                WebSocketRequestMapper requestMapper = new WebSocketRequestMapper(this.application.getRootRequestMapper());
                RequestCycle requestCycle = this.createRequestCycle(requestMapper, webResponse);
                ThreadContext.setRequestCycle((RequestCycle)requestCycle);
                ThreadContext.setApplication((Application)this.application);
                if (oldSession == null || message instanceof IWebSocketPushMessage) {
                    ISessionStore sessionStore = this.application.getSessionStore();
                    session = sessionStore.lookup((Request)this.webRequest);
                    ThreadContext.setSession((Session)session);
                } else {
                    session = oldSession;
                }
                if (session == null) {
                    this.connectionRegistry.removeConnection((Application)this.application, this.sessionId, connection.getKey());
                    LOG.debug("No Session could be found for session id '{}' and key '{}'!", (Object)this.sessionId, (Object)connection.getKey());
                    return;
                }
                IPageManager pageManager = session.getPageManager();
                Page page = this.getPage(pageManager);
                if (page != null) {
                    WebSocketRequestHandler requestHandler = this.webSocketSettings.newWebSocketRequestHandler(page, connection);
                    WebSocketPayload<?> payload = this.createEventPayload(message, requestHandler);
                    if (!(message instanceof ConnectedMessage) && !AbstractWebSocketProcessor.isSpecialMessage(message)) {
                        requestCycle.scheduleRequestHandlerAfterCurrent((IRequestHandler)requestHandler);
                    }
                    WebSocketMessageBroadcastHandler broadcastingHandler = new WebSocketMessageBroadcastHandler(this.pageId, this.resourceName, payload);
                    requestMapper.setHandler(broadcastingHandler);
                    requestCycle.processRequestAndDetach();
                }
                LOG.debug("Page with id '{}' has been expired. No message will be broadcast!", (Object)this.pageId);
            }
            catch (Exception x) {
                LOG.error("An error occurred during processing of a WebSocket message", (Throwable)x);
            }
            finally {
                try {
                    webResponse.close();
                }
                finally {
                    ThreadContext.setApplication((Application)oldApplication);
                    ThreadContext.setRequestCycle((RequestCycle)oldRequestCycle);
                    ThreadContext.setSession((Session)oldSession);
                }
            }
        } else {
            LOG.debug("Either there is no connection({}) or it is closed.", (Object)connection);
        }
    }

    private static boolean isSpecialMessage(IWebSocketMessage message) {
        return message instanceof ClosedMessage || message instanceof ErrorMessage || message instanceof AbortedMessage;
    }

    private RequestCycle createRequestCycle(WebSocketRequestMapper requestMapper, WebResponse webResponse) {
        RequestCycleContext context = new RequestCycleContext((Request)this.webRequest, (Response)webResponse, (IRequestMapper)requestMapper, (IExceptionMapper)this.application.getExceptionMapperProvider().get());
        RequestCycle requestCycle = (RequestCycle)this.application.getRequestCycleProvider().apply((Object)context);
        requestCycle.getListeners().add((Object)this.application.getRequestCycleListeners());
        requestCycle.getListeners().add((Object)new IRequestCycleListener(){

            public void onDetach(RequestCycle requestCycle) {
                if (Session.exists()) {
                    Session.get().getPageManager().detach();
                }
            }
        });
        requestCycle.getUrlRenderer().setBaseUrl(this.baseUrl);
        return requestCycle;
    }

    private Page getPage(IPageManager pageManager) {
        WebSocketResourcePage page = this.pageId != -1 ? (Page)pageManager.getPage(this.pageId) : new WebSocketResourcePage();
        return page;
    }

    protected final WebApplication getApplication() {
        return this.application;
    }

    protected final String getSessionId() {
        return this.sessionId;
    }

    private WebSocketPayload<?> createEventPayload(IWebSocketMessage message, WebSocketRequestHandler handler) {
        WebSocketPayload payload;
        if (message instanceof TextMessage) {
            payload = new WebSocketTextPayload((TextMessage)message, handler);
        } else if (message instanceof BinaryMessage) {
            payload = new WebSocketBinaryPayload((BinaryMessage)message, handler);
        } else if (message instanceof ConnectedMessage) {
            payload = new WebSocketConnectedPayload((ConnectedMessage)message, handler);
        } else if (message instanceof ClosedMessage) {
            payload = new WebSocketClosedPayload((ClosedMessage)message, handler);
        } else if (message instanceof ErrorMessage) {
            payload = new WebSocketErrorPayload((ErrorMessage)message, handler);
        } else if (message instanceof AbortedMessage) {
            payload = new WebSocketAbortedPayload((AbortedMessage)message, handler);
        } else if (message instanceof IWebSocketPushMessage) {
            payload = new WebSocketPushPayload((IWebSocketPushMessage)message, handler);
        } else {
            throw new IllegalArgumentException("Unsupported message type: " + message.getClass().getName());
        }
        return payload;
    }

    protected IKey getRegistryKey() {
        AbstractKey key = Strings.isEmpty((CharSequence)this.resourceName) ? new PageIdKey(this.pageId, this.context) : (Strings.isEmpty((CharSequence)this.connectionToken) ? new ResourceNameKey(this.resourceName, this.context) : new ResourceNameTokenKey(this.resourceName, this.connectionToken, this.context));
        return key;
    }

    private static class WebSocketResourcePage
    extends WebPage
    implements IMarkupResourceStreamProvider {
        private WebSocketResourcePage() {
            this.setStatelessHint(true);
        }

        public IResourceStream getMarkupResourceStream(MarkupContainer container, Class<?> containerClass) {
            return new StringResourceStream((CharSequence)"");
        }
    }
}

