/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import org.apache.wicket.Application;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.api.registry.IKey;
import org.apache.wicket.util.lang.Args;

public abstract class AbstractWebSocketConnection
implements IWebSocketConnection {
    private final String applicationName;
    private final String sessionId;
    private final IKey key;
    private final AbstractWebSocketProcessor webSocketProcessor;

    public AbstractWebSocketConnection(AbstractWebSocketProcessor webSocketProcessor) {
        this.applicationName = webSocketProcessor.getApplication().getName();
        this.sessionId = webSocketProcessor.getSessionId();
        this.key = webSocketProcessor.getRegistryKey();
        this.webSocketProcessor = (AbstractWebSocketProcessor)Args.notNull((Object)webSocketProcessor, (String)"webSocketProcessor");
    }

    @Override
    public void sendMessage(IWebSocketPushMessage message) {
        this.webSocketProcessor.broadcastMessage(message, this);
    }

    @Override
    public Application getApplication() {
        return Application.get((String)this.applicationName);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public IKey getKey() {
        return this.key;
    }
}

