/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.util;

import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;

public class SingleSortState<T>
implements ISortState<T>,
IClusterable {
    private static final long serialVersionUID = 1L;
    SortParam<T> param;

    @Override
    public void setPropertySortOrder(T property, SortOrder order) {
        Args.notNull(property, (String)"property");
        Args.notNull((Object)((Object)order), (String)"order");
        if (order == SortOrder.NONE) {
            if (this.param != null && property.equals(this.param.getProperty())) {
                this.param = null;
            }
        } else {
            this.param = new SortParam<T>(property, order == SortOrder.ASCENDING);
        }
    }

    @Override
    public SortOrder getPropertySortOrder(T property) {
        Args.notNull(property, (String)"property");
        if (this.param == null || !this.param.getProperty().equals(property)) {
            return SortOrder.NONE;
        }
        return this.param.isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING;
    }

    public SortParam<T> getSort() {
        return this.param;
    }

    public void setSort(SortParam<T> param) {
        this.param = param;
    }

    public String toString() {
        return "[SingleSortState sort=" + (this.param == null ? "null" : this.param.toString()) + "]";
    }
}

