/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.net.URLConnection;
import java.time.Instant;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.IResource;

public abstract class BaseDataResource<T>
extends AbstractResource {
    private static final long serialVersionUID = 1L;
    private final String contentType;
    private T data;
    private final Instant lastModified = Instant.now();
    private final String filename;

    public BaseDataResource(String contentType) {
        this(contentType, null, null);
    }

    public BaseDataResource(String contentType, T data) {
        this(contentType, data, null);
    }

    public BaseDataResource(String contentType, T data, String filename) {
        this.contentType = contentType;
        this.data = data;
        this.filename = filename;
    }

    protected void configureResponse(AbstractResource.ResourceResponse response, IResource.Attributes attributes) {
    }

    @Override
    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        String contentType = this.contentType;
        String filename = this.getFilename();
        if (contentType == null) {
            if (filename != null) {
                contentType = URLConnection.getFileNameMap().getContentTypeFor(filename);
            }
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
        }
        response.setContentType(contentType);
        response.setLastModified(this.lastModified);
        final T data = this.getData(attributes);
        if (data == null) {
            response.setError(404);
        } else {
            Long length = this.getLength(data);
            if (length != null) {
                response.setContentLength(length);
            }
            if (response.dataNeedsToBeWritten(attributes)) {
                if (filename != null) {
                    response.setFileName(filename);
                    response.setContentDisposition(ContentDisposition.ATTACHMENT);
                } else {
                    response.setContentDisposition(ContentDisposition.INLINE);
                }
                response.setWriteCallback(new AbstractResource.WriteCallback(){

                    @Override
                    public void writeData(IResource.Attributes attributes) {
                        BaseDataResource.this.writeData(attributes.getResponse(), data);
                    }
                });
                this.configureResponse(response, attributes);
            }
        }
        return response;
    }

    protected abstract void writeData(Response var1, T var2);

    protected abstract Long getLength(T var1);

    protected T getData(IResource.Attributes attributes) {
        return this.data;
    }

    protected String getFilename() {
        return this.filename;
    }
}

