/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.PageHeaderItem;
import org.apache.wicket.markup.head.internal.HeaderResponse;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.renderStrategy.AbstractHeaderRenderStrategy;
import org.apache.wicket.request.Response;
import org.apache.wicket.response.StringResponse;

public class HtmlHeaderContainer
extends TransparentWebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private transient Map<String, List<String>> renderedComponentsPerScope;
    private transient IHeaderResponse headerResponse = null;

    public HtmlHeaderContainer(String id) {
        super(id);
        this.setRenderBodyOnly(true);
        this.setAuto(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        Response webResponse = this.getResponse();
        try {
            StringResponse response = new StringResponse();
            this.getRequestCycle().setResponse(response);
            try (IHeaderResponse headerResponse = this.getHeaderResponse();){
                if (!((Object)((Object)response)).equals(headerResponse.getResponse())) {
                    this.getRequestCycle().setResponse(headerResponse.getResponse());
                }
                AbstractHeaderRenderStrategy.get().renderHeader(this, new HeaderStreamState(markupStream, openTag), this.getPage());
            }
            CharSequence output = HtmlHeaderContainer.getCleanResponse(response);
            if (output.length() > 0) {
                if (this.renderOpenAndCloseTags()) {
                    webResponse.write((CharSequence)"<head>");
                }
                webResponse.write(output);
                if (this.renderOpenAndCloseTags()) {
                    webResponse.write((CharSequence)"</head>");
                }
            }
        }
        finally {
            this.getRequestCycle().setResponse(webResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderHeaderTagBody(HeaderStreamState headerStreamState) {
        if (headerStreamState == null) {
            return;
        }
        Response oldResponse = this.getRequestCycle().getResponse();
        try {
            StringResponse bodyResponse = new StringResponse();
            this.getRequestCycle().setResponse(bodyResponse);
            super.onComponentTagBody(headerStreamState.getMarkupStream(), headerStreamState.getOpenTag());
            CharSequence bodyOutput = HtmlHeaderContainer.getCleanResponse(bodyResponse);
            if (bodyOutput.length() > 0) {
                this.getHeaderResponse().render(new PageHeaderItem(bodyOutput));
            }
        }
        finally {
            this.getRequestCycle().setResponse(oldResponse);
        }
    }

    private static CharSequence getCleanResponse(StringResponse response) {
        CharSequence output;
        block2: {
            block3: {
                output = response.getBuffer();
                if (output.length() <= 0) break block2;
                if (output.charAt(0) != '\r') break block3;
                for (int i = 2; i < output.length(); i += 2) {
                    char ch = output.charAt(i);
                    if (ch == '\r') continue;
                    output = output.subSequence(i - 2, output.length());
                    break block2;
                }
                break block2;
            }
            if (output.charAt(0) != '\n') break block2;
            for (int i = 1; i < output.length(); ++i) {
                char ch = output.charAt(i);
                if (ch == '\n') continue;
                output = output.subSequence(i - 1, output.length());
                break;
            }
        }
        return output;
    }

    protected boolean renderOpenAndCloseTags() {
        return true;
    }

    public boolean okToRenderComponent(String scope, String id) {
        List<String> componentScope;
        if (this.renderedComponentsPerScope == null) {
            this.renderedComponentsPerScope = new HashMap<String, List<String>>();
        }
        if ((componentScope = this.renderedComponentsPerScope.get(scope)) == null) {
            componentScope = new ArrayList<String>();
            this.renderedComponentsPerScope.put(scope, componentScope);
        }
        if (componentScope.contains(id)) {
            return false;
        }
        componentScope.add(id);
        return true;
    }

    @Override
    protected void onAfterRender() {
        super.onAfterRender();
        this.renderedComponentsPerScope = null;
        this.headerResponse = null;
    }

    protected IHeaderResponse newHeaderResponse() {
        return new HeaderResponse(){

            @Override
            protected Response getRealResponse() {
                return HtmlHeaderContainer.this.getResponse();
            }
        };
    }

    public IHeaderResponse getHeaderResponse() {
        if (this.headerResponse == null) {
            this.headerResponse = this.getApplication().decorateHeaderResponse(this.newHeaderResponse());
        }
        return this.headerResponse;
    }

    @Override
    public IMarkupFragment getMarkup() {
        if (this.getParent() == null) {
            throw new WicketRuntimeException("Bug: The Wicket internal instance of HtmlHeaderContainer is not connected to a parent");
        }
        IMarkupFragment markup = this.getPage().getMarkup();
        if (markup == null) {
            throw new MarkupException("Unable to get page markup: " + this.getPage().toString());
        }
        MarkupStream stream = new MarkupStream(markup);
        IMarkupFragment headerMarkup = null;
        while (stream.skipUntil(ComponentTag.class)) {
            ComponentTag tag = stream.getTag();
            if (tag.isOpen() || tag.isOpenClose()) {
                if (tag instanceof WicketTag) {
                    WicketTag wtag = (WicketTag)tag;
                    if (wtag.isHeadTag() || wtag.isHeaderItemsTag()) {
                        headerMarkup = stream.getMarkupFragment();
                        break;
                    }
                } else if (tag.getName().equalsIgnoreCase("head") && tag.isAutoComponentTag()) {
                    headerMarkup = stream.getMarkupFragment();
                    break;
                }
            }
            stream.next();
        }
        this.setMarkup(headerMarkup);
        return headerMarkup;
    }

    public static class HeaderStreamState {
        private final MarkupStream markupStream;
        private final ComponentTag openTag;

        private HeaderStreamState(MarkupStream markupStream, ComponentTag openTag) {
            this.markupStream = markupStream;
            this.openTag = openTag;
        }

        public MarkupStream getMarkupStream() {
            return this.markupStream;
        }

        public ComponentTag getOpenTag() {
            return this.openTag;
        }
    }
}

