/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.media;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class MediaComponent
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private boolean autoplay;
    private boolean loop;
    private boolean muted;
    private boolean controls = true;
    private Preload preload;
    private String startTime;
    private String endTime;
    private String mediaGroup;
    private Cors crossOrigin;
    private String type;
    private PageParameters pageParameters;
    private final ResourceReference resourceReference;
    private final String url;

    public MediaComponent(String id) {
        this(id, null, null, null, null);
    }

    public MediaComponent(String id, IModel<?> model) {
        this(id, model, null, null, null);
    }

    public MediaComponent(String id, ResourceReference resourceReference) {
        this(id, null, null, null, resourceReference);
    }

    public MediaComponent(String id, IModel<?> model, ResourceReference resourceReference) {
        this(id, model, null, null, resourceReference);
    }

    public MediaComponent(String id, ResourceReference resourceReference, PageParameters pageParameters) {
        this(id, null, null, pageParameters, resourceReference);
    }

    public MediaComponent(String id, IModel<?> model, ResourceReference resourceReference, PageParameters pageParameters) {
        this(id, model, null, pageParameters, resourceReference);
    }

    public MediaComponent(String id, String url) {
        this(id, null, url, null, null);
    }

    public MediaComponent(String id, IModel<?> model, String url) {
        this(id, model, url, null, null);
    }

    public MediaComponent(String id, IModel<?> model, String url, PageParameters pageParameters) {
        this(id, model, url, pageParameters, null);
    }

    private MediaComponent(String id, IModel<?> model, String url, PageParameters pageParameters, ResourceReference resourceReference) {
        super(id, model);
        this.url = url;
        this.pageParameters = pageParameters;
        this.resourceReference = resourceReference;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        String type;
        Cors cors;
        Preload _preload;
        super.onComponentTag(tag);
        Object timeManagement = "";
        if (this.startTime != null) {
            timeManagement = (String)timeManagement + "#t=" + this.startTime + (String)(this.endTime != null ? "," + this.endTime : "");
        }
        if (this.resourceReference != null) {
            CharSequence urlToMediaReference = RequestCycle.get().urlFor(this.resourceReference, this.pageParameters);
            tag.put("src", urlToMediaReference + (String)timeManagement);
        } else if (this.url != null) {
            Url encoded = new PageParametersEncoder().encodePageParameters(this.pageParameters);
            String queryString = encoded.getQueryString();
            tag.put("src", this.url + (String)(queryString != null ? "?" + queryString : "") + (String)timeManagement);
        }
        String mg = this.getMediaGroup();
        if (mg != null) {
            tag.put("mediagroup", mg);
        }
        if (this.isAutoplay()) {
            tag.put("autoplay", "autoplay");
        }
        if (this.isLooping()) {
            tag.put("loop", "loop");
        }
        if (this.isMuted()) {
            tag.put("muted", "muted");
        }
        if (this.hasControls()) {
            tag.put("controls", "controls");
        }
        if ((_preload = this.getPreload()) != null) {
            tag.put("preload", _preload.getRealName());
        }
        if ((cors = this.getCrossOrigin()) != null) {
            tag.put("crossorigin", cors.getRealName());
        }
        if ((type = this.getType()) != null) {
            tag.put("type", type);
        }
    }

    public boolean isAutoplay() {
        return this.autoplay;
    }

    public void setAutoplay(boolean autoplay) {
        this.autoplay = autoplay;
    }

    public boolean isLooping() {
        return this.loop;
    }

    public void setLooping(boolean loop) {
        this.loop = loop;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public void setPageParameters(PageParameters pageParameters) {
        this.pageParameters = pageParameters;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    public boolean hasControls() {
        return this.controls;
    }

    public void setControls(Boolean controls) {
        this.controls = controls;
    }

    public Preload getPreload() {
        return this.preload;
    }

    public void setPreload(Preload preload) {
        this.preload = preload;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getMediaGroup() {
        return this.mediaGroup;
    }

    public void setMediaGroup(String mediaGroup) {
        this.mediaGroup = mediaGroup;
    }

    public Cors getCrossOrigin() {
        return this.crossOrigin;
    }

    public void setCrossOrigin(Cors crossOrigin) {
        this.crossOrigin = crossOrigin;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static enum Preload {
        NONE("none"),
        METADATA("metadata"),
        AUTO("auto");

        private final String realName;

        private Preload(String realname) {
            this.realName = realname;
        }

        public String getRealName() {
            return this.realName;
        }
    }

    public static enum Cors {
        ANONYMOUS("anonymous"),
        USER_CREDENTIALS("user-credentials"),
        NO_CORS("");

        private final String realName;

        private Cors(String realName) {
            this.realName = realName;
        }

        public String getRealName() {
            return this.realName;
        }
    }
}

