/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.http.IResourceIsolationPolicy;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginResourceIsolationPolicy
implements IResourceIsolationPolicy {
    private static final Logger log = LoggerFactory.getLogger(OriginResourceIsolationPolicy.class);
    private Collection<String> acceptedOrigins = new ArrayList<String>();

    public OriginResourceIsolationPolicy addAcceptedOrigin(String acceptedOrigin) {
        int i;
        Checks.notNull("acceptedOrigin", acceptedOrigin, new Object[0]);
        int len = acceptedOrigin.length();
        for (i = 0; i < len && acceptedOrigin.charAt(i) == '.'; ++i) {
        }
        this.acceptedOrigins.add(acceptedOrigin.substring(i));
        return this;
    }

    @Override
    public IResourceIsolationPolicy.ResourceIsolationOutcome isRequestAllowed(HttpServletRequest request, IRequestablePage targetPage) {
        String sourceUri = this.getSourceUri(request);
        if (sourceUri == null || sourceUri.isEmpty()) {
            log.debug("Source URI not present in request to {}", (Object)request.getPathInfo());
            return IResourceIsolationPolicy.ResourceIsolationOutcome.UNKNOWN;
        }
        if (this.isWhitelistedHost(sourceUri = sourceUri.toLowerCase(Locale.ROOT))) {
            return IResourceIsolationPolicy.ResourceIsolationOutcome.ALLOWED;
        }
        if (!this.isLocalOrigin(request, sourceUri)) {
            log.debug("Source URI conflicts with request origin");
            return IResourceIsolationPolicy.ResourceIsolationOutcome.DISALLOWED;
        }
        return IResourceIsolationPolicy.ResourceIsolationOutcome.ALLOWED;
    }

    protected boolean isLocalOrigin(HttpServletRequest containerRequest, String originHeader) {
        String origin = this.normalizeUri(originHeader);
        if (origin == null) {
            return false;
        }
        String request = this.getTargetUriFromRequest(containerRequest);
        if (request == null) {
            return false;
        }
        return origin.equalsIgnoreCase(request);
    }

    protected final String getTargetUriFromRequest(HttpServletRequest request) {
        StringBuilder target = new StringBuilder();
        String scheme = request.getScheme();
        if (scheme == null) {
            return null;
        }
        scheme = scheme.toLowerCase(Locale.ROOT);
        target.append(scheme);
        target.append("://");
        String host = request.getServerName();
        if (host == null) {
            return null;
        }
        target.append(host);
        int port = request.getServerPort();
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            target.append(':');
            target.append(port);
        }
        return target.toString();
    }

    private String getSourceUri(HttpServletRequest containerRequest) {
        String sourceUri = containerRequest.getHeader("Origin");
        if (Strings.isEmpty(sourceUri)) {
            sourceUri = containerRequest.getHeader("Referer");
        }
        return this.normalizeUri(sourceUri);
    }

    protected final String normalizeUri(String uri) {
        if (Strings.isEmpty(uri) || "null".equals(uri)) {
            return null;
        }
        StringBuilder target = new StringBuilder();
        try {
            boolean isAlternateHttpsPort;
            URI originUri = new URI(uri);
            String scheme = originUri.getScheme();
            if (scheme == null) {
                return null;
            }
            scheme = scheme.toLowerCase(Locale.ROOT);
            target.append(scheme);
            target.append("://");
            String host = originUri.getHost();
            if (host == null) {
                return null;
            }
            target.append(host);
            int port = originUri.getPort();
            boolean portIsSpecified = port != -1;
            boolean isAlternateHttpPort = "http".equals(scheme) && port != 80;
            boolean bl = isAlternateHttpsPort = "https".equals(scheme) && port != 443;
            if (portIsSpecified && (isAlternateHttpPort || isAlternateHttpsPort)) {
                target.append(':');
                target.append(port);
            }
            return target.toString();
        }
        catch (URISyntaxException e) {
            log.debug("Invalid URI provided: {}, marked conflicting", (Object)uri);
            return null;
        }
    }

    protected boolean isWhitelistedHost(String sourceUri) {
        try {
            String sourceHost = new URI(sourceUri).getHost();
            if (Strings.isEmpty(sourceHost)) {
                return false;
            }
            for (String whitelistedOrigin : this.acceptedOrigins) {
                if (!sourceHost.equalsIgnoreCase(whitelistedOrigin) && !sourceHost.endsWith("." + whitelistedOrigin)) continue;
                log.trace("Origin {} matched whitelisted origin {}, request accepted", (Object)sourceUri, (Object)whitelistedOrigin);
                return true;
            }
        }
        catch (URISyntaxException e) {
            log.debug("Origin: {} not parseable as an URI. Whitelisted-origin check skipped.", (Object)sourceUri);
        }
        return false;
    }
}

