/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser;

import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.WicketParseException;
import org.apache.wicket.markup.parser.filter.HtmlHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagStack {
    private static final Logger log = LoggerFactory.getLogger(HtmlHandler.class);
    private static final Map<String, Boolean> doesNotRequireCloseTag = new HashMap<String, Boolean>();
    private final ArrayDeque<ComponentTag> stack = new ArrayDeque();
    private boolean debug;

    public void assertValidInStack(ComponentTag tag) throws ParseException {
        if (tag == null) {
            this.validate();
            return;
        }
        if (log.isDebugEnabled() && this.debug) {
            log.debug("tag: " + tag.toUserDebugString() + ", stack: " + this.stack);
        }
        if (tag.isOpen()) {
            this.stack.push(tag);
        } else if (tag.isClose()) {
            this.assertOpenTagFor(tag);
        } else if (tag.isOpenClose()) {
            tag.setOpenTag(tag);
        }
    }

    private void assertOpenTagFor(ComponentTag closeTag) throws ParseException {
        ComponentTag top;
        if (this.stack.size() > 0) {
            boolean mismatch;
            top = this.stack.pop();
            boolean bl = mismatch = !TagStack.hasEqualTagName(top, closeTag);
            if (mismatch) {
                top.setHasNoCloseTag(true);
                while (mismatch && !TagStack.requiresCloseTag(top.getName())) {
                    top.setHasNoCloseTag(true);
                    if (this.stack.isEmpty()) break;
                    top = this.stack.pop();
                    mismatch = !TagStack.hasEqualTagName(top, closeTag);
                }
                if (mismatch) {
                    throw new ParseException("Tag " + top.toUserDebugString() + " has a mismatched close tag at " + closeTag.toUserDebugString(), top.getPos());
                }
            }
        } else {
            throw new WicketParseException("Tag does not have a matching open tag:", closeTag);
        }
        closeTag.setOpenTag(top);
    }

    private void validate() throws WicketParseException {
        ComponentTag top = this.getNotClosedTag();
        if (top != null) {
            throw new WicketParseException("Tag does not have a close tag:", top);
        }
    }

    public ComponentTag getNotClosedTag() {
        if (this.stack.size() > 0) {
            Iterator<ComponentTag> it = this.stack.descendingIterator();
            while (it.hasNext()) {
                ComponentTag tag = it.next();
                if (!TagStack.requiresCloseTag(tag.getName())) {
                    it.remove();
                    continue;
                }
                return tag;
            }
        }
        return null;
    }

    public void debug() {
        this.debug = true;
    }

    public static boolean requiresCloseTag(String name) {
        return doesNotRequireCloseTag.get(name.toLowerCase(Locale.ROOT)) == null;
    }

    public static boolean hasEqualTagName(ComponentTag tag1, ComponentTag tag2) {
        if (!tag1.getName().equalsIgnoreCase(tag2.getName())) {
            return false;
        }
        if (tag1.getNamespace() == null && tag2.getNamespace() == null) {
            return true;
        }
        if (tag1.getNamespace() != null && tag2.getNamespace() != null) {
            return tag1.getNamespace().equalsIgnoreCase(tag2.getNamespace());
        }
        return false;
    }

    static {
        doesNotRequireCloseTag.put("p", Boolean.TRUE);
        doesNotRequireCloseTag.put("br", Boolean.TRUE);
        doesNotRequireCloseTag.put("img", Boolean.TRUE);
        doesNotRequireCloseTag.put("input", Boolean.TRUE);
        doesNotRequireCloseTag.put("hr", Boolean.TRUE);
        doesNotRequireCloseTag.put("link", Boolean.TRUE);
        doesNotRequireCloseTag.put("meta", Boolean.TRUE);
    }
}

