/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.wicket.request.mapper.parameter.IIndexedParameters;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;

public class PageParameters
implements IClusterable,
IIndexedParameters,
INamedParameters {
    private static final long serialVersionUID = 1L;
    private List<String> indexedParameters;
    private List<INamedParameters.NamedPair> namedParameters;
    private Locale locale = Locale.getDefault(Locale.Category.DISPLAY);

    public PageParameters() {
    }

    public PageParameters(PageParameters copy) {
        if (copy != null) {
            this.mergeWith(copy);
            this.setLocale(copy.locale);
        }
    }

    public int getIndexedCount() {
        return this.indexedParameters != null ? this.indexedParameters.size() : 0;
    }

    @Override
    public PageParameters set(int index, Object object) {
        if (this.indexedParameters == null) {
            this.indexedParameters = new ArrayList<String>(index);
        }
        for (int i = this.indexedParameters.size(); i <= index; ++i) {
            this.indexedParameters.add(null);
        }
        this.indexedParameters.set(index, Strings.toString(object));
        return this;
    }

    @Override
    public StringValue get(int index) {
        if (this.indexedParameters != null && index >= 0 && index < this.indexedParameters.size()) {
            return StringValue.valueOf(this.indexedParameters.get(index), this.locale);
        }
        return StringValue.valueOf((String)null);
    }

    @Override
    public PageParameters remove(int index) {
        if (this.indexedParameters != null && index >= 0 && index < this.indexedParameters.size()) {
            this.indexedParameters.remove(index);
        }
        return this;
    }

    @Override
    public Set<String> getNamedKeys() {
        if (this.namedParameters == null || this.namedParameters.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<String> set = new TreeSet<String>();
        for (INamedParameters.NamedPair entry : this.namedParameters) {
            set.add(entry.getKey());
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public StringValue get(String name) {
        Args.notNull(name, "name");
        if (this.namedParameters != null) {
            for (INamedParameters.NamedPair entry : this.namedParameters) {
                if (!entry.getKey().equals(name)) continue;
                return StringValue.valueOf(entry.getValue(), this.locale);
            }
        }
        return StringValue.valueOf((String)null);
    }

    @Override
    public List<StringValue> getValues(String name) {
        Args.notNull(name, "name");
        if (this.namedParameters != null) {
            ArrayList<StringValue> result = new ArrayList<StringValue>();
            for (INamedParameters.NamedPair entry : this.namedParameters) {
                if (!entry.getKey().equals(name)) continue;
                result.add(StringValue.valueOf(entry.getValue(), this.locale));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    @Override
    public List<INamedParameters.NamedPair> getAllNamed() {
        return this.namedParameters != null ? Collections.unmodifiableList(this.namedParameters) : Collections.emptyList();
    }

    @Override
    public List<INamedParameters.NamedPair> getAllNamedByType(INamedParameters.Type type) {
        List<INamedParameters.NamedPair> allNamed = this.getAllNamed();
        if (type == null || allNamed.isEmpty()) {
            return allNamed;
        }
        ArrayList<INamedParameters.NamedPair> parametersByType = new ArrayList<INamedParameters.NamedPair>();
        for (INamedParameters.NamedPair pair : allNamed) {
            if (type != pair.getType()) continue;
            parametersByType.add(pair);
        }
        return Collections.unmodifiableList(parametersByType);
    }

    @Override
    public int getPosition(String name) {
        int index = -1;
        if (this.namedParameters != null) {
            for (int i = 0; i < this.namedParameters.size(); ++i) {
                INamedParameters.NamedPair entry = this.namedParameters.get(i);
                if (!entry.getKey().equals(name)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    @Override
    public PageParameters remove(String name, String ... values) {
        Args.notNull(name, "name");
        if (this.namedParameters != null) {
            Iterator<INamedParameters.NamedPair> i = this.namedParameters.iterator();
            block0: while (i.hasNext()) {
                INamedParameters.NamedPair e = i.next();
                if (!e.getKey().equals(name)) continue;
                if (values != null && values.length > 0) {
                    for (String value : values) {
                        if (!e.getValue().equals(value)) continue;
                        i.remove();
                        continue block0;
                    }
                    continue;
                }
                i.remove();
            }
        }
        return this;
    }

    public PageParameters add(String name, Object value) {
        return this.add(name, value, INamedParameters.Type.MANUAL);
    }

    @Override
    public PageParameters add(String name, Object value, INamedParameters.Type type) {
        return this.add(name, value, -1, type);
    }

    @Override
    public PageParameters add(String name, Object value, int index, INamedParameters.Type type) {
        Args.notEmpty(name, "name");
        Args.notNull(value, "value");
        if (value instanceof String[]) {
            this.addNamed(name, (String[])value, index, type);
        } else {
            this.addNamed(name, value.toString(), index, type);
        }
        return this;
    }

    private void addNamed(String name, String[] values, int index, INamedParameters.Type type) {
        if (this.namedParameters == null && values.length > 0) {
            this.namedParameters = new ArrayList<INamedParameters.NamedPair>(values.length);
        }
        for (String val : values) {
            this.addNamed(name, val, index, type);
        }
    }

    private void addNamed(String name, String value, int index, INamedParameters.Type type) {
        if (this.namedParameters == null) {
            this.namedParameters = new ArrayList<INamedParameters.NamedPair>(1);
        }
        INamedParameters.NamedPair entry = new INamedParameters.NamedPair(name, value, type);
        if (index < 0 || index > this.namedParameters.size()) {
            this.namedParameters.add(entry);
        } else {
            this.namedParameters.add(index, entry);
        }
    }

    public PageParameters set(String name, Object value, int index) {
        return this.set(name, value, index, INamedParameters.Type.MANUAL);
    }

    @Override
    public PageParameters set(String name, Object value, int index, INamedParameters.Type type) {
        this.remove(name, new String[0]);
        if (value != null) {
            this.add(name, value, index, type);
        }
        return this;
    }

    public PageParameters set(String name, Object value) {
        return this.set(name, value, INamedParameters.Type.MANUAL);
    }

    @Override
    public PageParameters set(String name, Object value, INamedParameters.Type type) {
        int position = this.getPosition(name);
        this.set(name, value, position, type);
        return this;
    }

    @Override
    public PageParameters clearIndexed() {
        this.indexedParameters = null;
        return this;
    }

    @Override
    public PageParameters clearNamed() {
        this.namedParameters = null;
        return this;
    }

    public PageParameters overwriteWith(PageParameters other) {
        if (this != other) {
            this.indexedParameters = other.indexedParameters;
            this.namedParameters = other.namedParameters;
            this.locale = other.locale;
        }
        return this;
    }

    public PageParameters mergeWith(PageParameters other) {
        if (other != null && this != other) {
            this.mergeIndexed(other);
            this.mergeNamed(other);
        }
        return this;
    }

    private void mergeIndexed(PageParameters other) {
        int otherIndexedCount = other.getIndexedCount();
        for (int index = 0; index < otherIndexedCount; ++index) {
            StringValue value = other.get(index);
            if (value.isNull()) continue;
            this.set(index, (Object)value);
        }
    }

    private void mergeNamed(PageParameters other) {
        List<INamedParameters.NamedPair> otherNamed = other.namedParameters;
        if (otherNamed == null || otherNamed.isEmpty()) {
            return;
        }
        for (INamedParameters.NamedPair curNamed : otherNamed) {
            this.remove(curNamed.getKey(), new String[0]);
        }
        if (this.namedParameters == null) {
            this.namedParameters = new ArrayList<INamedParameters.NamedPair>(otherNamed.size());
        }
        for (INamedParameters.NamedPair curNamed : otherNamed) {
            this.add(curNamed.getKey(), curNamed.getValue(), curNamed.getType());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.indexedParameters == null ? 0 : this.indexedParameters.hashCode());
        result = 31 * result + (this.namedParameters == null ? 0 : this.namedParameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageParameters other = (PageParameters)obj;
        if (this.indexedParameters == null ? other.indexedParameters != null : !this.indexedParameters.equals(other.indexedParameters)) {
            return false;
        }
        if (this.namedParameters == null) {
            if (other.namedParameters != null) {
                return false;
            }
        } else {
            if (other.namedParameters == null) {
                return false;
            }
            if (!CollectionUtils.isEqualCollection(this.namedParameters, other.namedParameters)) {
                return false;
            }
        }
        return true;
    }

    public static boolean equals(PageParameters p1, PageParameters p2) {
        if (Objects.equal(p1, p2)) {
            return true;
        }
        if (p1 == null && p2.getIndexedCount() == 0 && p2.getNamedKeys().isEmpty()) {
            return true;
        }
        return p2 == null && p1.getIndexedCount() == 0 && p1.getNamedKeys().isEmpty();
    }

    public boolean isEmpty() {
        return this.getIndexedCount() == 0 && this.getNamedKeys().isEmpty();
    }

    public PageParameters setLocale(Locale locale) {
        this.locale = locale != null ? locale : Locale.getDefault(Locale.Category.DISPLAY);
        return this;
    }

    public String toString() {
        int i;
        StringBuilder str = new StringBuilder();
        if (this.indexedParameters != null) {
            for (i = 0; i < this.indexedParameters.size(); ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(i);
                str.append('=');
                str.append('[').append(this.indexedParameters.get(i)).append(']');
            }
        }
        if (str.length() > 0) {
            str.append(", ");
        }
        if (this.namedParameters != null) {
            for (i = 0; i < this.namedParameters.size(); ++i) {
                INamedParameters.NamedPair entry = this.namedParameters.get(i);
                if (i > 0) {
                    str.append(", ");
                }
                str.append(entry.getKey());
                str.append('=');
                str.append('[').append(entry.getValue()).append(']');
            }
        }
        return str.toString();
    }
}

