/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.coop;

import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.coop.CrossOriginOpenerPolicyConfiguration;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossOriginOpenerPolicyRequestCycleListener
implements IRequestCycleListener {
    private static final Logger log = LoggerFactory.getLogger(CrossOriginOpenerPolicyRequestCycleListener.class);
    static final String COOP_HEADER = "Cross-Origin-Opener-Policy";
    private CrossOriginOpenerPolicyConfiguration coopConfig;

    public CrossOriginOpenerPolicyRequestCycleListener(CrossOriginOpenerPolicyConfiguration coopConfig) {
        this.coopConfig = Args.notNull(coopConfig, "coopConfig");
    }

    @Override
    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        Object containerRequest = cycle.getRequest().getContainerRequest();
        if (containerRequest instanceof HttpServletRequest) {
            WebResponse webResponse;
            HttpServletRequest request = (HttpServletRequest)containerRequest;
            String path = request.getContextPath();
            if (this.coopConfig.getExemptions().contains(path)) {
                log.debug("Request path {} is exempted from COOP, no {} header added", (Object)path, (Object)COOP_HEADER);
                return;
            }
            if (cycle.getResponse() instanceof WebResponse && (webResponse = (WebResponse)cycle.getResponse()).isHeaderSupported()) {
                webResponse.setHeader(COOP_HEADER, this.coopConfig.getHeaderValue());
            }
        }
    }
}

