/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.string.Strings;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AjaxEventBehavior
extends AbstractDefaultAjaxBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(AjaxEventBehavior.class);
    private static final long serialVersionUID = 1L;
    private static final char EVENT_NAME_SEPARATOR = ' ';
    private final String event;

    public AjaxEventBehavior(String event) {
        Args.notEmpty(event, "event");
        if ("inputchange".equals(event)) {
            event = "input";
            LOGGER.warn("Since version 9.0.0 Wicket no longer supports 'inputchange' events, please use 'input' instead");
        }
        this.event = event;
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (component.isEnabledInHierarchy()) {
            CharSequence js = this.getCallbackScript(component);
            response.render(OnDomReadyHeaderItem.forScript(js.toString()));
        }
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        String evt = this.getEvent();
        Checks.notEmpty(evt, "getEvent() should return non-empty event name(s)", new Object[0]);
        attributes.setEventNames(evt);
    }

    public String getEvent() {
        if (this.event.indexOf(32) == -1) {
            return this.event;
        }
        String[] splitEvents = Strings.split(this.event, ' ');
        ArrayList<String> cleanedEvents = new ArrayList<String>(splitEvents.length);
        for (String evt : splitEvents) {
            if (Strings.isEmpty(evt = evt.trim())) continue;
            cleanedEvents.add(evt);
        }
        return Strings.join(" ", cleanedEvents);
    }

    @Override
    protected final void respond(AjaxRequestTarget target) {
        this.onEvent(target);
    }

    protected abstract void onEvent(AjaxRequestTarget var1);

    public static AjaxEventBehavior onEvent(String eventName, final SerializableConsumer<AjaxRequestTarget> onEvent) {
        Args.notNull(onEvent, "onEvent");
        return new AjaxEventBehavior(eventName){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                onEvent.accept(target);
            }
        };
    }
}

