/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import javax.enterprise.context.Conversation;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.application.IComponentOnBeforeRenderListener;
import org.apache.wicket.cdi.CdiContainer;
import org.apache.wicket.cdi.ConversationExpiredException;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.lang.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationExpiryChecker
implements IComponentOnBeforeRenderListener {
    private static final Logger logger = LoggerFactory.getLogger(ConversationExpiryChecker.class);
    @Inject
    private Conversation conversation;
    private final CdiContainer container;

    public ConversationExpiryChecker(CdiContainer container) {
        this.container = container;
        container.getNonContextualManager().inject(this);
    }

    public void onBeforeRender(Component component) {
        Page page;
        String cid;
        if ((component instanceof Page || RequestCycle.get().find(AjaxRequestTarget.class) != null) && (cid = this.container.getConversationMarker(page = component.getPage())) != null && !Objects.isEqual((Object)this.conversation.getId(), (Object)cid)) {
            logger.info("Conversation {} has expired for {}", (Object)cid, (Object)page);
            throw new ConversationExpiredException(null, cid, page, RequestCycle.get().getActiveRequestHandler());
        }
    }
}

