/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.cookies;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.cookies.CookieDefaults;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtils {
    private static final Logger log = LoggerFactory.getLogger(CookieUtils.class);
    public static final String DEFAULT_SESSIONID_COOKIE_NAME = "JSESSIONID";
    private final CookieDefaults settings;

    public CookieUtils() {
        this.settings = new CookieDefaults();
    }

    public CookieUtils(CookieDefaults settings) {
        this.settings = settings;
    }

    public final CookieDefaults getSettings() {
        return this.settings;
    }

    public final void remove(String key) {
        Cookie cookie = this.getCookie(key);
        if (cookie != null) {
            this.remove(cookie);
        }
    }

    public final void remove(FormComponent<?> formComponent) {
        this.remove(this.getKey(formComponent));
    }

    protected String getKey(FormComponent<?> component) {
        return this.getSaveKey(component.getPageRelativePath());
    }

    public final String load(String key) {
        Cookie cookie = this.getCookie(key);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public final String load(FormComponent<?> formComponent) {
        String value = this.load(this.getKey(formComponent));
        if (value != null) {
            formComponent.setModelValue(new String[]{value});
        }
        return value;
    }

    public final void save(String name, String value) {
        Cookie cookie = this.getCookie(name);
        if (cookie == null) {
            cookie = new Cookie(name, value);
        } else {
            cookie.setValue(value);
        }
        this.save(cookie);
    }

    public final void save(FormComponent<?> formComponent) {
        this.save(this.getKey(formComponent), formComponent.getValue());
    }

    protected String getSaveKey(String key) {
        if (Strings.isEmpty((String)key)) {
            throw new IllegalArgumentException("A Cookie name can not be null or empty");
        }
        key = Strings.replaceAll((CharSequence)key, (CharSequence)".", (CharSequence)"..").toString();
        key = key.replace(':', '.');
        return key;
    }

    private void remove(Cookie cookie) {
        if (cookie != null) {
            this.save(cookie);
            cookie.setMaxAge(0);
            cookie.setValue(null);
            if (log.isDebugEnabled()) {
                log.debug("Removed Cookie: " + cookie.getName());
            }
        }
    }

    public Cookie getCookie(String name) {
        try {
            WebRequest webRequest = this.getWebRequest();
            Cookie cookie = webRequest.getCookie(name);
            if (log.isDebugEnabled()) {
                if (cookie != null) {
                    log.debug("Found Cookie with name=" + name + " and request URI=" + webRequest.getUrl().toString());
                } else {
                    log.debug("Unable to find Cookie with name=" + name + " and request URI=" + webRequest.getUrl().toString());
                }
            }
            return cookie;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getSessionIdCookieName(WebApplication application) {
        String jsessionCookieName = application.getServletContext().getSessionCookieConfig().getName();
        return jsessionCookieName == null ? DEFAULT_SESSIONID_COOKIE_NAME : jsessionCookieName;
    }

    private Cookie save(Cookie cookie) {
        if (cookie == null) {
            return null;
        }
        this.initializeCookie(cookie);
        this.getWebResponse().addCookie(cookie);
        if (log.isDebugEnabled()) {
            log.debug("Cookie saved: " + this.cookieToDebugString(cookie) + "; request URI=" + this.getWebRequest().getUrl().toString());
        }
        return cookie;
    }

    protected void initializeCookie(Cookie cookie) {
        String domain;
        String comment = this.settings.getComment();
        if (comment != null) {
            cookie.setComment(comment);
        }
        if ((domain = this.settings.getDomain()) != null) {
            cookie.setDomain(domain);
        }
        ServletWebRequest request = (ServletWebRequest)this.getWebRequest();
        String path = request.getContainerRequest().getContextPath() + "/" + request.getFilterPrefix();
        if (this.settings.getSameSite() == CookieDefaults.SameSite.None) {
            this.settings.setSecure(true);
        }
        cookie.setPath(path);
        cookie.setVersion(this.settings.getVersion());
        cookie.setSecure(this.settings.getSecure());
        cookie.setMaxAge(this.settings.getMaxAge());
        cookie.setHttpOnly(this.settings.isHttpOnly());
        CookieUtils.setAttribute(cookie, "SameSite", this.settings.getSameSite().name());
    }

    public static void setAttribute(Cookie cookie, String attributeName, String attributeValue) {
        ServletContext servletContext;
        Args.notEmpty((String)attributeName, (String)"attributeName");
        if (WebApplication.exists() && (servletContext = WebApplication.get().getServletContext()).getEffectiveMajorVersion() >= 6) {
            cookie.setAttribute(attributeName, attributeValue);
        }
    }

    private WebRequest getWebRequest() {
        return (WebRequest)RequestCycle.get().getRequest();
    }

    private WebResponse getWebResponse() {
        RequestCycle cycle = RequestCycle.get();
        Response response = cycle.getResponse();
        if (!(response instanceof WebResponse)) {
            response = cycle.getOriginalResponse();
        }
        return (WebResponse)response;
    }

    private String cookieToDebugString(Cookie cookie) {
        LocalDateTime localDateTime = Instant.ofEpochMilli(cookie.getMaxAge()).atZone(ZoneId.systemDefault()).toLocalDateTime();
        return "[Cookie  name = " + cookie.getName() + ", value = " + cookie.getValue() + ", domain = " + cookie.getDomain() + ", path = " + cookie.getPath() + ", maxAge = " + localDateTime + "(" + cookie.getMaxAge() + ")]";
    }
}

