/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.response;

import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class StringResponse
extends Response {
    private static final int DEFAULT_INITIAL_CAPACITY = 128;
    private final int initialCapacity;
    private AppendingStringBuffer out;

    public StringResponse() {
        this(128);
    }

    public StringResponse(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    @Override
    public void write(CharSequence string) {
        if (this.out == null) {
            this.out = new AppendingStringBuffer(this.initialCapacity);
        }
        this.out.append(string);
    }

    @Override
    public void reset() {
        if (this.out != null) {
            this.out.clear();
        }
    }

    public String toString() {
        return this.getBuffer().toString();
    }

    public CharSequence getBuffer() {
        return this.out != null ? this.out : "";
    }

    @Override
    public void write(byte[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] array, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String encodeURL(CharSequence url) {
        return url != null ? url.toString() : null;
    }

    @Override
    public Object getContainerResponse() {
        return null;
    }
}

