/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.servlet.ResponseIOException;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.UrlRenderer;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;

public class ServletWebResponse
extends WebResponse {
    private final HttpServletResponse httpServletResponse;
    private final ServletWebRequest webRequest;
    private boolean redirect = false;

    public ServletWebResponse(ServletWebRequest webRequest, HttpServletResponse httpServletResponse) {
        Args.notNull(webRequest, "webRequest");
        Args.notNull(httpServletResponse, "httpServletResponse");
        this.httpServletResponse = httpServletResponse;
        this.webRequest = webRequest;
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.httpServletResponse.addCookie(cookie);
    }

    @Override
    public void clearCookie(Cookie cookie) {
        cookie.setMaxAge(0);
        cookie.setValue(null);
        this.addCookie(cookie);
    }

    @Override
    public void setContentLength(long length) {
        this.httpServletResponse.addHeader("Content-Length", Long.toString(length));
    }

    @Override
    public void setContentType(String mimeType) {
        this.httpServletResponse.setContentType(mimeType);
    }

    @Override
    public void setDateHeader(String name, Instant date) {
        Args.notNull(date, "date");
        this.httpServletResponse.setDateHeader(name, date.toEpochMilli());
    }

    @Override
    public boolean isHeaderSupported() {
        return !this.httpServletResponse.isCommitted();
    }

    @Override
    public void setHeader(String name, String value) {
        this.httpServletResponse.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.httpServletResponse.addHeader(name, value);
    }

    @Override
    public void write(CharSequence sequence) {
        try {
            this.httpServletResponse.getWriter().append(sequence);
        }
        catch (IOException e) {
            throw new ResponseIOException(e);
        }
    }

    @Override
    public void write(byte[] array) {
        try {
            this.httpServletResponse.getOutputStream().write(array);
        }
        catch (IOException e) {
            throw new ResponseIOException(e);
        }
    }

    @Override
    public void write(byte[] array, int offset, int length) {
        try {
            this.httpServletResponse.getOutputStream().write(array, offset, length);
        }
        catch (IOException e) {
            throw new ResponseIOException(e);
        }
    }

    @Override
    public void setStatus(int sc) {
        this.httpServletResponse.setStatus(sc);
    }

    @Override
    public void sendError(int sc, String msg) {
        try {
            if (msg == null) {
                this.httpServletResponse.sendError(sc);
            } else {
                this.httpServletResponse.sendError(sc, msg);
            }
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    @Override
    public String encodeURL(CharSequence url) {
        String encodedUrl;
        Args.notNull(url, "url");
        UrlRenderer urlRenderer = this.getUrlRenderer();
        Url originalUrl = Url.parse(url);
        String fullUrl = urlRenderer.renderFullUrl(originalUrl);
        String encodedFullUrl = this.httpServletResponse.encodeURL(fullUrl);
        if (originalUrl.isFull()) {
            encodedUrl = encodedFullUrl;
        } else if (fullUrl.equals(encodedFullUrl)) {
            encodedUrl = url.toString();
        } else {
            Url _encoded = Url.parse(encodedFullUrl);
            encodedUrl = urlRenderer.renderRelativeUrl(_encoded);
        }
        return encodedUrl;
    }

    private UrlRenderer getUrlRenderer() {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle == null) {
            return new UrlRenderer(this.webRequest);
        }
        return requestCycle.getUrlRenderer();
    }

    @Override
    public String encodeRedirectURL(CharSequence url) {
        String encodedUrl;
        Args.notNull(url, "url");
        UrlRenderer urlRenderer = this.getUrlRenderer();
        Url originalUrl = Url.parse(url);
        String fullUrl = urlRenderer.renderFullUrl(originalUrl);
        String encodedFullUrl = this.httpServletResponse.encodeRedirectURL(fullUrl);
        if (originalUrl.isFull()) {
            encodedUrl = encodedFullUrl;
        } else if (fullUrl.equals(encodedFullUrl)) {
            encodedUrl = url.toString();
        } else {
            Url _encoded = Url.parse(encodedFullUrl);
            encodedUrl = urlRenderer.renderRelativeUrl(_encoded);
        }
        return encodedUrl;
    }

    @Override
    public void sendRedirect(String url) {
        try {
            this.redirect = true;
            url = this.encodeRedirectURL(url);
            this.disableCaching();
            if (this.webRequest.isAjax()) {
                this.setHeader("Ajax-Location", url);
                this.setContentType("text/xml;charset=" + this.webRequest.getContainerRequest().getCharacterEncoding());
                this.httpServletResponse.getWriter().write("<ajax-response><redirect><![CDATA[" + url + "]]></redirect></ajax-response>");
            } else {
                this.httpServletResponse.sendRedirect(url);
            }
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    @Override
    public boolean isRedirect() {
        return this.redirect;
    }

    @Override
    public void flush() {
        try {
            HttpServletRequest httpServletRequest = this.webRequest.getContainerRequest();
            if (!httpServletRequest.isAsyncStarted()) {
                this.httpServletResponse.flushBuffer();
            }
        }
        catch (IOException e) {
            throw new ResponseIOException(e);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.httpServletResponse.reset();
        this.redirect = false;
    }

    @Override
    public HttpServletResponse getContainerResponse() {
        return this.httpServletResponse;
    }
}

