/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.mock;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.mock.MockRequestParameters;
import org.apache.wicket.protocol.http.mock.Cookies;
import org.apache.wicket.protocol.http.mock.MockHttpSession;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.encoding.UrlDecoder;
import org.apache.wicket.util.encoding.UrlEncoder;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;

public class MockHttpServletRequest
implements HttpServletRequest {
    private final ValueMap attributes = new ValueMap();
    private String authType;
    private String characterEncoding = "UTF-8";
    private final ServletContext context;
    private final Map<Cookies.Key, Cookie> cookies = new LinkedHashMap<Cookies.Key, Cookie>();
    private final ValueMap headers = new ValueMap();
    private String method;
    private final LinkedHashMap<String, String[]> parameters = new LinkedHashMap();
    private final LinkedHashMap<String, Part> parts = new LinkedHashMap();
    private String path;
    private final HttpSession session;
    private String url;
    private Map<String, List<UploadedFile>> uploadedFiles;
    private boolean useMultiPartContentType;
    private boolean secure = false;
    private String remoteAddr = "127.0.0.1";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 80;
    private static final String crlf = "\r\n";
    private static final String boundary = "--abcdefgABCDEFG";
    private final MockRequestParameters post = new MockRequestParameters();

    public MockHttpServletRequest(Application application, HttpSession session, ServletContext context, Locale locale) {
        this.session = session;
        this.context = context;
        this.initialize(locale);
    }

    public MockHttpServletRequest(Application application, HttpSession session, ServletContext context) {
        this(application, session, context, Locale.getDefault());
    }

    public void addCookie(Cookie cookie) {
        this.cookies.put(Cookies.keyOf(cookie), cookie);
    }

    public void addCookies(Iterable<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            this.addCookie(cookie);
        }
    }

    public void addFile(String fieldName, File file, String contentType) {
        if (file != null) {
            if (!file.exists()) {
                throw new IllegalArgumentException("File does not exists. You must provide an existing file: " + file.getAbsolutePath());
            }
            if (!file.isFile()) {
                throw new IllegalArgumentException("You can only add a File, which is not a directory. Only files can be uploaded.");
            }
        }
        if (this.uploadedFiles == null) {
            this.uploadedFiles = new HashMap<String, List<UploadedFile>>();
        }
        UploadedFile uf = new UploadedFile(fieldName, file, contentType);
        List<UploadedFile> filesPerField = this.uploadedFiles.get(fieldName);
        if (filesPerField == null) {
            filesPerField = new ArrayList<UploadedFile>();
            this.uploadedFiles.put(fieldName, filesPerField);
        }
        filesPerField.add(uf);
        this.setUseMultiPartContentType(true);
    }

    public void addHeader(String name, String value) {
        ArrayList<String> list = (ArrayList<String>)this.headers.get(name);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.headers.put(name, (Object)list);
        }
        list.add(value);
    }

    public void setHeader(String name, String value) {
        ArrayList<String> list = (ArrayList<String>)this.headers.get(name);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.headers.put(name, (Object)list);
        }
        list.clear();
        list.add(value);
    }

    public void addDateHeader(String name, long date) {
        DateFormat df = DateFormat.getDateInstance(0);
        String dateString = df.format(new Date(date));
        this.addHeader(name, dateString);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    @Override
    public String getAuthType() {
        return this.authType;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public Charset getCharset() {
        return Charset.forName(this.characterEncoding);
    }

    public void setUseMultiPartContentType(boolean useMultiPartContentType) {
        this.useMultiPartContentType = useMultiPartContentType;
    }

    @Override
    public int getContentLength() {
        if (this.useMultiPartContentType) {
            byte[] request = this.buildRequest();
            return request.length;
        }
        return -1;
    }

    @Override
    public long getContentLengthLong() {
        return this.getContentLength();
    }

    @Override
    public String getContentType() {
        if (this.useMultiPartContentType) {
            return "multipart/form-data; boundary=abcdefgABCDEFG";
        }
        return null;
    }

    @Override
    public String getContextPath() {
        return "/context";
    }

    public Cookie getCookie(String name) {
        Cookie[] cookies = this.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            return Cookies.copyOf(cookie);
        }
        return null;
    }

    @Override
    public Cookie[] getCookies() {
        if (this.cookies.isEmpty()) {
            return null;
        }
        ArrayList<Cookie> cookieValues = new ArrayList<Cookie>();
        cookieValues.addAll(this.cookies.values());
        return cookieValues.toArray(new Cookie[cookieValues.size()]);
    }

    @Override
    public long getDateHeader(String name) throws IllegalArgumentException {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        DateFormat df = DateFormat.getDateInstance(0);
        try {
            return df.parse(value).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can't convert header to date " + name + ": " + value);
        }
    }

    @Override
    public String getHeader(String name) {
        List l = (List)this.headers.get(name);
        if (l == null || l.size() < 1) {
            return null;
        }
        return (String)l.get(0);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        ArrayList list = (ArrayList)this.headers.get(name);
        if (list == null) {
            list = new ArrayList();
        }
        return Collections.enumeration(list);
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        byte[] request = this.buildRequest();
        final ByteArrayInputStream bais = new ByteArrayInputStream(request);
        return new ServletInputStream(){
            private boolean isFinished = false;
            private boolean isReady = true;

            @Override
            public boolean isFinished() {
                return this.isFinished;
            }

            @Override
            public boolean isReady() {
                return this.isReady;
            }

            @Override
            public void setReadListener(ReadListener readListener) {
            }

            @Override
            public int read() {
                this.isFinished = true;
                this.isReady = false;
                return bais.read();
            }
        };
    }

    @Override
    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.valueOf(value);
    }

    @Override
    public Locale getLocale() {
        return this.getLocales().nextElement();
    }

    public void setLocale(Locale locale) {
        this.setHeader("Accept-Language", locale.getLanguage() + "-" + locale.getCountry());
    }

    private Locale getLocale(String value) {
        String[] bits = Strings.split(value, '-');
        if (bits.length < 1) {
            return null;
        }
        String language = bits[0].toLowerCase(Locale.ROOT);
        if (bits.length > 1) {
            String country = bits[1].toUpperCase(Locale.ROOT);
            return new Locale(language, country);
        }
        return new Locale(language);
    }

    @Override
    public Enumeration<Locale> getLocales() {
        ArrayList<Locale> list = new ArrayList<Locale>();
        String header = this.getHeader("Accept-Language");
        if (header != null) {
            String[] locales;
            int idxOfSemicolon = header.indexOf(59);
            if (idxOfSemicolon > -1) {
                header = header.substring(0, idxOfSemicolon);
            }
            for (String value : locales = Strings.split(header, ',')) {
                Locale locale = this.getLocale(value);
                if (locale == null) continue;
                list.add(locale);
            }
        }
        if (list.size() == 0) {
            list.add(Locale.getDefault());
        }
        return Collections.enumeration(list);
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getParameter(String name) {
        String[] param = this.getParameterMap().get(name);
        if (param == null) {
            return null;
        }
        return param[0];
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> params = new HashMap<String, String[]>(this.parameters);
        for (String name : this.post.getParameterNames()) {
            List<StringValue> values = this.post.getParameterValues(name);
            for (StringValue value : values) {
                String[] present = (String[])params.get(name);
                if (present == null) {
                    params.put(name, new String[]{value.toString()});
                    continue;
                }
                String[] newval = new String[present.length + 1];
                System.arraycopy(present, 0, newval, 0, present.length);
                newval[newval.length - 1] = value.toString();
                params.put(name, newval);
            }
        }
        return params;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        String[] value = this.getParameterMap().get(name);
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String[]) {
            return value;
        }
        String[] result = new String[]{value.toString()};
        return result;
    }

    @Override
    public String getPathInfo() {
        return this.path;
    }

    @Override
    public String getPathTranslated() {
        return null;
    }

    @Override
    public String getProtocol() {
        return "HTTP/1.1";
    }

    @Override
    public String getQueryString() {
        if (this.parameters.size() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        Iterator<String> iterator = this.parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            String[] values = this.getParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                if (name != null) {
                    buf.append(UrlEncoder.QUERY_INSTANCE.encode(name, this.getCharset()));
                }
                buf.append('=');
                if (values[i] != null) {
                    buf.append(UrlEncoder.QUERY_INSTANCE.encode(values[i], this.getCharset()));
                }
                if (i + 1 >= values.length) continue;
                buf.append('&');
            }
            if (!iterator.hasNext()) continue;
            buf.append('&');
        }
        return buf.toString();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.getInputStream()));
    }

    @Override
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String addr) {
        this.remoteAddr = addr;
    }

    @Override
    public String getRemoteHost() {
        return "localhost";
    }

    @Override
    public String getRemoteUser() {
        return this.getHeader("REMOTE_USER");
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String name) {
        return this.context.getRequestDispatcher(name);
    }

    @Override
    public String getRequestedSessionId() {
        if (this.session instanceof MockHttpSession && ((MockHttpSession)this.session).isTemporary()) {
            return null;
        }
        return this.session.getId();
    }

    @Override
    public String getRequestURI() {
        if (this.url == null) {
            return this.getContextPath() + this.getServletPath();
        }
        int index = this.url.indexOf("?");
        if (index != -1) {
            return this.url.substring(0, index);
        }
        return this.url;
    }

    @Override
    public StringBuffer getRequestURL() {
        StringBuffer buf = new StringBuffer();
        buf.append("http://localhost");
        buf.append(this.getContextPath());
        if (this.getPathInfo() != null) {
            buf.append(this.getPathInfo());
        }
        return buf;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
        this.secure = "https".equalsIgnoreCase(scheme);
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    @Override
    public String getServletPath() {
        return "/servlet";
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public String changeSessionId() {
        HttpSession oldSession = this.getSession(false);
        if (oldSession == null) {
            throw new IllegalStateException("There is no active session associated with the current request");
        }
        oldSession.invalidate();
        HttpSession newSession = this.getSession(true);
        return newSession.getId();
    }

    @Override
    public HttpSession getSession(boolean createNew) {
        HttpSession sess = null;
        if (this.session instanceof MockHttpSession) {
            MockHttpSession mockHttpSession = (MockHttpSession)this.session;
            if (createNew) {
                mockHttpSession.setTemporary(false);
            }
            if (!mockHttpSession.isTemporary()) {
                sess = this.session;
            }
        }
        return sess;
    }

    @Override
    public Principal getUserPrincipal() {
        final String user = this.getRemoteUser();
        if (user == null) {
            return null;
        }
        return new Principal(){

            @Override
            public String getName() {
                return user;
            }
        };
    }

    public boolean hasUploadedFiles() {
        return this.uploadedFiles != null;
    }

    public void initialize(Locale locale) {
        this.authType = null;
        this.method = "post";
        this.cookies.clear();
        this.setDefaultHeaders(locale);
        this.path = null;
        this.url = null;
        this.characterEncoding = "UTF-8";
        this.parameters.clear();
        this.attributes.clear();
        this.post.reset();
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    @Override
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    @Override
    public void login(String username, String password) throws ServletException {
    }

    @Override
    public void logout() throws ServletException {
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        return this.parts.values();
    }

    @Override
    public Part getPart(String name) throws IOException, ServletException {
        return this.parts.get(name);
    }

    @Override
    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        return null;
    }

    public MockHttpServletRequest setPart(String name, Part part) {
        this.parts.put(name, part);
        return this;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public boolean isUserInRole(String name) {
        return false;
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    @Override
    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.characterEncoding = encoding;
    }

    public void setCookies(Cookie[] theCookies) {
        this.cookies.clear();
        this.addCookies(Arrays.asList(theCookies));
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParameter(String name, String value) {
        if (value == null) {
            this.parameters.remove(name);
        } else {
            this.parameters.put(name, new String[]{value});
        }
    }

    public void addParameter(String name, String value) {
        if (value == null) {
            return;
        }
        String[] val = this.parameters.get(name);
        if (val == null) {
            this.parameters.put(name, new String[]{value});
        } else {
            String[] newval = new String[val.length + 1];
            System.arraycopy(val, 0, newval, 0, val.length);
            newval[val.length] = value;
            this.parameters.put(name, newval);
        }
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters.putAll(parameters);
    }

    public void setPath(String path) {
        this.path = UrlDecoder.PATH_INSTANCE.decode(path, this.getCharset());
    }

    public void setURL(String url) {
        this.setUrl(Url.parse(url));
    }

    private void setDefaultHeaders(Locale l) {
        this.headers.clear();
        this.addHeader("Accept", "text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
        this.addHeader("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        this.addHeader("Accept-Language", l.getLanguage().toLowerCase(Locale.ROOT) + "-" + l.getCountry().toLowerCase(Locale.ROOT) + "," + l.getLanguage().toLowerCase(Locale.ROOT) + ";q=0.5");
        this.addHeader("User-Agent", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:41.0) Gecko/20100101 Firefox/41.0");
    }

    private void newAttachment(OutputStream out) throws IOException {
        out.write(boundary.getBytes());
        out.write(crlf.getBytes());
        out.write("Content-Disposition: form-data".getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildRequest() {
        if (this.uploadedFiles == null && !this.useMultiPartContentType) {
            if (this.post.getParameterNames().size() == 0) {
                return "".getBytes();
            }
            Url url = new Url();
            for (String string : this.post.getParameterNames()) {
                List<StringValue> values = this.post.getParameterValues(string);
                for (StringValue value : values) {
                    url.addQueryParameter(string, value.toString());
                }
            }
            String body = url.toString().substring(1);
            return body.getBytes();
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (String string : this.post.getParameterNames()) {
                List<StringValue> values = this.post.getParameterValues(string);
                for (StringValue value : values) {
                    this.newAttachment(out);
                    out.write("; name=\"".getBytes());
                    out.write(string.getBytes());
                    out.write("\"".getBytes());
                    out.write(crlf.getBytes());
                    out.write(crlf.getBytes());
                    out.write(value.toString().getBytes());
                    out.write(crlf.getBytes());
                }
            }
            if (this.uploadedFiles != null) {
                for (Map.Entry entry : this.uploadedFiles.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    List files = (List)entry.getValue();
                    for (UploadedFile uf : files) {
                        this.newAttachment(out);
                        out.write("; name=\"".getBytes());
                        out.write(fieldName.getBytes());
                        out.write("\"; filename=\"".getBytes());
                        if (uf.getFile() != null) {
                            out.write(uf.getFile().getName().getBytes());
                        }
                        out.write("\"".getBytes());
                        out.write(crlf.getBytes());
                        out.write("Content-Type: ".getBytes());
                        out.write(uf.getContentType().getBytes());
                        out.write(crlf.getBytes());
                        out.write(crlf.getBytes());
                        if (uf.getFile() != null) {
                            try (FileInputStream fis = new FileInputStream(uf.getFile());){
                                IOUtils.copy((InputStream)fis, (OutputStream)out);
                            }
                        }
                        out.write(crlf.getBytes());
                    }
                }
            }
            out.write(boundary.getBytes());
            out.write("--".getBytes());
            out.write(crlf.getBytes());
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    @Override
    public String getLocalAddr() {
        return "127.0.0.1";
    }

    @Override
    public String getLocalName() {
        return "127.0.0.1";
    }

    @Override
    public int getLocalPort() {
        return 80;
    }

    @Override
    public int getRemotePort() {
        return 80;
    }

    public void setUrl(Url url) {
        Object path;
        if (url.getProtocol() != null) {
            this.setScheme(url.getProtocol());
        }
        if (url.getHost() != null) {
            this.serverName = url.getHost();
        }
        if (url.getPort() != null) {
            this.serverPort = url.getPort();
        }
        if (!((String)(path = url.getPath(this.getCharset()))).startsWith("/")) {
            path = this.getContextPath() + this.getServletPath() + "/" + (String)path;
        }
        this.url = path;
        if (((String)path).startsWith(this.getContextPath())) {
            path = ((String)path).substring(this.getContextPath().length());
        }
        if (((String)path).startsWith(this.getServletPath())) {
            path = ((String)path).substring(this.getServletPath().length());
        }
        this.setPath((String)path);
        for (Url.QueryParameter parameter : url.getQueryParameters()) {
            this.addParameter(parameter.getName(), parameter.getValue());
        }
    }

    public Url getUrl() {
        String queryString = this.getQueryString();
        Object urlString = Strings.isEmpty(queryString) ? this.getRequestURI() : this.getRequestURI() + "?" + queryString;
        Url url = Url.parse((CharSequence)urlString, this.getCharset());
        url.setProtocol(this.scheme);
        url.setHost(this.serverName);
        url.setPort(this.serverPort);
        return url;
    }

    public MockRequestParameters getPostParameters() {
        return this.post;
    }

    public String getFilterPrefix() {
        return this.getServletPath().substring(1);
    }

    @Override
    public ServletContext getServletContext() {
        return this.context;
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    @Override
    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    @Override
    public boolean isAsyncStarted() {
        return false;
    }

    @Override
    public boolean isAsyncSupported() {
        return false;
    }

    @Override
    public AsyncContext getAsyncContext() {
        return null;
    }

    @Override
    public DispatcherType getDispatcherType() {
        return null;
    }

    @Override
    public String getRequestId() {
        return null;
    }

    @Override
    public String getProtocolRequestId() {
        return null;
    }

    @Override
    public ServletConnection getServletConnection() {
        return null;
    }

    private static class UploadedFile {
        private File file;
        private String contentType;

        public UploadedFile(String fieldName, File file, String contentType) {
            this.file = file;
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }

        public File getFile() {
            return this.file;
        }
    }
}

