/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.wicket.protocol.http.IResourceIsolationPolicy;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.util.string.Strings;

public class FetchMetadataResourceIsolationPolicy
implements IResourceIsolationPolicy {
    public static final String SEC_FETCH_SITE_HEADER = "sec-fetch-site";
    public static final String SEC_FETCH_MODE_HEADER = "sec-fetch-mode";
    public static final String SEC_FETCH_DEST_HEADER = "sec-fetch-dest";
    public static final String SAME_ORIGIN = "same-origin";
    public static final String SAME_SITE = "same-site";
    public static final String NONE = "none";
    public static final String MODE_NAVIGATE = "navigate";
    public static final String DEST_OBJECT = "object";
    public static final String DEST_EMBED = "embed";
    public static final String CROSS_SITE = "cross-site";
    public static final String CORS = "cors";
    public static final String DEST_SCRIPT = "script";
    public static final String DEST_IMAGE = "image";
    public static final String VARY_HEADER = "Vary";
    private static final String VARY_HEADER_VALUE = "sec-fetch-dest, sec-fetch-site, sec-fetch-mode";

    @Override
    public IResourceIsolationPolicy.ResourceIsolationOutcome isRequestAllowed(HttpServletRequest request, IRequestablePage targetPage) {
        String site = request.getHeader(SEC_FETCH_SITE_HEADER);
        if (Strings.isEmpty(site)) {
            return IResourceIsolationPolicy.ResourceIsolationOutcome.UNKNOWN;
        }
        if (SAME_ORIGIN.equals(site) || SAME_SITE.equals(site) || NONE.equals(site)) {
            return IResourceIsolationPolicy.ResourceIsolationOutcome.ALLOWED;
        }
        return this.isAllowedTopLevelNavigation(request) ? IResourceIsolationPolicy.ResourceIsolationOutcome.ALLOWED : IResourceIsolationPolicy.ResourceIsolationOutcome.DISALLOWED;
    }

    private boolean isAllowedTopLevelNavigation(HttpServletRequest request) {
        String mode = request.getHeader(SEC_FETCH_MODE_HEADER);
        String dest = request.getHeader(SEC_FETCH_DEST_HEADER);
        boolean isSimpleTopLevelNavigation = MODE_NAVIGATE.equals(mode) || "GET".equals(request.getMethod());
        boolean isNotObjectOrEmbedRequest = !DEST_EMBED.equals(dest) && !DEST_OBJECT.equals(dest);
        return isSimpleTopLevelNavigation && isNotObjectOrEmbedRequest;
    }

    @Override
    public void setHeaders(HttpServletResponse response) {
        response.addHeader(VARY_HEADER, VARY_HEADER_VALUE);
    }
}

