/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.pageStore.IPersistedPage;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.lang.Classes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPersistentPageStore
implements IPageStore {
    private static final String KEY_PREFIX = "wicket:";
    private static final Logger log = LoggerFactory.getLogger(AbstractPersistentPageStore.class);
    private static final ConcurrentMap<String, AbstractPersistentPageStore> STORES = new ConcurrentHashMap<String, AbstractPersistentPageStore>();
    private static final ThreadLocal<Boolean> gettingSessionAttribute = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final String storeKey;

    protected AbstractPersistentPageStore(String applicationName) {
        this.storeKey = Args.notNull(applicationName, "applicationName") + ":" + this.getClass().getSimpleName();
        if (STORES.containsKey(this.storeKey)) {
            throw new IllegalStateException("Store with key '" + this.storeKey + "' already exists.");
        }
        STORES.put(this.storeKey, this);
    }

    @Override
    public void destroy() {
        STORES.remove(this.storeKey);
    }

    @Override
    public boolean canBeAsynchronous(IPageContext context) {
        this.getSessionIdentifier(context, true);
        return true;
    }

    @Override
    public IManageablePage getPage(IPageContext context, int id) {
        String sessionIdentifier = this.getSessionIdentifier(context, false);
        if (sessionIdentifier == null) {
            return null;
        }
        return this.getPersistedPage(sessionIdentifier, id);
    }

    protected abstract IManageablePage getPersistedPage(String var1, int var2);

    @Override
    public void removePage(IPageContext context, IManageablePage page) {
        String sessionIdentifier = this.getSessionIdentifier(context, false);
        if (sessionIdentifier == null) {
            return;
        }
        this.removePersistedPage(sessionIdentifier, page);
    }

    protected abstract void removePersistedPage(String var1, IManageablePage var2);

    @Override
    public void removeAllPages(IPageContext context) {
        String sessionIdentifier = this.getSessionIdentifier(context, false);
        if (sessionIdentifier == null) {
            return;
        }
        this.removeAllPersistedPages(sessionIdentifier);
    }

    protected abstract void removeAllPersistedPages(String var1);

    @Override
    public void addPage(IPageContext context, IManageablePage page) {
        String sessionIdentifier = this.getSessionIdentifier(context, true);
        this.addPersistedPage(sessionIdentifier, page);
    }

    protected abstract void addPersistedPage(String var1, IManageablePage var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSessionIdentifier(IPageContext context, boolean create) {
        gettingSessionAttribute.set(Boolean.TRUE);
        try {
            String key = KEY_PREFIX + Classes.simpleName(this.getClass());
            SessionAttribute attribute = (SessionAttribute)context.getSessionAttribute(key, create ? () -> new SessionAttribute(this.storeKey, this.createSessionIdentifier(context)) : null);
            if (attribute == null) {
                String string = null;
                return string;
            }
            String string = attribute.sessionIdentifier;
            return string;
        }
        finally {
            gettingSessionAttribute.set(Boolean.FALSE);
        }
    }

    protected String createSessionIdentifier(IPageContext context) {
        return context.getSessionId(true);
    }

    public String getSessionIdentifier(IPageContext context) {
        return this.getSessionIdentifier(context, true);
    }

    private static class SessionAttribute
    implements Serializable,
    HttpSessionBindingListener {
        private final String storeKey;
        public final String sessionIdentifier;

        public SessionAttribute(String storeKey, String sessionIdentifier) {
            this.storeKey = Args.notNull(storeKey, "storeKey");
            this.sessionIdentifier = Args.notNull(sessionIdentifier, "sessionIdentifier");
        }

        @Override
        public void valueBound(HttpSessionBindingEvent event) {
        }

        @Override
        public void valueUnbound(HttpSessionBindingEvent event) {
            AbstractPersistentPageStore store = (AbstractPersistentPageStore)STORES.get(this.storeKey);
            if (store == null) {
                log.warn("Cannot remove data '{}' because disk store '{}' is no longer present.", (Object)this.sessionIdentifier, (Object)this.storeKey);
            } else if (Boolean.FALSE.equals(gettingSessionAttribute.get())) {
                store.removeAllPersistedPages(this.sessionIdentifier);
            }
        }
    }

    protected static class PersistedPage
    implements IPersistedPage {
        private final int pageId;
        private final String pageType;
        private final long pageSize;

        public PersistedPage(int pageId, String pageType, long pageSize) {
            this.pageId = pageId;
            this.pageType = pageType;
            this.pageSize = pageSize;
        }

        @Override
        public int getPageId() {
            return this.pageId;
        }

        @Override
        public Bytes getPageSize() {
            return Bytes.bytes(this.pageSize);
        }

        @Override
        public String getPageType() {
            return this.pageType;
        }
    }
}

