/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.resource;

import jakarta.servlet.ServletContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.io.Connections;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebExternalResourceStream
extends AbstractResourceStream {
    private static final Logger log = LoggerFactory.getLogger(WebExternalResourceStream.class);
    private static final long serialVersionUID = 1L;
    transient InputStream in;
    private final String url;

    public WebExternalResourceStream(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument url must be not null");
        }
        this.url = url;
    }

    @Override
    public Bytes length() {
        return null;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.in);
    }

    @Override
    public Instant lastModifiedTime() {
        try {
            ServletContext context = ((WebApplication)Application.get()).getServletContext();
            URL resourceURL = context.getResource(this.url);
            if (resourceURL == null) {
                throw new FileNotFoundException("Unable to find resource '" + this.url + "' in the servlet context");
            }
            return Connections.getLastModified(resourceURL);
        }
        catch (IOException e) {
            log.warn("failed to retrieve last modified timestamp", e);
            return null;
        }
    }

    @Override
    public String getContentType() {
        return WebApplication.get().getServletContext().getMimeType(this.url);
    }

    @Override
    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        ServletContext context = ((WebApplication)Application.get()).getServletContext();
        this.in = context.getResourceAsStream(this.url);
        if (this.in == null) {
            throw new ResourceStreamNotFoundException("The requested resource was not found: " + this.url);
        }
        return this.in;
    }
}

