/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.PropertyResolverConverter;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyResolver {
    private static final Logger log = LoggerFactory.getLogger(PropertyResolver.class);
    private static final int RETURN_NULL = 0;
    private static final int CREATE_NEW_VALUE = 1;
    private static final int RESOLVE_CLASS = 2;
    private static final ConcurrentHashMap<Object, IPropertyLocator> applicationToLocators = Generics.newConcurrentHashMap((int)2);
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String SET = "set";

    public static Object getValue(String expression, Object object) {
        if (expression == null || expression.equals("") || object == null) {
            return object;
        }
        ObjectWithGetAndSet objectWithGetAndSet = PropertyResolver.getObjectWithGetAndSet(expression, object, 0);
        if (objectWithGetAndSet == null) {
            return null;
        }
        return objectWithGetAndSet.getValue();
    }

    public static void setValue(String expression, Object object, Object value, PropertyResolverConverter converter) {
        if (Strings.isEmpty((String)expression)) {
            throw new WicketRuntimeException("Empty expression setting value: " + value + " on object: " + object);
        }
        if (object == null) {
            throw new WicketRuntimeException("Attempted to set property value on a null object. Property expression: " + expression + " Value: " + value);
        }
        ObjectWithGetAndSet objectWithGetAndSet = PropertyResolver.getObjectWithGetAndSet(expression, object, 1);
        if (objectWithGetAndSet == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for setting value: " + value + " on: " + object);
        }
        objectWithGetAndSet.setValue(value, converter == null ? new PropertyResolverConverter(Application.get().getConverterLocator(), Session.get().getLocale()) : converter);
    }

    public static Class<?> getPropertyClass(String expression, Object object) {
        ObjectWithGetAndSet objectWithGetAndSet = PropertyResolver.getObjectWithGetAndSet(expression, object, 2);
        if (objectWithGetAndSet == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for getting the target class of: " + object);
        }
        return objectWithGetAndSet.getTargetClass();
    }

    public static <T> Class<T> getPropertyClass(String expression, Class<?> clz) {
        ObjectWithGetAndSet objectWithGetAndSet = PropertyResolver.getObjectWithGetAndSet(expression, null, 2, clz);
        if (objectWithGetAndSet == null) {
            throw new WicketRuntimeException("No Class returned for expression: " + expression + " for getting the target class of: " + clz);
        }
        return objectWithGetAndSet.getTargetClass();
    }

    public static Field getPropertyField(String expression, Object object) {
        ObjectWithGetAndSet objectWithGetAndSet = PropertyResolver.getObjectWithGetAndSet(expression, object, 2);
        if (objectWithGetAndSet == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for getting the target class of: " + object);
        }
        return objectWithGetAndSet.getField();
    }

    public static Method getPropertyGetter(String expression, Object object) {
        ObjectWithGetAndSet objectWithGetAndSet = PropertyResolver.getObjectWithGetAndSet(expression, object, 2);
        if (objectWithGetAndSet == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for getting the target class of: " + object);
        }
        return objectWithGetAndSet.getGetter();
    }

    public static Method getPropertySetter(String expression, Object object) {
        ObjectWithGetAndSet objectWithGetAndSet = PropertyResolver.getObjectWithGetAndSet(expression, object, 2);
        if (objectWithGetAndSet == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for getting the target class of: " + object);
        }
        return objectWithGetAndSet.getSetter();
    }

    private static ObjectWithGetAndSet getObjectWithGetAndSet(String expression, Object object, int tryToCreateNull) {
        return PropertyResolver.getObjectWithGetAndSet(expression, object, tryToCreateNull, object.getClass());
    }

    private static ObjectWithGetAndSet getObjectWithGetAndSet(String expression, Object object, int tryToCreateNull, Class<?> clz) {
        IGetAndSet getAndSet;
        String expressionBracketsSeperated = Strings.replaceAll((CharSequence)expression, (CharSequence)"[", (CharSequence)".[").toString();
        int index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, 0);
        while (index == 0 && expressionBracketsSeperated.startsWith(".")) {
            expressionBracketsSeperated = expressionBracketsSeperated.substring(1);
            index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, 0);
        }
        int lastIndex = 0;
        Object value = object;
        String exp = expressionBracketsSeperated;
        while (index != -1) {
            exp = expressionBracketsSeperated.substring(lastIndex, index);
            if (exp.length() == 0) {
                exp = expressionBracketsSeperated.substring(index + 1);
                break;
            }
            try {
                getAndSet = PropertyResolver.getGetAndSet(exp, clz);
            }
            catch (WicketRuntimeException ex) {
                int temp = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, index + 1);
                if (temp == -1) {
                    exp = expressionBracketsSeperated.substring(lastIndex);
                    break;
                }
                index = temp;
                continue;
            }
            Object nextValue = null;
            if (value != null) {
                nextValue = getAndSet.getValue(value);
            }
            if (nextValue == null) {
                if (tryToCreateNull == 1) {
                    nextValue = getAndSet.newValue(value);
                    if (nextValue == null) {
                        return null;
                    }
                } else if (tryToCreateNull == 2) {
                    clz = getAndSet.getTargetClass();
                } else {
                    return null;
                }
            }
            if ((value = nextValue) != null) {
                clz = value.getClass();
            }
            if ((index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, lastIndex = index + 1)) != -1) continue;
            exp = expressionBracketsSeperated.substring(lastIndex);
            break;
        }
        getAndSet = PropertyResolver.getGetAndSet(exp, clz);
        return new ObjectWithGetAndSet(getAndSet, value);
    }

    private static int getNextDotIndex(String expression, int start) {
        boolean insideBracket = false;
        for (int i = start; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            if (ch == '.' && !insideBracket) {
                return i;
            }
            if (ch == '[') {
                insideBracket = true;
                continue;
            }
            if (ch != ']') continue;
            insideBracket = false;
        }
        return -1;
    }

    private static IGetAndSet getGetAndSet(String exp, Class<?> clz) {
        IPropertyLocator locator = PropertyResolver.getLocator();
        IGetAndSet getAndSet = locator.get(clz, exp);
        if (getAndSet == null) {
            throw new WicketRuntimeException("Property could not be resolved for class: " + clz + " expression: " + exp);
        }
        return getAndSet;
    }

    private PropertyResolver() {
    }

    public static void destroy(Application application) {
        applicationToLocators.remove(application);
    }

    public static IPropertyLocator getLocator() {
        IPropertyLocator tmpResult;
        Object key = Application.exists() ? Application.get() : PropertyResolver.class;
        IPropertyLocator result = applicationToLocators.get(key);
        if (result == null && (tmpResult = applicationToLocators.putIfAbsent(key, result = new CachingPropertyLocator(new DefaultPropertyLocator()))) != null) {
            result = tmpResult;
        }
        return result;
    }

    public static void setLocator(Application application, IPropertyLocator locator) {
        if (application == null) {
            applicationToLocators.put(PropertyResolver.class, locator);
        } else {
            applicationToLocators.put(application, locator);
        }
    }

    private static final class ObjectWithGetAndSet {
        private final IGetAndSet getAndSet;
        private final Object value;

        public ObjectWithGetAndSet(IGetAndSet getAndSet, Object value) {
            this.getAndSet = getAndSet;
            this.value = value;
        }

        public void setValue(Object value, PropertyResolverConverter converter) {
            this.getAndSet.setValue(this.value, value, converter);
        }

        public Object getValue() {
            return this.getAndSet.getValue(this.value);
        }

        public Class<?> getTargetClass() {
            return this.getAndSet.getTargetClass();
        }

        public Field getField() {
            return this.getAndSet.getField();
        }

        public Method getGetter() {
            return this.getAndSet.getGetter();
        }

        public Method getSetter() {
            return this.getAndSet.getSetter();
        }
    }

    public static interface IGetAndSet {
        public Object getValue(Object var1);

        public Class<?> getTargetClass();

        public Object newValue(Object var1);

        public void setValue(Object var1, Object var2, PropertyResolverConverter var3);

        public Field getField();

        public Method getGetter();

        public Method getSetter();
    }

    public static interface IPropertyLocator {
        public IGetAndSet get(Class<?> var1, String var2);
    }

    public static class CachingPropertyLocator
    implements IPropertyLocator {
        private final ConcurrentHashMap<String, IGetAndSet> map = Generics.newConcurrentHashMap((int)16);
        private IGetAndSet NONE = new AbstractGetAndSet(){

            @Override
            public Object getValue(Object object) {
                return null;
            }

            @Override
            public Object newValue(Object object) {
                return null;
            }

            @Override
            public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            }
        };
        private final IPropertyLocator locator;

        public CachingPropertyLocator(IPropertyLocator locator) {
            this.locator = locator;
        }

        @Override
        public IGetAndSet get(Class<?> clz, String exp) {
            String key = clz.getName() + "#" + exp;
            IGetAndSet located = this.map.get(key);
            if (located == null) {
                located = this.locator.get(clz, exp);
                if (located == null) {
                    located = this.NONE;
                }
                this.map.put(key, located);
            }
            if (located == this.NONE) {
                located = null;
            }
            return located;
        }
    }

    public static class DefaultPropertyLocator
    implements IPropertyLocator {
        @Override
        public IGetAndSet get(Class<?> clz, String exp) {
            AbstractGetAndSet getAndSet = null;
            Method method = null;
            if (exp.startsWith("[")) {
                exp = exp.substring(1, exp.length() - 1);
            } else {
                method = exp.endsWith("()") ? this.findMethod(clz, exp) : this.findGetter(clz, exp);
            }
            if (method == null) {
                if (List.class.isAssignableFrom(clz)) {
                    try {
                        int index = Integer.parseInt(exp);
                        getAndSet = new ListGetAndSet(index);
                    }
                    catch (NumberFormatException ex) {
                        method = this.findMethod(clz, exp);
                        if (method != null) {
                            getAndSet = new MethodGetAndSet(method, MethodGetAndSet.findSetter(method, clz), null);
                        }
                        Field field = this.findField(clz, exp);
                        if (field != null) {
                            getAndSet = new FieldGetAndSet(field);
                        }
                        throw new WicketRuntimeException("The expression '" + exp + "' is neither an index nor is it a method or field for the list " + clz);
                    }
                } else if (Map.class.isAssignableFrom(clz)) {
                    getAndSet = new MapGetAndSet(exp);
                } else if (clz.isArray()) {
                    try {
                        int index = Integer.parseInt(exp);
                        getAndSet = new ArrayGetAndSet(clz.getComponentType(), index);
                    }
                    catch (NumberFormatException ex) {
                        if (exp.equals("length") || exp.equals("size")) {
                            getAndSet = new ArrayLengthGetAndSet();
                        }
                        throw new WicketRuntimeException("Can't parse the expression '" + exp + "' as an index for an array lookup");
                    }
                } else {
                    Field field = this.findField(clz, exp);
                    if (field == null) {
                        method = this.findMethod(clz, exp);
                        if (method == null) {
                            int index = exp.indexOf(46);
                            if (index != -1) {
                                String propertyName = exp.substring(0, index);
                                String propertyIndex = exp.substring(index + 1);
                                try {
                                    int parsedIndex = Integer.parseInt(propertyIndex);
                                    String name = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                                    method = clz.getMethod(PropertyResolver.GET + name, Integer.TYPE);
                                    getAndSet = new IndexedPropertyGetAndSet(method, parsedIndex);
                                }
                                catch (Exception e) {
                                    throw new WicketRuntimeException("No get method defined for class: " + clz + " expression: " + propertyName);
                                }
                            }
                        } else {
                            getAndSet = new MethodGetAndSet(method, MethodGetAndSet.findSetter(method, clz), null);
                        }
                    } else {
                        getAndSet = new FieldGetAndSet(field);
                    }
                }
            } else {
                Field field = this.findField(clz, exp);
                getAndSet = new MethodGetAndSet(method, MethodGetAndSet.findSetter(method, clz), field);
            }
            return getAndSet;
        }

        private Field findField(Class<?> clz, String expression) {
            Field field = null;
            try {
                field = clz.getField(expression);
            }
            catch (Exception e) {
                for (Class<?> tmp = clz; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
                    Field[] fields;
                    for (Field aField : fields = tmp.getDeclaredFields()) {
                        if (!aField.getName().equals(expression)) continue;
                        aField.setAccessible(true);
                        return aField;
                    }
                }
                log.debug("Cannot find field {}.{}", clz, (Object)expression);
            }
            return field;
        }

        private Method findGetter(Class<?> clz, String expression) {
            String name = Character.toUpperCase(expression.charAt(0)) + expression.substring(1);
            Method method = null;
            try {
                method = clz.getMethod(PropertyResolver.GET + name, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (method == null) {
                try {
                    method = clz.getMethod(PropertyResolver.IS + name, null);
                }
                catch (Exception e) {
                    log.debug("Cannot find getter {}.{}", clz, (Object)expression);
                }
            }
            return method;
        }

        private Method findMethod(Class<?> clz, String expression) {
            if (expression.endsWith("()")) {
                expression = expression.substring(0, expression.length() - 2);
            }
            Method method = null;
            try {
                method = clz.getMethod(expression, null);
            }
            catch (Exception e) {
                log.debug("Cannot find method {}.{}", clz, (Object)expression);
            }
            return method;
        }
    }

    private static class FieldGetAndSet
    extends AbstractGetAndSet {
        private final Field field;

        public FieldGetAndSet(Field field) {
            this.field = field;
            this.field.setAccessible(true);
        }

        @Override
        public Object getValue(Object object) {
            try {
                return this.field.get(object);
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error getting field value of field " + this.field + " from object " + object, ex);
            }
        }

        @Override
        public Object newValue(Object object) {
            Class<?> clz = this.field.getType();
            Object value = null;
            try {
                value = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.field.set(object, value);
            }
            catch (Exception e) {
                log.warn("Cannot set field " + this.field + " to " + value, (Throwable)e);
            }
            return value;
        }

        @Override
        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            value = converter.convert(value, this.field.getType());
            try {
                this.field.set(object, value);
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error setting field value of field " + this.field + " on object " + object + ", value " + value, ex);
            }
        }

        @Override
        public Class<?> getTargetClass() {
            return this.field.getType();
        }

        @Override
        public Field getField() {
            return this.field;
        }
    }

    private static final class MethodGetAndSet
    extends AbstractGetAndSet {
        private final Method getMethod;
        private final Method setMethod;
        private final Field field;

        MethodGetAndSet(Method getMethod, Method setMethod, Field field) {
            this.getMethod = getMethod;
            this.getMethod.setAccessible(true);
            this.field = field;
            this.setMethod = setMethod;
        }

        @Override
        public final Object getValue(Object object) {
            Object ret;
            try {
                ret = this.getMethod.invoke(object, (Object[])null);
            }
            catch (InvocationTargetException ex) {
                throw new WicketRuntimeException("Error calling method: " + this.getMethod + " on object: " + object, ex.getCause());
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error calling method: " + this.getMethod + " on object: " + object, ex);
            }
            return ret;
        }

        @Override
        public final void setValue(Object object, Object value, PropertyResolverConverter converter) {
            Class<?> type = null;
            if (this.setMethod != null) {
                type = this.setMethod.getParameterTypes()[0];
            } else if (this.field != null) {
                type = this.field.getType();
            }
            Object converted = null;
            if (type != null && (converted = converter.convert(value, type)) == null) {
                if (value != null) {
                    throw new ConversionException("Method [" + this.getMethod + "]. Can't convert value: " + value + " to class: " + type + " for setting it on " + object);
                }
                if (this.setMethod != null && type.isPrimitive()) {
                    throw new ConversionException("Method [" + this.setMethod + "]. Can't convert null value to a primitive class: " + type + " for setting it on " + object);
                }
            }
            if (this.setMethod != null) {
                try {
                    this.setMethod.invoke(object, converted);
                }
                catch (InvocationTargetException ex) {
                    throw new WicketRuntimeException("Error calling method: " + this.setMethod + " on object: " + object, ex.getCause());
                }
                catch (Exception ex) {
                    throw new WicketRuntimeException("Error calling method: " + this.setMethod + " on object: " + object, ex);
                }
            } else if (this.field != null) {
                try {
                    this.field.set(object, converted);
                }
                catch (Exception ex) {
                    throw new WicketRuntimeException("Error setting field: " + this.field + " on object: " + object, ex);
                }
            } else {
                throw new WicketRuntimeException("no set method defined for value: " + value + " on object: " + object + " while respective getMethod being " + this.getMethod.getName());
            }
        }

        private static Method findSetter(Method getMethod, Class<?> clz) {
            Object name = getMethod.getName();
            name = ((String)name).startsWith(PropertyResolver.GET) ? PropertyResolver.SET + ((String)name).substring(3) : PropertyResolver.SET + ((String)name).substring(2);
            try {
                Method method = clz.getMethod((String)name, getMethod.getReturnType());
                if (method != null) {
                    method.setAccessible(true);
                }
                return method;
            }
            catch (NoSuchMethodException e) {
                Method[] methods;
                for (Method method : methods = clz.getMethods()) {
                    Class<?>[] parameterTypes;
                    if (!method.getName().equals(name) || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(getMethod.getReturnType())) continue;
                    return method;
                }
                log.debug("Cannot find setter corresponding to " + getMethod, (Throwable)e);
            }
            catch (Exception e) {
                log.debug("Cannot find setter corresponding to " + getMethod, (Throwable)e);
            }
            return null;
        }

        @Override
        public Object newValue(Object object) {
            if (this.setMethod == null) {
                log.warn("Null setMethod");
                return null;
            }
            Class<?> clz = this.getMethod.getReturnType();
            Object value = null;
            try {
                value = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.setMethod.invoke(object, value);
            }
            catch (Exception e) {
                log.warn("Cannot set new value " + value, (Throwable)e);
            }
            return value;
        }

        @Override
        public Class<?> getTargetClass() {
            return this.getMethod.getReturnType();
        }

        @Override
        public Method getGetter() {
            return this.getMethod;
        }

        @Override
        public Method getSetter() {
            return this.setMethod;
        }

        @Override
        public Field getField() {
            return this.field;
        }
    }

    private static final class IndexedPropertyGetAndSet
    extends AbstractGetAndSet {
        private final Integer index;
        private final Method getMethod;
        private Method setMethod;

        IndexedPropertyGetAndSet(Method method, int index) {
            this.index = index;
            this.getMethod = method;
            this.getMethod.setAccessible(true);
        }

        private static Method findSetter(Method getMethod, Class<?> clz) {
            Object name = getMethod.getName();
            name = PropertyResolver.SET + ((String)name).substring(3);
            try {
                return clz.getMethod((String)name, Integer.TYPE, getMethod.getReturnType());
            }
            catch (Exception e) {
                log.debug("Can't find setter method corresponding to {}", (Object)getMethod);
                return null;
            }
        }

        @Override
        public Object getValue(Object object) {
            Object ret;
            try {
                ret = this.getMethod.invoke(object, this.index);
            }
            catch (InvocationTargetException ex) {
                throw new WicketRuntimeException("Error calling index property method: " + this.getMethod + " on object: " + object, ex.getCause());
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error calling index property method: " + this.getMethod + " on object: " + object, ex);
            }
            return ret;
        }

        @Override
        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            if (this.setMethod == null) {
                this.setMethod = IndexedPropertyGetAndSet.findSetter(this.getMethod, object.getClass());
            }
            if (this.setMethod != null) {
                this.setMethod.setAccessible(true);
                Object converted = converter.convert(value, this.getMethod.getReturnType());
                if (converted == null && value != null) {
                    throw new ConversionException("Can't convert value: " + value + " to class: " + this.getMethod.getReturnType() + " for setting it on " + object);
                }
                try {
                    this.setMethod.invoke(object, this.index, converted);
                }
                catch (InvocationTargetException ex) {
                    throw new WicketRuntimeException("Error index property calling method: " + this.setMethod + " on object: " + object, ex.getCause());
                }
                catch (Exception ex) {
                    throw new WicketRuntimeException("Error index property calling method: " + this.setMethod + " on object: " + object, ex);
                }
            } else {
                throw new WicketRuntimeException("No set method defined for value: " + value + " on object: " + object);
            }
        }

        @Override
        public Class<?> getTargetClass() {
            return this.getMethod.getReturnType();
        }

        @Override
        public Object newValue(Object object) {
            if (this.setMethod == null) {
                this.setMethod = IndexedPropertyGetAndSet.findSetter(this.getMethod, object.getClass());
            }
            if (this.setMethod == null) {
                log.warn("Null setMethod");
                return null;
            }
            Class<?> clz = this.getMethod.getReturnType();
            Object value = null;
            try {
                value = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.setMethod.invoke(object, this.index, value);
            }
            catch (Exception e) {
                log.warn("Cannot set new value " + value + " at index " + this.index, (Throwable)e);
            }
            return value;
        }
    }

    private static final class ArrayLengthGetAndSet
    extends AbstractGetAndSet {
        ArrayLengthGetAndSet() {
        }

        @Override
        public Object getValue(Object object) {
            return Array.getLength(object);
        }

        @Override
        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            throw new WicketRuntimeException("You can't set the length on an array:" + object);
        }

        @Override
        public Object newValue(Object object) {
            throw new WicketRuntimeException("Can't get a new value from a length of an array: " + object);
        }

        @Override
        public Class<?> getTargetClass() {
            return Integer.TYPE;
        }
    }

    private static final class ArrayGetAndSet
    extends AbstractGetAndSet {
        private final int index;
        private final Class<?> clzComponentType;

        ArrayGetAndSet(Class<?> clzComponentType, int index) {
            this.clzComponentType = clzComponentType;
            this.index = index;
        }

        @Override
        public Object getValue(Object object) {
            if (Array.getLength(object) > this.index) {
                return Array.get(object, this.index);
            }
            return null;
        }

        @Override
        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            value = converter.convert(value, this.clzComponentType);
            Array.set(object, this.index, value);
        }

        @Override
        public Object newValue(Object object) {
            Object value = null;
            try {
                value = this.clzComponentType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Array.set(object, this.index, value);
            }
            catch (Exception e) {
                log.warn("Cannot set new value {} at index {} for array holding elements of class {}", new Object[]{value, this.index, this.clzComponentType, e});
            }
            return value;
        }

        @Override
        public Class<?> getTargetClass() {
            return this.clzComponentType;
        }
    }

    private static final class ListGetAndSet
    extends AbstractGetAndSet {
        private final int index;

        ListGetAndSet(int index) {
            this.index = index;
        }

        @Override
        public Object getValue(Object object) {
            if (((List)object).size() <= this.index) {
                return null;
            }
            return ((List)object).get(this.index);
        }

        @Override
        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            List lst = (List)object;
            if (lst.size() > this.index) {
                lst.set(this.index, value);
            } else if (lst.size() == this.index) {
                lst.add(value);
            } else {
                while (lst.size() < this.index) {
                    lst.add(null);
                }
                lst.add(value);
            }
        }

        @Override
        public Object newValue(Object object) {
            return null;
        }
    }

    private static final class MapGetAndSet
    extends AbstractGetAndSet {
        private final String key;

        MapGetAndSet(String key) {
            this.key = key;
        }

        @Override
        public Object getValue(Object object) {
            return ((Map)object).get(this.key);
        }

        @Override
        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            ((Map)object).put(this.key, value);
        }

        @Override
        public Object newValue(Object object) {
            return null;
        }
    }

    public static abstract class AbstractGetAndSet
    implements IGetAndSet {
        @Override
        public Field getField() {
            return null;
        }

        @Override
        public Method getGetter() {
            return null;
        }

        @Override
        public Method getSetter() {
            return null;
        }

        @Override
        public Class<?> getTargetClass() {
            return null;
        }
    }
}

