/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.mock;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServletContext
implements ServletContext {
    private static final Logger log = LoggerFactory.getLogger(MockServletContext.class);
    private final Application application;
    private final ValueMap attributes = new ValueMap();
    private final ValueMap initParameters = new ValueMap();
    private final Map<String, ServletRegistration.Dynamic> servletRegistration = new HashMap<String, ServletRegistration.Dynamic>();
    private final ValueMap mimeTypes = new ValueMap();
    private File webappRoot;
    private final SessionCookieConfig sessionCookieConfig = new SessionCookieConfig(){
        private boolean secure;
        private String path;
        private String name = "JSESSIONID";
        private int maxAge;
        private boolean httpOnly;
        private String domain;
        private String comment;
        private final Map<String, String> attributes = new HashMap<String, String>();

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setMaxAge(int maxAge) {
            this.maxAge = maxAge;
        }

        public void setHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public boolean isHttpOnly() {
            return this.httpOnly;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public int getMaxAge() {
            return this.maxAge;
        }

        public void setAttribute(String s, String s1) {
            this.attributes.put(s, s1);
        }

        public String getAttribute(String s) {
            return this.attributes.get(s);
        }

        public Map<String, String> getAttributes() {
            return Map.copyOf(this.attributes);
        }

        public String getDomain() {
            return this.domain;
        }

        public String getComment() {
            return this.comment;
        }
    };
    private int sessionTimeout = 30;
    private Charset requestCharacterEncoding = StandardCharsets.UTF_8;
    private Charset responseCharacterEncoding = StandardCharsets.UTF_8;

    public MockServletContext(Application application, String path) {
        this.application = application;
        this.webappRoot = null;
        if (path != null) {
            this.webappRoot = new File(path);
            if (!this.webappRoot.exists() || !this.webappRoot.isDirectory()) {
                log.warn("WARNING: The webapp root directory is invalid: " + path);
                this.webappRoot = null;
            }
        }
        String workFolder = System.getProperty("wicket.tester.work.folder", "target/work/");
        File file = new File(workFolder);
        try {
            file.mkdirs();
        }
        catch (SecurityException sx) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            file = new File(tmpDir);
        }
        this.attributes.put("jakarta.servlet.context.tempdir", (Object)file);
        this.mimeTypes.put("html", (Object)"text/html");
        this.mimeTypes.put("htm", (Object)"text/html");
        this.mimeTypes.put("css", (Object)"text/css");
        this.mimeTypes.put("xml", (Object)"text/xml");
        this.mimeTypes.put("js", (Object)"text/javascript");
        this.mimeTypes.put("gif", (Object)"image/gif");
        this.mimeTypes.put("jpg", (Object)"image/jpeg");
        this.mimeTypes.put("png", (Object)"image/png");
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, (Object)value);
    }

    public void addMimeType(String fileExtension, String mimeType) {
        this.mimeTypes.put(fileExtension, (Object)mimeType);
    }

    public Object getAttribute(String name) {
        return this.attributes.get((Object)name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public ServletContext getContext(String name) {
        return this;
    }

    public String getInitParameter(String name) {
        return this.initParameters.getString(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public boolean setInitParameter(String name, String value) {
        return false;
    }

    public String getMimeType(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1 || index == name.length() - 1) {
            return null;
        }
        return this.mimeTypes.getString(name.substring(index + 1));
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 0;
    }

    public int getEffectiveMajorVersion() {
        return 3;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.getRequestDispatcher(name);
    }

    public String getRealPath(String name) {
        try {
            URL url = this.getResource(name);
            if (url != null) {
                return new File(url.toURI()).getAbsolutePath();
            }
        }
        catch (IOException | URISyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(final String name) {
        return new RequestDispatcher(){

            public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
                servletResponse.getWriter().write("FORWARD TO RESOURCE: " + name);
            }

            public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
                servletResponse.getWriter().write("INCLUDE OF RESOURCE: " + name);
            }
        };
    }

    public URL getResource(String name) throws MalformedURLException {
        File f;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (this.webappRoot != null && (f = new File(this.webappRoot, name)).exists()) {
            return f.toURI().toURL();
        }
        return this.getClass().getClassLoader().getResource("META-INF/resources/" + name);
    }

    public InputStream getResourceAsStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Set<String> getResourcePaths(String name) {
        if (this.webappRoot == null) {
            return new HashSet<String>();
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        String[] elements = null;
        elements = name.trim().length() == 0 ? new String[]{} : Strings.split((String)name, (char)'/');
        File current = this.webappRoot;
        for (String element : elements) {
            File[] files = current.listFiles();
            boolean match = false;
            if (files != null) {
                for (File file : files) {
                    if (!file.getName().equals(element) || !file.isDirectory()) continue;
                    current = file;
                    match = true;
                    break;
                }
            }
            if (match) continue;
            return null;
        }
        File[] files = current.listFiles();
        HashSet<String> result = new HashSet<String>();
        if (files != null) {
            int stripLength = this.webappRoot.getPath().length();
            for (File file : files) {
                Object s = file.getPath().substring(stripLength).replace('\\', '/');
                if (file.isDirectory()) {
                    s = (String)s + "/";
                }
                result.add((String)s);
            }
        }
        return result;
    }

    public String getServerInfo() {
        return "Wicket Mock Test Environment v1.0";
    }

    public String getServletContextName() {
        return this.application.getName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        try {
            return this.addServlet(servletName, Class.forName(className).asSubclass(Servlet.class));
        }
        catch (ClassNotFoundException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        ServletRegistration.Dynamic mockRegistration = (ServletRegistration.Dynamic)Proxy.newProxyInstance(ServletRegistration.Dynamic.class.getClassLoader(), new Class[]{ServletRegistration.Dynamic.class}, (InvocationHandler)new MockedServletRegistationHandler(servletName));
        this.servletRegistration.put(servletName, mockRegistration);
        return mockRegistration;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        try {
            return this.addServlet(servletName, servletClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public ServletRegistration.Dynamic addJspFile(String s, String s1) {
        return null;
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            return (T)((Servlet)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return (ServletRegistration)this.servletRegistration.get(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.servletRegistration;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return null;
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return null;
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return EnumSet.of(SessionTrackingMode.COOKIE);
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.getDefaultSessionTrackingModes();
    }

    public void addListener(String className) {
    }

    public <T extends EventListener> void addListener(T t) {
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public void declareRoles(String ... roleNames) {
    }

    public String getVirtualServerName() {
        return "WicketTester 8.x";
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public String getRequestCharacterEncoding() {
        return this.requestCharacterEncoding.name();
    }

    public void setRequestCharacterEncoding(String requestCharacterEncoding) {
        this.requestCharacterEncoding = Charset.forName(requestCharacterEncoding);
    }

    public String getResponseCharacterEncoding() {
        return this.responseCharacterEncoding.name();
    }

    public void setResponseCharacterEncoding(String responseCharacterEncoding) {
        this.responseCharacterEncoding = Charset.forName(responseCharacterEncoding);
    }

    public void log(String msg) {
        log.info(msg);
    }

    public void log(String msg, Throwable cause) {
        log.error(msg, cause);
    }

    public void removeAttribute(String name) {
        this.attributes.remove((Object)name);
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public String getContextPath() {
        return "";
    }

    class MockedServletRegistationHandler
    implements InvocationHandler {
        private final Collection<String> servletName;

        public MockedServletRegistationHandler(String servletName) {
            this.servletName = Arrays.asList(servletName);
        }

        @Override
        public Object invoke(Object object, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getMappings")) {
                return this.servletName;
            }
            return null;
        }
    }
}

