/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.servlet.ResponseIOException;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.UrlRenderer;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;

public class ServletWebResponse
extends WebResponse {
    private final HttpServletResponse httpServletResponse;
    private final ServletWebRequest webRequest;
    private boolean redirect = false;

    public ServletWebResponse(ServletWebRequest webRequest, HttpServletResponse httpServletResponse) {
        Args.notNull((Object)((Object)webRequest), (String)"webRequest");
        Args.notNull((Object)httpServletResponse, (String)"httpServletResponse");
        this.httpServletResponse = httpServletResponse;
        this.webRequest = webRequest;
    }

    public void addCookie(Cookie cookie) {
        this.httpServletResponse.addCookie(cookie);
    }

    public void clearCookie(Cookie cookie) {
        cookie.setMaxAge(0);
        cookie.setValue(null);
        this.addCookie(cookie);
    }

    public void setContentLength(long length) {
        this.httpServletResponse.addHeader("Content-Length", Long.toString(length));
    }

    public void setContentType(String mimeType) {
        this.httpServletResponse.setContentType(mimeType);
    }

    public void setDateHeader(String name, Instant date) {
        Args.notNull((Object)date, (String)"date");
        this.httpServletResponse.setDateHeader(name, date.toEpochMilli());
    }

    public boolean isHeaderSupported() {
        return true;
    }

    public void setHeader(String name, String value) {
        this.httpServletResponse.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.httpServletResponse.addHeader(name, value);
    }

    public void write(CharSequence sequence) {
        try {
            this.httpServletResponse.getWriter().append(sequence);
        }
        catch (IOException e) {
            throw new ResponseIOException(e);
        }
    }

    public void write(byte[] array) {
        try {
            this.httpServletResponse.getOutputStream().write(array);
        }
        catch (IOException e) {
            throw new ResponseIOException(e);
        }
    }

    public void write(byte[] array, int offset, int length) {
        try {
            this.httpServletResponse.getOutputStream().write(array, offset, length);
        }
        catch (IOException e) {
            throw new ResponseIOException(e);
        }
    }

    public void setStatus(int sc) {
        this.httpServletResponse.setStatus(sc);
    }

    public void sendError(int sc, String msg) {
        try {
            if (msg == null) {
                this.httpServletResponse.sendError(sc);
            } else {
                this.httpServletResponse.sendError(sc, msg);
            }
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public String encodeURL(CharSequence url) {
        String encodedUrl;
        Args.notNull((Object)url, (String)"url");
        UrlRenderer urlRenderer = this.getUrlRenderer();
        Url originalUrl = Url.parse((CharSequence)url);
        String fullUrl = urlRenderer.renderFullUrl(originalUrl);
        String encodedFullUrl = this.httpServletResponse.encodeURL(fullUrl);
        if (originalUrl.isFull()) {
            encodedUrl = encodedFullUrl;
        } else if (fullUrl.equals(encodedFullUrl)) {
            encodedUrl = url.toString();
        } else {
            Url _encoded = Url.parse((CharSequence)encodedFullUrl);
            encodedUrl = urlRenderer.renderRelativeUrl(_encoded);
        }
        return encodedUrl;
    }

    private UrlRenderer getUrlRenderer() {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle == null) {
            return new UrlRenderer((Request)this.webRequest);
        }
        return requestCycle.getUrlRenderer();
    }

    public String encodeRedirectURL(CharSequence url) {
        String encodedUrl;
        Args.notNull((Object)url, (String)"url");
        UrlRenderer urlRenderer = this.getUrlRenderer();
        Url originalUrl = Url.parse((CharSequence)url);
        String fullUrl = urlRenderer.renderFullUrl(originalUrl);
        String encodedFullUrl = this.httpServletResponse.encodeRedirectURL(fullUrl);
        if (originalUrl.isFull()) {
            encodedUrl = encodedFullUrl;
        } else if (fullUrl.equals(encodedFullUrl)) {
            encodedUrl = url.toString();
        } else {
            Url _encoded = Url.parse((CharSequence)encodedFullUrl);
            encodedUrl = urlRenderer.renderRelativeUrl(_encoded);
        }
        return encodedUrl;
    }

    public void sendRedirect(String url) {
        try {
            this.redirect = true;
            url = this.encodeRedirectURL(url);
            this.disableCaching();
            if (this.webRequest.isAjax()) {
                this.setHeader("Ajax-Location", url);
                this.setContentType("text/xml;charset=" + this.webRequest.getContainerRequest().getCharacterEncoding());
                this.httpServletResponse.getWriter().write("<ajax-response><redirect><![CDATA[" + url + "]]></redirect></ajax-response>");
            } else {
                this.httpServletResponse.sendRedirect(url);
            }
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void flush() {
        try {
            HttpServletRequest httpServletRequest = this.webRequest.getContainerRequest();
            if (!httpServletRequest.isAsyncStarted()) {
                this.httpServletResponse.flushBuffer();
            }
        }
        catch (IOException e) {
            throw new ResponseIOException(e);
        }
    }

    public void reset() {
        super.reset();
        this.httpServletResponse.reset();
        this.redirect = false;
    }

    public HttpServletResponse getContainerResponse() {
        return this.httpServletResponse;
    }
}

