/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Objects;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.ISubresourceHeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.CrossOrigin;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.value.AttributeMap;

public abstract class AbstractJavaScriptReferenceHeaderItem
extends JavaScriptHeaderItem
implements ISubresourceHeaderItem {
    private boolean async;
    private boolean defer;
    private String charset;
    private CrossOrigin crossOrigin;
    private String integrity;

    public boolean isAsync() {
        return this.async;
    }

    public AbstractJavaScriptReferenceHeaderItem setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public boolean isDefer() {
        return this.defer;
    }

    public AbstractJavaScriptReferenceHeaderItem setDefer(boolean defer) {
        this.defer = defer;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public AbstractJavaScriptReferenceHeaderItem setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public CrossOrigin getCrossOrigin() {
        return this.crossOrigin;
    }

    @Override
    public AbstractJavaScriptReferenceHeaderItem setCrossOrigin(CrossOrigin crossOrigin) {
        this.crossOrigin = crossOrigin;
        return this;
    }

    @Override
    public String getIntegrity() {
        return this.integrity;
    }

    @Override
    public AbstractJavaScriptReferenceHeaderItem setIntegrity(String integrity) {
        this.integrity = integrity;
        return this;
    }

    protected final void internalRenderJavaScriptReference(Response response, String url) {
        Args.notEmpty((String)url, (String)"url");
        AttributeMap attributes = new AttributeMap();
        attributes.putAttribute("type", (CharSequence)"text/javascript");
        attributes.putAttribute("id", (CharSequence)this.getId());
        attributes.putAttribute("defer", this.defer);
        attributes.putAttribute("charset", (CharSequence)this.charset);
        attributes.putAttribute("async", this.async);
        attributes.putAttribute("src", (CharSequence)url);
        attributes.putAttribute("nonce", (CharSequence)this.getNonce());
        attributes.putAttribute("crossOrigin", this.getCrossOrigin() == null ? null : this.getCrossOrigin().getRealName());
        attributes.putAttribute("integrity", (CharSequence)this.getIntegrity());
        JavaScriptUtils.writeScript(response, attributes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractJavaScriptReferenceHeaderItem that = (AbstractJavaScriptReferenceHeaderItem)o;
        return this.async == that.async && this.defer == that.defer && Objects.equals(this.charset, that.charset);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.async ? 1 : 0);
        result = 31 * result + (this.defer ? 1 : 0);
        result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
        return result;
    }
}

