/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.feedback;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Session;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class FeedbackCollector {
    private final Component component;
    private boolean includeSession = true;
    private boolean recursive = true;

    public FeedbackCollector() {
        this(null, true);
    }

    public FeedbackCollector(Component component) {
        this(component, false);
    }

    public FeedbackCollector(Component component, boolean includeSession) {
        this.component = component;
        this.includeSession = includeSession;
    }

    public final FeedbackCollector setIncludeSession(boolean value) {
        this.includeSession = value;
        return this;
    }

    public final FeedbackCollector setRecursive(boolean value) {
        this.recursive = value;
        return this;
    }

    public final List<FeedbackMessage> collect() {
        return this.collect(IFeedbackMessageFilter.ALL);
    }

    public final List<FeedbackMessage> collect(final IFeedbackMessageFilter filter) {
        final ArrayList<FeedbackMessage> messages = new ArrayList<FeedbackMessage>();
        if (this.includeSession && Session.exists()) {
            messages.addAll(Session.get().getFeedbackMessages().messages(filter));
        }
        if (this.component != null && this.component.hasFeedbackMessage()) {
            messages.addAll(this.component.getFeedbackMessages().messages(filter));
        }
        if (this.component != null && this.recursive && this.component instanceof MarkupContainer) {
            ((MarkupContainer)this.component).visitChildren(new IVisitor<Component, Void>(){

                public void component(Component object, IVisit<Void> visit) {
                    if (!FeedbackCollector.this.shouldRecurseInto(object)) {
                        visit.dontGoDeeper();
                        return;
                    }
                    if (object.hasFeedbackMessage()) {
                        messages.addAll(object.getFeedbackMessages().messages(filter));
                    }
                }
            });
        }
        return messages;
    }

    protected boolean shouldRecurseInto(Component component) {
        return true;
    }
}

