/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.wicket.Application;
import org.apache.wicket.ChildToDequeueType;
import org.apache.wicket.Component;
import org.apache.wicket.ComponentQueue;
import org.apache.wicket.DequeueContext;
import org.apache.wicket.DequeueTagAction;
import org.apache.wicket.IQueueRegion;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.OutputMarkupContainerClassNameBehavior;
import org.apache.wicket.core.util.string.ComponentStrings;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupFactory;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.MarkupType;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.markup.resolver.ComponentResolvers;
import org.apache.wicket.model.IComponentInheritedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.settings.DebugSettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.ClassVisitFilter;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitFilter;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarkupContainer
extends Component
implements Iterable<Component> {
    private static final long serialVersionUID = 1L;
    private static final int INITIAL_CHILD_LIST_CAPACITY = 12;
    static final int MAPIFY_THRESHOLD = 24;
    private static final Logger log = LoggerFactory.getLogger(MarkupContainer.class);
    private static final MetaDataKey<LinkedList<RemovedChild>> REMOVALS_KEY = new MetaDataKey<LinkedList<RemovedChild>>(){
        private static final long serialVersionUID = 1L;
    };
    private transient int modCounter = 0;
    private Object children;
    private transient ComponentQueue queue;

    public MarkupContainer(String id) {
        this(id, null);
    }

    public MarkupContainer(String id, IModel<?> model) {
        super(id, model);
    }

    public MarkupContainer add(Component ... children) {
        for (Component child : children) {
            Component previousChild;
            Args.notNull((Object)child, (String)"child");
            if (this == child) {
                throw new IllegalArgumentException(this.exceptionMessage("Trying to add this component to itself."));
            }
            for (MarkupContainer parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (child != parent) continue;
                String msg = "You can not add a component's parent as child to the component (loop): Component: " + this.toString(false) + "; parent == child: " + parent.toString(false);
                if (child instanceof Border.BorderBodyContainer) {
                    msg = msg + ". Please consider using Border.addToBorder(new " + Classes.simpleName(this.getClass()) + "(\"" + this.getId() + "\", ...) instead of add(...)";
                }
                throw new WicketRuntimeException(msg);
            }
            this.checkHierarchyChange(child);
            if (log.isDebugEnabled()) {
                log.debug("Add " + child.getId() + " to " + this);
            }
            if ((previousChild = this.children_put(child)) != null && previousChild != child) {
                throw new IllegalArgumentException(this.exceptionMessage("A child '" + previousChild.getClass().getSimpleName() + "' with id '" + child.getId() + "' already exists"));
            }
            this.addedComponent(child);
        }
        return this;
    }

    public MarkupContainer addOrReplace(Component ... children) {
        for (Component child : children) {
            Args.notNull((Object)child, (String)"child");
            this.checkHierarchyChange(child);
            if (this.get(child.getId()) == null) {
                this.add(child);
                continue;
            }
            this.replace(child);
        }
        return this;
    }

    public final boolean autoAdd(Component component, MarkupStream markupStream) {
        Args.notNull((Object)component, (String)"component");
        component.setAuto(true);
        if (markupStream != null) {
            component.setMarkup(markupStream.getMarkupFragment());
        }
        this.children_remove(component.getId());
        this.add(component);
        return true;
    }

    public boolean contains(Component component, boolean recurse) {
        Args.notNull((Object)component, (String)"component");
        if (recurse) {
            Component current = component;
            while (current != null) {
                MarkupContainer parent = current.getParent();
                if (parent == this) {
                    return true;
                }
                current = parent;
            }
            return false;
        }
        return component.getParent() == this;
    }

    @Override
    public final Component get(String path) {
        if (Strings.isEmpty((String)path)) {
            return this;
        }
        MarkupContainer container = this;
        String id = Strings.firstPathComponent((String)path, (char)':');
        while ("..".equals(id)) {
            if ((container = container.getParent()) == null) {
                return null;
            }
            path = path.length() == id.length() ? "" : path.substring(id.length() + 1);
            id = Strings.firstPathComponent((String)path, (char)':');
        }
        if (Strings.isEmpty((String)id)) {
            return container;
        }
        Component child = container.children_get(id);
        if (child != null) {
            String path2 = Strings.afterFirstPathComponent((String)path, (char)':');
            return child.get(path2);
        }
        return null;
    }

    public MarkupStream getAssociatedMarkupStream(boolean throwException) {
        Markup markup = this.getAssociatedMarkup();
        if (markup != null) {
            return new MarkupStream(markup);
        }
        if (throwException) {
            throw new MarkupNotFoundException("Markup of type '" + this.getMarkupType().getExtension() + "' for component '" + this.getClass().getName() + "' not found. Enable debug messages for org.apache.wicket.util.resource to get a list of all filenames tried.: " + this.toString());
        }
        return null;
    }

    public Markup getAssociatedMarkup() {
        try {
            Markup markup = MarkupFactory.get().getMarkup(this, false);
            if (markup != null && markup != Markup.NO_MARKUP) {
                return markup;
            }
            return null;
        }
        catch (MarkupException ex) {
            throw ex;
        }
        catch (MarkupNotFoundException ex) {
            throw ex;
        }
        catch (WicketRuntimeException ex) {
            throw new MarkupNotFoundException(this.exceptionMessage("Markup of type '" + this.getMarkupType().getExtension() + "' for component '" + this.getClass().getName() + "' not found. Enable debug messages for org.apache.wicket.util.resource to get a list of all filenames tried"), ex);
        }
    }

    public IMarkupFragment getMarkup(Component child) {
        return this.getMarkupSourcingStrategy().getMarkup(this, child);
    }

    public MarkupType getMarkupType() {
        MarkupContainer parent = this.getParent();
        if (parent != null) {
            return parent.getMarkupType();
        }
        return null;
    }

    public void internalAdd(Component child) {
        if (log.isDebugEnabled()) {
            log.debug("internalAdd " + child.getId() + " to " + this);
        }
        this.children_put(child);
        this.addedComponent(child);
    }

    @Override
    public Iterator<Component> iterator() {
        class MarkupChildIterator
        implements Iterator<Component> {
            private int indexInRemovalsSinceLastUpdate;
            private int expectedModCounter = -1;
            private Component currentComponent = null;
            private Iterator<Component> internalIterator = null;

            MarkupChildIterator() {
            }

            @Override
            public boolean hasNext() {
                this.refreshInternalIteratorIfNeeded();
                return this.internalIterator.hasNext();
            }

            @Override
            public Component next() {
                this.refreshInternalIteratorIfNeeded();
                this.currentComponent = this.internalIterator.next();
                return this.currentComponent;
            }

            @Override
            public void remove() {
                MarkupContainer.this.remove(this.currentComponent);
                this.refreshInternalIteratorIfNeeded();
            }

            private void refreshInternalIteratorIfNeeded() {
                if (this.expectedModCounter >= MarkupContainer.this.modCounter) {
                    return;
                }
                if (MarkupContainer.this.children == null) {
                    this.internalIterator = Collections.emptyIterator();
                } else if (MarkupContainer.this.children instanceof Component) {
                    this.internalIterator = Collections.singleton((Component)MarkupContainer.this.children).iterator();
                } else if (MarkupContainer.this.children instanceof List) {
                    List childrenList = (List)MarkupContainer.this.children();
                    this.internalIterator = childrenList.iterator();
                } else {
                    Map childrenMap = (Map)MarkupContainer.this.children();
                    this.internalIterator = childrenMap.values().iterator();
                }
                this.currentComponent = this.findLastExistingChildAlreadyReturned(this.currentComponent);
                this.expectedModCounter = MarkupContainer.this.modCounter;
                if (this.currentComponent != null) {
                    while (this.internalIterator.hasNext() && this.internalIterator.next() != this.currentComponent) {
                    }
                }
            }

            private Component findLastExistingChildAlreadyReturned(Component current) {
                if (current == null) {
                    this.indexInRemovalsSinceLastUpdate = 0;
                } else {
                    LinkedList<RemovedChild> removals = MarkupContainer.this.removals_get();
                    if (removals != null) {
                        block0: while (current != null) {
                            for (int i = this.indexInRemovalsSinceLastUpdate; i < removals.size(); ++i) {
                                RemovedChild removal = removals.get(i);
                                if (removal.removedChild != current && removal.removedChild != null) continue;
                                current = removal.previousSibling;
                                continue block0;
                            }
                        }
                        this.indexInRemovalsSinceLastUpdate = removals.size();
                    }
                }
                return current;
            }
        }
        return new MarkupChildIterator();
    }

    public final Iterator<Component> iterator(Comparator<Component> comparator) {
        List<Component> sorted = this.copyChildren();
        Collections.sort(sorted, comparator);
        return sorted.iterator();
    }

    public MarkupContainer remove(Component component) {
        this.checkHierarchyChange(component);
        Args.notNull((Object)component, (String)"component");
        this.children_remove(component.getId());
        this.removedComponent(component);
        return this;
    }

    public MarkupContainer remove(String id) {
        Args.notNull((Object)id, (String)"id");
        Component component = this.get(id);
        if (component == null) {
            throw new WicketRuntimeException("Unable to find a component with id '" + id + "' to remove");
        }
        this.remove(component);
        return this;
    }

    public MarkupContainer removeAll() {
        if (this.children != null) {
            this.addStateChange();
            for (Component child : this) {
                child.internalOnRemove();
                child.detach();
                child.setParent(null);
            }
            this.children = null;
            this.removals_add(null, null);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renderAssociatedMarkup(String openTagName) {
        ComponentTag associatedMarkupOpenTag;
        MarkupStream associatedMarkupStream = new MarkupStream(this.getMarkup(null));
        MarkupElement elem = associatedMarkupStream.get();
        if (!(elem instanceof ComponentTag)) {
            associatedMarkupStream.throwMarkupException("Expected the open tag. Markup for a " + openTagName + " component must begin a tag like '<wicket:" + openTagName + ">'");
        }
        if (!(associatedMarkupOpenTag = (ComponentTag)elem).isOpen() || !(associatedMarkupOpenTag instanceof WicketTag)) {
            associatedMarkupStream.throwMarkupException("Markup for a " + openTagName + " component must begin a tag like '<wicket:" + openTagName + ">'");
        }
        try {
            this.setIgnoreAttributeModifier(true);
            boolean outputClassName = this.getApplication().getDebugSettings().isOutputMarkupContainerClassName();
            if (outputClassName) {
                associatedMarkupOpenTag.addBehavior(OutputMarkupContainerClassNameBehavior.INSTANCE);
            }
            this.renderComponentTag(associatedMarkupOpenTag);
            associatedMarkupStream.next();
            this.renderComponentTagBody(associatedMarkupStream, associatedMarkupOpenTag);
            this.renderClosingComponentTag(associatedMarkupStream, associatedMarkupOpenTag, false);
        }
        finally {
            this.setIgnoreAttributeModifier(false);
        }
    }

    public MarkupContainer replace(Component child) {
        Args.notNull((Object)child, (String)"child");
        this.checkHierarchyChange(child);
        if (log.isDebugEnabled()) {
            log.debug("Replacing " + child.getId() + " in " + this);
        }
        if (child.getParent() != this) {
            Component replaced = this.children_put(child);
            if (replaced == null) {
                throw new WicketRuntimeException(this.exceptionMessage("Cannot replace a component which has not been added: id='" + child.getId() + "', component=" + child));
            }
            this.removedComponent(replaced);
            child.setMarkupId(replaced);
            this.addedComponent(child);
        }
        return this;
    }

    @Override
    public MarkupContainer setDefaultModel(final IModel<?> model) {
        final IModel<?> previous = this.getModelImpl();
        super.setDefaultModel(model);
        if (previous instanceof IComponentInheritedModel) {
            this.visitChildren(new IVisitor<Component, Void>(){

                public void component(Component component, IVisit<Void> visit) {
                    IModel<?> compModel = component.getDefaultModel();
                    if (compModel instanceof IWrapModel) {
                        compModel = ((IWrapModel)compModel).getWrappedModel();
                    }
                    if (compModel == previous) {
                        component.setDefaultModel(null);
                    } else if (compModel == model) {
                        component.modelChanged();
                    }
                }
            });
        }
        return this;
    }

    public int size() {
        return this.children_size();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean detailed) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[').append(Classes.simpleName(this.getClass())).append(' ');
        buffer.append(super.toString(detailed));
        if (detailed && this.children_size() != 0) {
            buffer.append(", children = ");
            boolean first = true;
            for (Component child : this) {
                if (first) {
                    buffer.append(' ');
                    first = false;
                }
                buffer.append(child.toString());
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    public final <S extends Component, R> R visitChildren(Class<?> clazz, IVisitor<S, R> visitor) {
        return (R)Visits.visitChildren((Iterable)this, visitor, (IVisitFilter)new ClassVisitFilter(clazz));
    }

    public final <R> R visitChildren(IVisitor<Component, R> visitor) {
        return (R)Visits.visitChildren((Iterable)this, visitor);
    }

    private void addedComponent(Component child) {
        Page page;
        Args.notNull((Object)child, (String)"child");
        MarkupContainer parent = child.getParent();
        if (parent != null && parent != this) {
            parent.remove(child);
        }
        child.setParent(this);
        DebugSettings debugSettings = Application.get().getDebugSettings();
        if (debugSettings.isLinePreciseReportingOnAddComponentEnabled() && debugSettings.getComponentUseCheck()) {
            child.setMetaData(ADDED_AT_KEY, ComponentStrings.toString(child, new MarkupException("added")));
        }
        if ((page = this.findPage()) != null) {
            page.componentAdded(child);
            if (page.isInitialized()) {
                child.internalInitialize();
            }
        }
        if (this.isPreparedForRender()) {
            child.beforeRender();
        }
    }

    @Override
    public final void internalInitialize() {
        super.fireInitialize();
        this.visitChildren(new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                component.fireInitialize();
            }
        });
    }

    private <T> T children() {
        return (T)this.children;
    }

    private Component children_get(String childId) {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof Component) {
            Component child = (Component)this.children();
            return child.getId().equals(childId) ? child : null;
        }
        if (this.children instanceof List) {
            List kids = (List)this.children();
            for (Component child : kids) {
                if (!child.getId().equals(childId)) continue;
                return child;
            }
            return null;
        }
        Map kids = (Map)this.children();
        return (Component)kids.get(childId);
    }

    private void children_remove(String childId) {
        LinkedMap childrenMap;
        if (this.children instanceof Component) {
            Component oldChild = (Component)this.children();
            if (oldChild.getId().equals(childId)) {
                this.children = null;
                this.removals_add(oldChild, null);
            }
        } else if (this.children instanceof List) {
            List childrenList = (List)this.children();
            Iterator it = childrenList.iterator();
            Component prevChild = null;
            while (it.hasNext()) {
                Component child = (Component)it.next();
                if (child.getId().equals(childId)) {
                    it.remove();
                    this.removals_add(child, prevChild);
                    if (childrenList.size() == 1) {
                        this.children = childrenList.get(0);
                    }
                    return;
                }
                prevChild = child;
            }
        } else if (this.children instanceof LinkedMap && (childrenMap = (LinkedMap)this.children()).containsKey((Object)childId)) {
            String prevSiblingId = (String)childrenMap.previousKey((Object)childId);
            Component oldChild = (Component)childrenMap.remove((Object)childId);
            this.removals_add(oldChild, (Component)childrenMap.get((Object)prevSiblingId));
            if (childrenMap.size() == 1) {
                this.children = childrenMap.values().iterator().next();
            }
        }
    }

    private int children_size() {
        if (this.children == null) {
            return 0;
        }
        if (this.children instanceof Component) {
            return 1;
        }
        if (this.children instanceof List) {
            List kids = (List)this.children();
            return kids.size();
        }
        return ((Map)this.children).size();
    }

    private Component children_put(Component child) {
        if (this.children == null) {
            this.children = child;
            ++this.modCounter;
            return null;
        }
        if (this.children instanceof Component) {
            Component oldChild = (Component)this.children();
            if (oldChild.getId().equals(child.getId())) {
                this.children = child;
                return oldChild;
            }
            Component originalChild = (Component)this.children();
            ArrayList<Component> newChildren = new ArrayList<Component>(12);
            newChildren.add(originalChild);
            newChildren.add(child);
            this.children = newChildren;
            ++this.modCounter;
            return null;
        }
        if (this.children instanceof List) {
            List childrenList = (List)this.children();
            for (int i = 0; i < childrenList.size(); ++i) {
                Component curChild = (Component)childrenList.get(i);
                if (!curChild.getId().equals(child.getId())) continue;
                return childrenList.set(i, child);
            }
            ++this.modCounter;
            if (childrenList.size() < 24) {
                childrenList.add(child);
            } else {
                LinkedMap newChildren = new LinkedMap(48);
                for (Component curChild : childrenList) {
                    newChildren.put(curChild.getId(), curChild);
                }
                newChildren.put(child.getId(), child);
                this.children = newChildren;
            }
            return null;
        }
        Map childrenMap = (Map)this.children();
        Component oldChild = childrenMap.put(child.getId(), child);
        if (oldChild == null) {
            ++this.modCounter;
        }
        return oldChild;
    }

    private LinkedList<RemovedChild> removals_get() {
        return this.getRequestFlag((short)16384) ? (LinkedList)this.getMetaData((MetaDataKey)REMOVALS_KEY) : null;
    }

    private void removals_set(LinkedList<RemovedChild> removals) {
        this.setRequestFlag((short)16384, removals != null);
        this.setMetaData(REMOVALS_KEY, removals);
    }

    private void removals_clear() {
        if (this.getRequestFlag((short)16384)) {
            this.removals_set(null);
        }
    }

    private void removals_add(Component removedChild, Component prevSibling) {
        ++this.modCounter;
        LinkedList<RemovedChild> removals = this.removals_get();
        if (removals == null) {
            removals = new LinkedList();
            this.removals_set(removals);
        }
        removals.add(new RemovedChild(removedChild, prevSibling));
    }

    private void removedComponent(Component component) {
        Page page = component.findPage();
        if (page != null) {
            page.componentRemoved(component);
        }
        component.detach();
        component.internalOnRemove();
        component.setParent(null);
    }

    protected boolean renderNext(MarkupStream markupStream) {
        MarkupElement element = markupStream.get();
        if (element instanceof ComponentTag && !markupStream.atCloseTag()) {
            ComponentTag tag = (ComponentTag)element;
            if (tag instanceof WicketTag && ((WicketTag)tag).isFragmentTag()) {
                return false;
            }
            String id = tag.getId();
            Component component = this.get(id);
            if (component == null) {
                component = ComponentResolvers.resolve(this, markupStream, tag, null);
                if (component != null && component.getParent() == null) {
                    this.autoAdd(component, markupStream);
                } else if (component != null) {
                    component.setMarkup(markupStream.getMarkupFragment());
                }
            }
            if (component != null) {
                component.render();
            } else {
                if (tag.getFlag(32)) {
                    if (this.canRenderRawTag(tag)) {
                        this.getResponse().write(element.toCharSequence());
                    }
                    return true;
                }
                this.throwException(markupStream, tag);
            }
        } else {
            if (this.canRenderRawTag(element)) {
                this.getResponse().write(element.toCharSequence());
            }
            return true;
        }
        return false;
    }

    private boolean canRenderRawTag(MarkupElement tag) {
        boolean isWicketTag = tag instanceof WicketTag;
        boolean stripTag = isWicketTag ? Application.get().getMarkupSettings().getStripWicketTags() : false;
        return !stripTag;
    }

    private void throwException(MarkupStream markupStream, ComponentTag tag) {
        String id = tag.getId();
        if (tag instanceof WicketTag) {
            if (((WicketTag)tag).isChildTag()) {
                markupStream.throwMarkupException("Found " + tag.toString() + " but no <wicket:extend>. Container: " + this.toString());
            } else {
                markupStream.throwMarkupException("Failed to handle: " + tag.toString() + ". It might be that no resolver has been registered to handle this special tag.  But it also could be that you declared wicket:id=" + id + " in your markup, but that you either did not add the component to your page at all, or that the hierarchy does not match. Container: " + this.toString());
            }
        }
        List<String> names = this.findSimilarComponents(id);
        StringBuilder msg = new StringBuilder(500);
        msg.append("Unable to find component with id '");
        msg.append(id);
        msg.append("' in ");
        msg.append(this.toString());
        msg.append("\n\tExpected: '");
        msg.append(this.getPageRelativePath());
        msg.append(':');
        msg.append(id);
        msg.append("'.\n\tFound with similar names: '");
        msg.append(Strings.join((String)"', ", names));
        msg.append('\'');
        log.error(msg.toString());
        markupStream.throwMarkupException(msg.toString());
    }

    private List<String> findSimilarComponents(final String id) {
        final ArrayList names = Generics.newArrayList();
        Page page = this.findPage();
        if (page != null) {
            page.visitChildren(new IVisitor<Component, Void>(){

                public void component(Component component, IVisit<Void> visit) {
                    if (Strings.getLevenshteinDistance((CharSequence)id.toLowerCase(Locale.ROOT), (CharSequence)component.getId().toLowerCase(Locale.ROOT)) < 3) {
                        names.add(component.getPageRelativePath());
                    }
                }
            });
        }
        return names;
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.renderComponentTagBody(markupStream, openTag);
    }

    @Override
    protected void onRender() {
        this.internalRenderComponent();
    }

    private void renderComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        ComponentTag origOpenTag;
        if (markupStream != null && markupStream.getCurrentIndex() > 0 && (origOpenTag = (ComponentTag)markupStream.get(markupStream.getCurrentIndex() - 1)).isOpenClose()) {
            return;
        }
        boolean render = openTag.requiresCloseTag();
        if (!render) {
            boolean bl = render = !openTag.hasNoCloseTag();
        }
        if (render) {
            this.renderAll(markupStream, openTag);
        }
    }

    protected final void renderAll(MarkupStream markupStream, ComponentTag openTag) {
        while (markupStream.isCurrentIndexInsideTheStream() && (openTag == null || !markupStream.get().closes(openTag))) {
            int index = markupStream.getCurrentIndex();
            boolean rawMarkup = this.renderNext(markupStream);
            markupStream.setCurrentIndex(index);
            if (rawMarkup) {
                markupStream.next();
                continue;
            }
            if (!markupStream.getTag().isClose()) {
                markupStream.skipComponent();
                continue;
            }
            throw new WicketRuntimeException("Ups. This should never happen. " + markupStream.toString());
        }
    }

    @Override
    void removeChildren() {
        super.removeChildren();
        for (Component component : this) {
            component.internalOnRemove();
        }
    }

    @Override
    void detachChildren() {
        super.detachChildren();
        for (Component component : this) {
            component.detach();
        }
    }

    @Override
    void internalMarkRendering(boolean setRenderingFlag) {
        super.internalMarkRendering(setRenderingFlag);
        for (Component child : this) {
            child.internalMarkRendering(setRenderingFlag);
        }
    }

    private List<Component> copyChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        if (this.children instanceof Component) {
            return Collections.singletonList((Component)this.children);
        }
        if (this.children instanceof List) {
            return new ArrayList<Component>((List)this.children);
        }
        return new ArrayList<Component>(((Map)this.children).values());
    }

    @Override
    void onBeforeRenderChildren() {
        super.onBeforeRenderChildren();
        try {
            for (Component child : this) {
                if (child.getParent() != this) continue;
                child.beforeRender();
            }
        }
        catch (RuntimeException ex) {
            if (ex instanceof WicketRuntimeException) {
                throw ex;
            }
            throw new WicketRuntimeException("Error attaching this container for rendering: " + this, ex);
        }
    }

    @Override
    void onEnabledStateChanged() {
        super.onEnabledStateChanged();
        this.visitChildren(new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                component.clearEnabledInHierarchyCache();
            }
        });
    }

    @Override
    void onVisibleStateChanged() {
        super.onVisibleStateChanged();
        this.visitChildren(new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                component.clearVisibleInHierarchyCache();
            }
        });
    }

    @Override
    protected void onDetach() {
        super.onDetach();
        ++this.modCounter;
        this.removals_clear();
        if (this.queue != null && !this.queue.isEmpty() && this.hasBeenRendered()) {
            throw new WicketRuntimeException(String.format("Detach called on component with id '%s' while it had a non-empty queue: %s", this.getId(), this.queue));
        }
    }

    public MarkupContainer queue(Component ... components) {
        if (this.queue == null) {
            this.queue = new ComponentQueue();
        }
        this.queue.add(components);
        Page page = this.findPage();
        if (page != null) {
            this.dequeue();
        }
        return this;
    }

    public void dequeue() {
        if (this instanceof IQueueRegion) {
            DequeueContext dequeue = this.newDequeueContext();
            this.dequeuePreamble(dequeue);
        } else {
            boolean hasQueuedChildren;
            MarkupContainer queueRegion = (MarkupContainer)((Object)this.findParent(IQueueRegion.class));
            if (queueRegion == null) {
                return;
            }
            MarkupContainer anchestor = this;
            boolean bl = hasQueuedChildren = !this.isQueueEmpty();
            while (!hasQueuedChildren && anchestor != queueRegion) {
                hasQueuedChildren = !(anchestor = anchestor.getParent()).isQueueEmpty();
            }
            if (hasQueuedChildren && !queueRegion.getRequestFlag((short)128)) {
                queueRegion.dequeue();
            }
        }
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.dequeue();
    }

    private boolean isQueueEmpty() {
        return this.queue == null || this.queue.isEmpty();
    }

    private boolean isQueueRegion() {
        return IQueueRegion.class.isInstance(this);
    }

    protected void dequeuePreamble(DequeueContext dequeue) {
        if (this.getRequestFlag((short)128)) {
            throw new IllegalStateException("This container is already dequeing: " + this);
        }
        this.setRequestFlag((short)128, true);
        try {
            if (dequeue == null) {
                return;
            }
            if (dequeue.peekTag() != null) {
                this.dequeue(dequeue);
            }
        }
        finally {
            this.setRequestFlag((short)128, false);
        }
    }

    public void dequeue(DequeueContext dequeue) {
        while (dequeue.isAtOpenOrOpenCloseTag()) {
            ComponentTag tag = dequeue.takeTag();
            Component child = this.findChildComponent(tag);
            if (child == null) {
                child = dequeue.findComponentToDequeue(tag);
                if (child == null && tag.getAutoComponentFactory() != null) {
                    ComponentTag.IAutoComponentFactory autoComponentFactory = tag.getAutoComponentFactory();
                    child = autoComponentFactory.newComponent(this, tag);
                }
                if (child != null) {
                    this.addDequeuedComponent(child, tag);
                }
            }
            if (!tag.isOpen() || tag.hasNoCloseTag()) continue;
            this.dequeueChild(child, tag, dequeue);
        }
    }

    protected Component findChildComponent(ComponentTag tag) {
        return this.get(tag.getId());
    }

    private void dequeueChild(Component child, ComponentTag tag, DequeueContext dequeue) {
        MarkupContainer childContainer;
        ChildToDequeueType childType = ChildToDequeueType.fromChild(child);
        if (childType == ChildToDequeueType.QUEUE_REGION || childType == ChildToDequeueType.BORDER) {
            ((IQueueRegion)((Object)child)).dequeue();
        }
        if (childType == ChildToDequeueType.BORDER) {
            childContainer = (Border)child;
            Border.BorderBodyContainer body = childContainer.getBodyContainer();
            this.dequeueChildrenContainer(dequeue, body);
        }
        if (childType == ChildToDequeueType.MARKUP_CONTAINER) {
            childContainer = (MarkupContainer)child;
            this.dequeueChildrenContainer(dequeue, childContainer);
        }
        if (childType == ChildToDequeueType.NULL || childType == ChildToDequeueType.QUEUE_REGION) {
            dequeue.skipToCloseTag();
        }
        ComponentTag close = dequeue.takeTag();
        do {
            if (close == null || !close.closes(tag)) continue;
            return;
        } while ((close = dequeue.takeTag()) != null);
        throw new IllegalStateException(String.format("Could not find the closing tag for '%s'", tag));
    }

    private void dequeueChildrenContainer(DequeueContext dequeue, MarkupContainer child) {
        dequeue.pushContainer(child);
        child.dequeue(dequeue);
        dequeue.popContainer();
    }

    public DequeueContext newDequeueContext() {
        IMarkupFragment markup = this.getRegionMarkup();
        if (markup == null) {
            return null;
        }
        return new DequeueContext(markup, this, false);
    }

    public IMarkupFragment getRegionMarkup() {
        return this.getAssociatedMarkup();
    }

    protected DequeueTagAction canDequeueTag(ComponentTag tag) {
        if (tag instanceof WicketTag) {
            WicketTag wicketTag = (WicketTag)tag;
            if (wicketTag.isContainerTag()) {
                return DequeueTagAction.DEQUEUE;
            }
            if (wicketTag.getAutoComponentFactory() != null) {
                return DequeueTagAction.DEQUEUE;
            }
            if (wicketTag.isFragmentTag()) {
                return DequeueTagAction.SKIP;
            }
            if (wicketTag.isChildTag()) {
                return DequeueTagAction.IGNORE;
            }
            if (wicketTag.isHeadTag()) {
                return DequeueTagAction.SKIP;
            }
            if (wicketTag.isLinkTag()) {
                return DequeueTagAction.DEQUEUE;
            }
            return null;
        }
        if (tag.isAutoComponentTag() && tag.getId().startsWith("label_attr")) {
            return DequeueTagAction.IGNORE;
        }
        return DequeueTagAction.DEQUEUE;
    }

    public Component findComponentToDequeue(ComponentTag tag) {
        return this.queue == null ? null : this.queue.remove(tag.getId());
    }

    protected void addDequeuedComponent(Component component, ComponentTag tag) {
        this.add(component);
    }

    public Stream<Component> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<Component> streamChildren() {
        class ChildrenIterator<C>
        implements Iterator<C> {
            private Iterator<C> currentIterator;
            private Deque<Iterator<C>> iteratorStack = new ArrayDeque<Iterator<C>>();

            private ChildrenIterator(Iterator<C> iterator) {
                this.currentIterator = iterator;
            }

            @Override
            public boolean hasNext() {
                while (!this.currentIterator.hasNext() && !this.iteratorStack.isEmpty()) {
                    this.currentIterator = this.iteratorStack.pop();
                }
                return this.currentIterator.hasNext();
            }

            @Override
            public C next() {
                C child = this.currentIterator.next();
                if (child instanceof Iterable) {
                    this.iteratorStack.push(this.currentIterator);
                    this.currentIterator = ((Iterable)child).iterator();
                }
                return child;
            }
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new ChildrenIterator<Component>(this.iterator()), 0), false);
    }

    private static class RemovedChild
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final transient Component removedChild;
        private final transient Component previousSibling;

        private RemovedChild(Component removedChild, Component previousSibling) {
            this.removedChild = removedChild;
            this.previousSibling = previousSibling;
        }
    }
}

