/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import java.util.Map;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class SpringWebApplicationFactory
implements IWebApplicationFactory {
    private ConfigurableWebApplicationContext webApplicationContext;

    protected final String getContextConfigLocation(WicketFilter filter) {
        FilterConfig filterConfig = filter.getFilterConfig();
        String contextConfigLocation = filterConfig.getInitParameter("contextConfigLocation");
        if (contextConfigLocation == null) {
            ServletContext servletContext = filterConfig.getServletContext();
            contextConfigLocation = servletContext.getInitParameter("contextConfigLocation");
        }
        return contextConfigLocation;
    }

    protected ConfigurableWebApplicationContext newApplicationContext() {
        return new XmlWebApplicationContext();
    }

    public WebApplication createApplication(WicketFilter filter) {
        ServletContext servletContext = filter.getFilterConfig().getServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (this.getContextConfigLocation(filter) != null) {
            applicationContext = this.createWebApplicationContext(applicationContext, filter);
        }
        String beanName = filter.getFilterConfig().getInitParameter("applicationBean");
        return this.createApplication((ApplicationContext)applicationContext, beanName);
    }

    private WebApplication createApplication(ApplicationContext applicationContext, String beanName) {
        WebApplication application;
        if (beanName != null) {
            application = (WebApplication)applicationContext.getBean(beanName);
            if (application == null) {
                throw new IllegalArgumentException("Unable to find WebApplication bean with name [" + beanName + "]");
            }
        } else {
            Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, WebApplication.class, (boolean)false, (boolean)false);
            if (beans.size() == 0) {
                throw new IllegalStateException("bean of type [" + WebApplication.class.getName() + "] not found");
            }
            if (beans.size() > 1) {
                throw new IllegalStateException("More than one bean of type [" + WebApplication.class.getName() + "] found, must have only one");
            }
            application = (WebApplication)beans.values().iterator().next();
        }
        SpringComponentInjector.setDefaultContext(application, applicationContext);
        return application;
    }

    protected final ConfigurableWebApplicationContext createWebApplicationContext(WebApplicationContext parent, WicketFilter filter) throws BeansException {
        this.webApplicationContext = this.newApplicationContext();
        this.webApplicationContext.setParent((ApplicationContext)parent);
        this.webApplicationContext.setServletContext(filter.getFilterConfig().getServletContext());
        this.webApplicationContext.setConfigLocation(this.getContextConfigLocation(filter));
        this.postProcessWebApplicationContext(this.webApplicationContext, filter);
        this.webApplicationContext.refresh();
        return this.webApplicationContext;
    }

    protected void postProcessWebApplicationContext(ConfigurableWebApplicationContext wac, WicketFilter filter) {
    }

    public void destroy(WicketFilter filter) {
        if (this.webApplicationContext != null) {
            this.webApplicationContext.close();
        }
    }
}

