/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import org.apache.wicket.Component;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.authentication.strategy.DefaultAuthenticationStrategy;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.IUnauthorizedResourceRequestListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.coep.CrossOriginEmbedderPolicyConfiguration;
import org.apache.wicket.coop.CrossOriginOpenerPolicyConfiguration;
import org.apache.wicket.core.random.DefaultSecureRandomSupplier;
import org.apache.wicket.core.random.ISecureRandomSupplier;
import org.apache.wicket.core.util.crypt.KeyInSessionSunJceCryptFactory;
import org.apache.wicket.settings.DefaultUnauthorizedResourceRequestListener;
import org.apache.wicket.util.crypt.ICryptFactory;
import org.apache.wicket.util.crypt.SunJceCrypt;
import org.apache.wicket.util.lang.Args;

public class SecuritySettings {
    private IAuthorizationStrategy authorizationStrategy = IAuthorizationStrategy.ALLOW_ALL;
    private IAuthenticationStrategy authenticationStrategy;
    private ICryptFactory cryptFactory;
    private ISecureRandomSupplier randomSupplier = new DefaultSecureRandomSupplier();
    private boolean enforceMounts = false;
    private CrossOriginOpenerPolicyConfiguration crossOriginOpenerPolicyConfiguration = new CrossOriginOpenerPolicyConfiguration(CrossOriginOpenerPolicyConfiguration.CoopMode.SAME_ORIGIN);
    private CrossOriginEmbedderPolicyConfiguration crossOriginEmbedderPolicyConfiguration = new CrossOriginEmbedderPolicyConfiguration(CrossOriginEmbedderPolicyConfiguration.CoepMode.REPORTING);
    private static final IUnauthorizedComponentInstantiationListener DEFAULT_UNAUTHORIZED_COMPONENT_INSTANTIATION_LISTENER = new IUnauthorizedComponentInstantiationListener(){

        @Override
        public void onUnauthorizedInstantiation(Component component) {
            throw new UnauthorizedInstantiationException(component.getClass());
        }
    };
    private IUnauthorizedComponentInstantiationListener unauthorizedComponentInstantiationListener = DEFAULT_UNAUTHORIZED_COMPONENT_INSTANTIATION_LISTENER;
    private static final IUnauthorizedResourceRequestListener DEFAULT_UNAUTHORIZED_RESOURCE_REQUEST_LISTENER = new DefaultUnauthorizedResourceRequestListener();
    private IUnauthorizedResourceRequestListener unauthorizedResourceRequestListener = DEFAULT_UNAUTHORIZED_RESOURCE_REQUEST_LISTENER;

    public IAuthorizationStrategy getAuthorizationStrategy() {
        return this.authorizationStrategy;
    }

    public synchronized ICryptFactory getCryptFactory() {
        if (this.cryptFactory == null) {
            this.cryptFactory = new KeyInSessionSunJceCryptFactory();
        }
        return this.cryptFactory;
    }

    public ISecureRandomSupplier getRandomSupplier() {
        return this.randomSupplier;
    }

    public boolean getEnforceMounts() {
        return this.enforceMounts;
    }

    public IUnauthorizedComponentInstantiationListener getUnauthorizedComponentInstantiationListener() {
        return this.unauthorizedComponentInstantiationListener;
    }

    public SecuritySettings setAuthorizationStrategy(IAuthorizationStrategy strategy) {
        Args.notNull(strategy, "strategy");
        this.authorizationStrategy = strategy;
        return this;
    }

    public SecuritySettings setCryptFactory(ICryptFactory cryptFactory) {
        Args.notNull(cryptFactory, "cryptFactory");
        this.cryptFactory = cryptFactory;
        return this;
    }

    public SecuritySettings setRandomSupplier(ISecureRandomSupplier randomSupplier) {
        Args.notNull(randomSupplier, "randomSupplier");
        this.randomSupplier = randomSupplier;
        return this;
    }

    public SecuritySettings setEnforceMounts(boolean enforce) {
        this.enforceMounts = enforce;
        return this;
    }

    public SecuritySettings setUnauthorizedComponentInstantiationListener(IUnauthorizedComponentInstantiationListener listener) {
        this.unauthorizedComponentInstantiationListener = listener == null ? DEFAULT_UNAUTHORIZED_COMPONENT_INSTANTIATION_LISTENER : listener;
        return this;
    }

    public IUnauthorizedResourceRequestListener getUnauthorizedResourceRequestListener() {
        return this.unauthorizedResourceRequestListener;
    }

    public SecuritySettings setUnauthorizedResourceRequestListener(IUnauthorizedResourceRequestListener listener) {
        this.unauthorizedResourceRequestListener = listener == null ? DEFAULT_UNAUTHORIZED_RESOURCE_REQUEST_LISTENER : listener;
        return this;
    }

    public IAuthenticationStrategy getAuthenticationStrategy() {
        if (this.authenticationStrategy == null) {
            this.authenticationStrategy = new DefaultAuthenticationStrategy("LoggedIn", new SunJceCrypt(SunJceCrypt.randomSalt(), 17));
        }
        return this.authenticationStrategy;
    }

    public SecuritySettings setAuthenticationStrategy(IAuthenticationStrategy strategy) {
        this.authenticationStrategy = strategy;
        return this;
    }

    public CrossOriginOpenerPolicyConfiguration getCrossOriginOpenerPolicyConfiguration() {
        return this.crossOriginOpenerPolicyConfiguration;
    }

    public SecuritySettings setCrossOriginOpenerPolicyConfiguration(CrossOriginOpenerPolicyConfiguration.CoopMode mode, String ... exemptions) {
        this.crossOriginOpenerPolicyConfiguration = new CrossOriginOpenerPolicyConfiguration(mode, exemptions);
        return this;
    }

    public CrossOriginEmbedderPolicyConfiguration getCrossOriginEmbedderPolicyConfiguration() {
        return this.crossOriginEmbedderPolicyConfiguration;
    }

    public SecuritySettings setCrossOriginEmbedderPolicyConfiguration(CrossOriginEmbedderPolicyConfiguration.CoepMode mode, String ... exemptions) {
        this.crossOriginEmbedderPolicyConfiguration = new CrossOriginEmbedderPolicyConfiguration(mode, exemptions);
        return this;
    }
}

