/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.core.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.CssPackageResource;
import org.apache.wicket.request.resource.JavaScriptPackageResource;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.ResourceUtil;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageResourceReference
extends ResourceReference {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PackageResourceReference.class);
    private static final String CSS_EXTENSION = "css";
    private static final String JAVASCRIPT_EXTENSION = "js";
    private transient ConcurrentMap<ResourceReference.UrlAttributes, ResourceReference.UrlAttributes> urlAttributesCacheMap;
    private boolean readBuffered = true;

    public PackageResourceReference(ResourceReference.Key key) {
        super(key);
    }

    public PackageResourceReference(Class<?> scope, String name, Locale locale, String style, String variation) {
        super(scope, name, locale, style, variation);
    }

    public PackageResourceReference(Class<?> scope, String name) {
        super(scope, name);
    }

    public PackageResourceReference(String name) {
        super(name);
    }

    @Override
    public PackageResource getResource() {
        String extension = this.getExtension();
        RequestCycle requestCycle = RequestCycle.get();
        ResourceReference.UrlAttributes urlAttributes = null;
        if (requestCycle != null) {
            Url url = requestCycle.getRequest().getUrl();
            urlAttributes = ResourceUtil.decodeResourceReferenceAttributes(url);
        }
        String currentVariation = this.getCurrentVariation(urlAttributes);
        String currentStyle = this.getCurrentStyle(urlAttributes);
        Locale currentLocale = this.getCurrentLocale(urlAttributes);
        Class<?> scope = this.getScope();
        String name = this.getName();
        PackageResource resource = CSS_EXTENSION.equals(extension) ? new CssPackageResource(scope, name, currentLocale, currentStyle, currentVariation) : (JAVASCRIPT_EXTENSION.equals(extension) ? new JavaScriptPackageResource(scope, name, currentLocale, currentStyle, currentVariation) : new PackageResource(scope, name, currentLocale, currentStyle, currentVariation));
        resource.readBuffered(this.readBuffered);
        this.removeCompressFlagIfUnnecessary(resource);
        return resource;
    }

    protected final void removeCompressFlagIfUnnecessary(PackageResource resource) {
        String minifiedName = this.getName();
        if (minifiedName != null && minifiedName.contains(".min.")) {
            resource.setCompress(false);
        }
    }

    private ResourceReference.UrlAttributes getUrlAttributes(Locale locale, String style, String variation) {
        IResourceStreamLocator locator = Application.get().getResourceSettings().getResourceStreamLocator();
        String absolutePath = Packages.absolutePath(this.getScope(), this.getName());
        IResourceStream stream = locator.locate(this.getScope(), absolutePath, style, variation, locale, null, false);
        if (stream == null) {
            return new ResourceReference.UrlAttributes(null, null, null);
        }
        return new ResourceReference.UrlAttributes(stream.getLocale(), stream.getStyle(), stream.getVariation());
    }

    private Locale getCurrentLocale(ResourceReference.UrlAttributes attributes) {
        Locale currentLocale = this.getCurrentLocale();
        return currentLocale != null ? currentLocale : (attributes != null ? attributes.getLocale() : null);
    }

    private Locale getCurrentLocale() {
        Locale locale = this.getLocale();
        if (locale != null) {
            return locale;
        }
        if (Session.exists()) {
            return Session.get().getLocale();
        }
        return locale;
    }

    private String getCurrentStyle(ResourceReference.UrlAttributes attributes) {
        String currentStyle = this.getCurrentStyle();
        return currentStyle != null ? currentStyle : (attributes != null ? attributes.getStyle() : null);
    }

    private String getCurrentStyle() {
        String style = this.getStyle();
        if (style != null) {
            return style;
        }
        if (Session.exists()) {
            return Session.get().getStyle();
        }
        return style;
    }

    private String getCurrentVariation(ResourceReference.UrlAttributes attributes) {
        String variation = this.getVariation();
        return variation != null ? variation : (attributes != null ? attributes.getVariation() : null);
    }

    protected String getMinifiedName() {
        String name = super.getName();
        return ResourceUtils.getMinifiedName(name, "min");
    }

    @Override
    public ResourceReference.UrlAttributes getUrlAttributes() {
        ResourceReference.UrlAttributes tmpValue;
        ResourceReference.UrlAttributes value;
        Locale locale = this.getCurrentLocale();
        String style = this.getCurrentStyle();
        String variation = this.getVariation();
        ResourceReference.UrlAttributes key = new ResourceReference.UrlAttributes(locale, style, variation);
        if (this.urlAttributesCacheMap == null) {
            this.urlAttributesCacheMap = Generics.newConcurrentHashMap();
        }
        if ((value = (ResourceReference.UrlAttributes)this.urlAttributesCacheMap.get(key)) == null && (tmpValue = this.urlAttributesCacheMap.putIfAbsent(key, value = this.getUrlAttributes(locale, style, variation))) != null) {
            value = tmpValue;
        }
        return value;
    }

    public PackageResourceReference readBuffered(boolean readBuffered) {
        this.readBuffered = readBuffered;
        return this;
    }
}

