/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.mock;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.UUID;
import org.apache.wicket.Session;
import org.apache.wicket.util.tester.BaseWicketTester;
import org.apache.wicket.util.value.ValueMap;

public class MockHttpSession
implements HttpSession,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ValueMap attributes = new ValueMap();
    private final transient ServletContext context;
    private final long creationTime = System.currentTimeMillis();
    private String id = MockHttpSession.generateSessionId();
    private long lastAccessedTime = 0L;
    private boolean temporary = true;

    public MockHttpSession(ServletContext context) {
        this.context = context;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public int getMaxInactiveInterval() {
        return 0;
    }

    @Override
    public ServletContext getServletContext() {
        return this.context;
    }

    @Override
    public void invalidate() {
        Session session = (Session)this.attributes.get("wicket:" + BaseWicketTester.TestFilterConfig.class.getName() + ":session");
        if (session != null) {
            session.onInvalidate();
        }
        this.attributes.clear();
        this.id = MockHttpSession.generateSessionId();
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    @Override
    public void setMaxInactiveInterval(int i) {
    }

    public void timestamp() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public final boolean isTemporary() {
        return this.temporary;
    }

    public final void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    private static String generateSessionId() {
        return UUID.randomUUID().toString().replace(':', '_').replace('-', '_');
    }
}

