/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.mock;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.apache.wicket.protocol.http.IMetaDataBufferingWebResponse;
import org.apache.wicket.protocol.http.mock.Cookies;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.value.ValueMap;

public class MockHttpServletResponse
implements HttpServletResponse,
IMetaDataBufferingWebResponse {
    private static final int MODE_BINARY = 1;
    private static final int MODE_NONE = 0;
    private static final int MODE_TEXT = 2;
    private ByteArrayOutputStream byteStream;
    private String characterEncoding = "UTF-8";
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private String errorMessage = null;
    private final ValueMap headers = new ValueMap();
    private Locale locale = null;
    private int mode = 0;
    private PrintWriter printWriter;
    private String redirectLocation = null;
    private ServletOutputStream servletStream;
    private int status = 200;
    private StringWriter stringWriter;
    private static String[] DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};

    public MockHttpServletResponse(MockHttpServletRequest servletRequest) {
        this.initialize();
    }

    @Override
    public void addCookie(Cookie cookie) {
        Iterator<Cookie> iterator = this.cookies.iterator();
        while (iterator.hasNext()) {
            Cookie old = iterator.next();
            if (!Cookies.isEqual(cookie, old)) continue;
            iterator.remove();
        }
        this.cookies.add(cookie);
    }

    @Override
    public void addDateHeader(String name, long l) {
        DateFormat df = DateFormat.getDateInstance(0);
        this.addHeader(name, df.format(new Date(l)));
    }

    @Override
    public void addHeader(String name, String value) {
        ArrayList<String> list = (ArrayList<String>)this.headers.get(name);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.headers.put(name, (Object)list);
        }
        list.add(value);
    }

    @Override
    public void addIntHeader(String name, int i) {
        this.addHeader(name, "" + i);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public String encodeRedirectURL(String url) {
        return url;
    }

    @Override
    public String encodeURL(String url) {
        return url;
    }

    @Override
    public void flushBuffer() throws IOException {
    }

    public byte[] getBinaryContent() {
        return this.byteStream.toByteArray();
    }

    @Override
    public int getBufferSize() {
        if (this.mode == 0) {
            return 0;
        }
        if (this.mode == 1) {
            return this.byteStream.size();
        }
        return this.stringWriter.getBuffer().length();
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public List<Cookie> getCookies() {
        ArrayList<Cookie> copies = new ArrayList<Cookie>();
        for (Cookie cookie : this.cookies) {
            copies.add(Cookies.copyOf(cookie));
        }
        return copies;
    }

    public String getDocument() {
        if (this.mode == 1) {
            return new String(this.byteStream.toByteArray());
        }
        return this.stringWriter.getBuffer().toString();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getHeader(String name) {
        List l = (List)this.headers.get(name);
        if (l == null || l.size() < 1) {
            return null;
        }
        return (String)l.get(0);
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public ServletOutputStream getOutputStream() {
        if (this.mode == 2) {
            throw new IllegalArgumentException("Can't write binary after already selecting text");
        }
        this.mode = 1;
        return this.servletStream;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.mode == 1) {
            throw new IllegalArgumentException("Can't write text after already selecting binary");
        }
        this.mode = 2;
        return this.printWriter;
    }

    public void initialize() {
        this.cookies.clear();
        this.headers.clear();
        this.errorMessage = null;
        this.redirectLocation = null;
        this.status = 200;
        this.characterEncoding = "UTF-8";
        this.locale = null;
        this.byteStream = new ByteArrayOutputStream();
        this.servletStream = new ServletOutputStream(){

            @Override
            public boolean isReady() {
                return true;
            }

            @Override
            public void setWriteListener(WriteListener writeListener) {
            }

            @Override
            public void write(int b) {
                MockHttpServletResponse.this.byteStream.write(b);
            }
        };
        this.stringWriter = new StringWriter();
        this.printWriter = new PrintWriter(this.stringWriter){

            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }
        };
        this.mode = 0;
    }

    @Override
    public boolean isCommitted() {
        return false;
    }

    public boolean isError() {
        return this.status != 200;
    }

    public boolean isRedirect() {
        return this.redirectLocation != null;
    }

    @Override
    public void reset() {
        this.initialize();
    }

    @Override
    public void resetBuffer() {
        if (this.mode == 1) {
            this.byteStream.reset();
        } else if (this.mode == 2) {
            this.stringWriter.getBuffer().delete(0, this.stringWriter.getBuffer().length());
        }
    }

    @Override
    public void sendError(int code) throws IOException {
        this.status = code;
        this.errorMessage = null;
    }

    @Override
    public void sendError(int code, String msg) throws IOException {
        this.status = code;
        this.errorMessage = msg;
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.redirectLocation = location;
        this.status = 302;
    }

    @Override
    public void setBufferSize(int size) {
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    @Override
    public void setContentLength(int length) {
        this.setIntHeader("Content-Length", length);
    }

    @Override
    public void setContentLengthLong(long len) {
        this.setContentLength((int)len);
    }

    @Override
    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public void setDateHeader(String name, long l) {
        this.setHeader(name, MockHttpServletResponse.formatDate(l));
    }

    public static String formatDate(long l) {
        StringBuilder _dateBuffer = new StringBuilder(32);
        GregorianCalendar _calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        _calendar.setTimeInMillis(l);
        MockHttpServletResponse.formatDate(_dateBuffer, _calendar, false);
        return _dateBuffer.toString();
    }

    public static void formatDate(StringBuilder buf, Calendar calendar, boolean cookie) {
        int day_of_week = calendar.get(7);
        int day_of_month = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        int century = year / 100;
        year %= 100;
        int epoch = (int)(calendar.getTimeInMillis() / 1000L % 86400L);
        int seconds = epoch % 60;
        int minutes = (epoch /= 60) % 60;
        int hours = epoch / 60;
        buf.append(DAYS[day_of_week]);
        buf.append(',');
        buf.append(' ');
        MockHttpServletResponse.append2digits(buf, day_of_month);
        if (cookie) {
            buf.append('-');
            buf.append(MONTHS[month]);
            buf.append('-');
            MockHttpServletResponse.append2digits(buf, year);
        } else {
            buf.append(' ');
            buf.append(MONTHS[month]);
            buf.append(' ');
            MockHttpServletResponse.append2digits(buf, century);
            MockHttpServletResponse.append2digits(buf, year);
        }
        buf.append(' ');
        MockHttpServletResponse.append2digits(buf, hours);
        buf.append(':');
        MockHttpServletResponse.append2digits(buf, minutes);
        buf.append(':');
        MockHttpServletResponse.append2digits(buf, seconds);
        buf.append(" GMT");
    }

    public static void append2digits(StringBuilder buf, int i) {
        if (i < 100) {
            buf.append((char)(i / 10 + 48));
            buf.append((char)(i % 10 + 48));
        }
    }

    @Override
    public void setHeader(String name, String value) {
        ArrayList<String> l = new ArrayList<String>(1);
        l.add(value);
        this.headers.put(name, (Object)l);
    }

    @Override
    public void setIntHeader(String name, int i) {
        this.setHeader(name, "" + i);
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    public String getBinaryResponse() {
        String ctheader = this.getHeader("Content-Length");
        if (ctheader == null) {
            return this.getDocument();
        }
        return this.getDocument().substring(0, Integer.valueOf(ctheader));
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return Collections.singletonList(this.headers.get(name).toString());
    }

    @Override
    public void writeMetaData(WebResponse webResponse) {
        for (Cookie cookie : this.cookies) {
            webResponse.addCookie(cookie);
        }
        for (String name : this.headers.keySet()) {
            webResponse.setHeader(name, this.headers.get(name).toString());
        }
        webResponse.setStatus(this.status);
    }
}

