/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.mock;

import jakarta.servlet.http.Cookie;
import java.io.Serializable;
import java.util.Objects;
import org.apache.wicket.util.lang.Args;

public final class Cookies {
    private Cookies() {
    }

    public static Cookie copyOf(Cookie cookie) {
        return cookie != null ? (Cookie)cookie.clone() : null;
    }

    public static Key keyOf(Cookie cookie) {
        return new Key(cookie);
    }

    public static boolean isEqual(Cookie c1, Cookie c2) {
        Args.notNull(c1, "c1");
        Args.notNull(c2, "c2");
        return new Key(c1).equals(new Key(c2));
    }

    public static boolean isExpired(Cookie cookie) {
        return cookie.getMaxAge() == 0;
    }

    public static class Key
    implements Serializable {
        private final String name;
        private final String path;
        private final String domain;

        protected Key(Cookie cookie) {
            Args.notNull(cookie, "cookie");
            this.name = cookie.getName();
            this.path = cookie.getPath();
            this.domain = cookie.getDomain();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.domain, other.domain) && Objects.equals(this.name, other.name) && Objects.equals(this.path, other.path);
        }

        public String toString() {
            return this.name + ";" + this.domain + "/" + this.path;
        }
    }
}

