/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WicketServlet.class);
    protected transient WicketFilter wicketFilter;

    @Override
    public final void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        if (!this.wicketFilter.processRequest(servletRequest, servletResponse, null)) {
            this.fallback(servletRequest, servletResponse);
        }
    }

    @Override
    public final void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        if (!this.wicketFilter.processRequest(servletRequest, servletResponse, null)) {
            this.fallback(servletRequest, servletResponse);
        }
    }

    private static String getURL(HttpServletRequest httpServletRequest) {
        String queryString;
        Object url = httpServletRequest.getServletPath();
        String pathInfo = httpServletRequest.getPathInfo();
        if (pathInfo != null) {
            url = (String)url + pathInfo;
        }
        if ((queryString = httpServletRequest.getQueryString()) != null) {
            url = (String)url + "?" + queryString;
        }
        if (((String)url).length() > 0 && ((String)url).charAt(0) == '/') {
            url = ((String)url).substring(1);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fallback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Object url = WicketServlet.getURL(request);
        if (((String)url).indexOf(63) != -1) {
            url = Strings.beforeFirst((String)url, '?');
        }
        if (((String)url).length() > 0 && ((String)url).charAt(0) != '/' || ((String)url).length() == 0) {
            url = "/" + (String)url;
        }
        InputStream stream = this.getServletContext().getResourceAsStream((String)url);
        String mimeType = this.getServletContext().getMimeType((String)url);
        if (stream == null) {
            if (response.isCommitted()) {
                response.setStatus(404);
            } else {
                response.sendError(404);
            }
        } else {
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
            try {
                Streams.copy(stream, response.getOutputStream());
            }
            finally {
                stream.close();
            }
        }
    }

    @Override
    public void init() throws ServletException {
        this.wicketFilter = this.newWicketFilter();
        this.wicketFilter.init(true, new FilterConfig(){

            @Override
            public ServletContext getServletContext() {
                return WicketServlet.this.getServletContext();
            }

            @Override
            public Enumeration<String> getInitParameterNames() {
                return WicketServlet.this.getInitParameterNames();
            }

            @Override
            public String getInitParameter(String name) {
                return WicketServlet.this.getInitParameter(name);
            }

            @Override
            public String getFilterName() {
                return WicketServlet.this.getServletName();
            }
        });
    }

    protected WicketFilter newWicketFilter() {
        return new WicketFilter();
    }

    @Override
    public void destroy() {
        this.wicketFilter.destroy();
        this.wicketFilter = null;
    }
}

