/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.settings.RequestLoggerSettings;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class RequestLoggerRequestCycleListener
implements IRequestCycleListener {
    private static final ThreadLocal<IRequestHandler> first = new ThreadLocal();

    @Override
    public void onBeginRequest(RequestCycle cycle) {
        if (!this.isRequestLoggingEnabled()) {
            return;
        }
        this.registerRequestedUrl(cycle);
    }

    @Override
    public void onRequestHandlerScheduled(RequestCycle cycle, IRequestHandler handler) {
        if (!this.isRequestLoggingEnabled()) {
            return;
        }
        this.registerHandler(handler);
    }

    @Override
    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        if (!this.isRequestLoggingEnabled()) {
            return;
        }
        this.registerHandler(handler);
    }

    @Override
    public void onExceptionRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler, Exception exception) {
        if (!this.isRequestLoggingEnabled()) {
            return;
        }
        this.registerHandler(handler);
    }

    @Override
    public void onEndRequest(RequestCycle cycle) {
        first.remove();
    }

    private boolean isRequestLoggingEnabled() {
        IRequestLogger requestLogger = Application.get().getRequestLogger();
        RequestLoggerSettings settings = Application.get().getRequestLoggerSettings();
        return requestLogger != null && settings.isRequestLoggerEnabled();
    }

    private void registerRequestedUrl(RequestCycle cycle) {
        IRequestLogger requestLogger = Application.get().getRequestLogger();
        if (cycle.getRequest().getContainerRequest() instanceof HttpServletRequest) {
            HttpServletRequest containerRequest = (HttpServletRequest)cycle.getRequest().getContainerRequest();
            AppendingStringBuffer url = new AppendingStringBuffer(containerRequest.getRequestURL());
            if (containerRequest.getQueryString() != null) {
                url.append("?").append(containerRequest.getQueryString());
            }
            requestLogger.logRequestedUrl(url.toString());
        }
    }

    private void registerHandler(IRequestHandler handler) {
        IRequestLogger requestLogger = Application.get().getRequestLogger();
        if (first.get() == null) {
            first.set(handler);
            requestLogger.logEventTarget(handler);
        }
        requestLogger.logResponseTarget(handler);
    }
}

